/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.filter;

import com.ontotext.trree.plugin.externalsync.filter.AbstractComparisonExpression;
import com.ontotext.trree.plugin.externalsync.filter.ConstantOperand;
import com.ontotext.trree.plugin.externalsync.filter.FilterUtil;
import com.ontotext.trree.plugin.externalsync.filter.Operand;
import com.ontotext.trree.plugin.externalsync.filter.ValueIterator;
import com.ontotext.trree.plugin.externalsync.filter.ValueProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;

public class InExpression
extends AbstractComparisonExpression {
    private final List<Operand> valueOperands;
    private final Set<Value> staticValues;
    private final List<Operand> dynamicValueOperands;

    public InExpression(Operand operand, List<Operand> valueOperands) {
        super(operand);
        this.valueOperands = valueOperands;
        this.staticValues = new HashSet<Value>();
        this.dynamicValueOperands = new ArrayList<Operand>();
        for (Operand vo : valueOperands) {
            if (vo instanceof ConstantOperand) {
                this.staticValues.add(((ConstantOperand)vo).value);
                continue;
            }
            if (vo.matchAll) {
                throw new RuntimeException("Using ALL() inside IN() is not supported");
            }
            this.dynamicValueOperands.add(vo);
        }
    }

    @Override
    protected boolean evaluateSingleValue(ValueProvider valueProvider, Value value, long valueId) {
        boolean result = this.staticValues.contains(value);
        if (!result) {
            block6: for (Operand vo : this.dynamicValueOperands) {
                ValueIterator vit = FilterUtil.getOperandValues(vo, valueProvider);
                try {
                    while (vit.next()) {
                        Value validValue = vit.value();
                        if (!validValue.equals((Object)value)) continue;
                        result = true;
                        break block6;
                    }
                }
                finally {
                    if (vit == null) continue;
                    vit.close();
                }
            }
        }
        return result;
    }

    @Override
    protected List<Operand> getOperands() {
        ArrayList<Operand> list = new ArrayList<Operand>(1 + this.valueOperands.size());
        list.add(this.operand);
        list.addAll(this.valueOperands);
        return list;
    }
}

