/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync;

import com.google.common.collect.ImmutableList;
import com.ontotext.license.License;
import com.ontotext.trree.plugin.externalsync.ConnectorPredicate;
import com.ontotext.trree.plugin.externalsync.ControlPredicate;
import com.ontotext.trree.plugin.externalsync.EntityUpdateListener;
import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.SearchOptions;
import com.ontotext.trree.plugin.externalsync.StoresManager;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucketItem;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsParser;
import com.ontotext.trree.plugin.externalsync.config.OptionsValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.ListValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.URIValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import com.ontotext.trree.plugin.externalsync.impl.FieldNameTransform;
import com.ontotext.trree.plugin.externalsync.iterators.DummyIterator;
import com.ontotext.trree.plugin.externalsync.iterators.StatusIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.AbstractResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.NeedsMasterResult;
import com.ontotext.trree.plugin.externalsync.iterators.master.ObjectMayBeBound;
import com.ontotext.trree.plugin.externalsync.iterators.master.TotalHitsIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.aggregations.AggregationBucketItemIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.aggregations.AggregationResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.aggregations.NeedsAggregationResult;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.EntityResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.NeedsEntityResult;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.ScoreIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.snippet.NeedsSnippetResult;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.snippet.SnippetFieldIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.snippet.SnippetInnerFieldIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.snippet.SnippetResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.entity.snippet.SnippetTextIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.facet.FacetCountIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.facet.FacetPredicateIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.facet.FacetResultIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.facet.FacetValueIterator;
import com.ontotext.trree.plugin.externalsync.iterators.master.facet.NeedsFacetResult;
import com.ontotext.trree.plugin.externalsync.model.TemporaryGraph;
import com.ontotext.trree.sdk.BadRequestException;
import com.ontotext.trree.sdk.ClearInterpreter;
import com.ontotext.trree.sdk.CompositeHealthResult;
import com.ontotext.trree.sdk.ContextUpdateHandler;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthCheckable;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.InternalServerErrorException;
import com.ontotext.trree.sdk.ParallelPlugin;
import com.ontotext.trree.sdk.ParallelTransactionListener;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginExecutorService;
import com.ontotext.trree.sdk.Postprocessor;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.Statements;
import com.ontotext.trree.sdk.UpdateInterpreter;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectProcedure;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.rdf4j.common.iterator.SingletonIterator;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserFactory;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class ExternalSyncPlugin
extends PluginBase
implements PatternInterpreter,
UpdateInterpreter,
Preprocessor,
Postprocessor,
ClearInterpreter,
HealthCheckable,
ContextUpdateHandler,
ParallelPlugin,
StatementListener,
ParallelTransactionListener {
    public static final int IMPLEMENTATION_VERSION_MAJOR = 3;
    public static final int IMPLEMENTATION_VERSION_MINOR = 0;
    public static final String IMPLEMENTATION_VERSION = "3.0";
    public static final String FIELD_INDEXED = "indexed";
    public static final String FIELD_STORED = "stored";
    public static final String FIELD_ANALYZED = "analyzed";
    public static final String FIELD_MULTIVALUED = "multivalued";
    public static final String FIELD_FACET = "facet";
    public static final String FIELD_FIELDDATA = "fielddata";
    public static final String FIELD_ARRAY = "array";
    public static final String FIELD_ANALYZER = "analyzer";
    public static final String FIELD_DEFAULT_VALUE = "defaultValue";
    public static final String FIELD_DATATYPE = "datatype";
    public static final String FIELD_IGNORE_INVALID_VALUES = "ignoreInvalidValues";
    public static final String FIELD_NATIVE_SETTINGS = "nativeSettings";
    public static final String FIELDS_PROPERTY_CHAIN = "propertyChain";
    public static final String FIELDS_FIELD_NAME = "fieldName";
    public static final String FIELDS_FIELD_NAME_TRANSFORM = "fieldNameTransform";
    public static final String FIELDS_PARAM_NAME = "fields";
    public static final String OBJECT_NAME = "objectFields";
    public static final String BULK_UPDATE_BATCH_SIZE_NAME = "bulkUpdateBatchSize";
    public static final String BULK_UPDATE_REQUEST_SIZE_NAME = "bulkUpdateRequestSize";
    public static final String AUTHENTICATION_CONFIGURATOR_CLASS_NAME = "authenticationConfiguratorClass";
    protected static final double NULLARY_LEVEL_ESTIMATE = 0.01;
    protected static final double NULLARY_LEVEL_INFINITY = Double.POSITIVE_INFINITY;
    protected static final double PRIMARY_LEVEL_ESTIMATE = 0.1;
    protected static final double PRIMARY_LEVEL_INFINITY = 1.1;
    protected static final double SECONDARY_LEVEL_ESTIMATE = 0.2;
    protected static final double SECONDARY_LEVEL_INFINITY = 1.2;
    protected static final double TERTIARY_LEVEL_ESTIMATE = 0.3;
    protected static final double TERTIARY_LEVEL_INFINITY = 1.3;
    protected static final double QUATERNARY_LEVEL_ESTIMATE = 0.4;
    protected static final double QUATERNARY_LEVEL_INFINITY = 1.4;
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("external-sync-option-description", Locale.getDefault());
    public static final Option<List<Option<?>>> FIELDS_PLACEHOLDER = Option.optionList("fields").defaultValue(Collections.emptyList()).build();
    private static final String LANGUAGES_PARAM_NAME = "languages";
    public static final Option<List<String>> LANGUAGES = Option.stringList("languages", RESOURCE_BUNDLE).build();
    public static final String TYPE_PARAM_NAME = "types";
    public static final Option<List<String>> TYPES = Option.stringList("types", RESOURCE_BUNDLE).withValidator(new TypesValidator()).required().build();
    private static final String ENTITY_FILTER_PARAM_NAME = "entityFilter";
    public static final Option<String> ENTITY_FILTER = Option.bigString("entityFilter", RESOURCE_BUNDLE).deprecated().build();
    public static final String DOCUMENT_FILTER_PARAM_NAME = "documentFilter";
    public static final Option<String> DOCUMENT_FILTER = Option.bigString("documentFilter", RESOURCE_BUNDLE).build();
    public static final String VALUE_FILTER_PARAM_NAME = "valueFilter";
    public static final Option<String> VALUE_FILTER = Option.bigString("valueFilter", RESOURCE_BUNDLE).build();
    private static final String READONLY_PARAM_NAME = "readonly";
    public static final Option<Boolean> READONLY = Option.flag("readonly", RESOURCE_BUNDLE).defaultValue(false).build();
    private static final String DETECT_FIELDS_PARAM_NAME = "detectFields";
    public static final Option<Boolean> DETECT_FIELDS = Option.flag("detectFields", RESOURCE_BUNDLE).defaultValue(false).build();
    private static final String IMPORT_FILE_PARAM_NAME = "importFile";
    public static final Option<String> IMPORT_FILE = Option.string("importFile", RESOURCE_BUNDLE).build();
    private static final String IMPORT_GRAPH_PARAM_NAME = "importGraph";
    public static final Option<Boolean> IMPORT_GRAPH = Option.flag("importGraph", RESOURCE_BUNDLE).defaultValue(false).build();
    private static final String SKIP_INITIAL_INDEXING_NAME = "skipInitialIndexing";
    public static final Option<Boolean> SKIP_INITIAL_INDEXING = Option.flag("skipInitialIndexing", RESOURCE_BUNDLE).defaultValue(false).build();
    public static final String START_FROM_PARENT_NAME = "startFromParent";
    public static final Option<Long> START_FROM_PARENT = Option.longNumber("startFromParent", RESOURCE_BUNDLE).defaultValue(0L).build();
    public static final ImmutableList<Option<?>> DEFAULT_OPTIONS = ImmutableList.builder().add(LANGUAGES).add(TYPES).add(ENTITY_FILTER).add(VALUE_FILTER).add(DOCUMENT_FILTER).add(READONLY).add(DETECT_FIELDS).add(IMPORT_GRAPH).add(IMPORT_FILE).add(SKIP_INITIAL_INDEXING).build();
    StoresManager storesManager;
    private TemporaryGraph temporaryGraph;
    private boolean useCollectionModel;
    PluginExecutorService executorService;
    private final Map<ConnectorPredicate, IRI> urisForControlPredicates;
    protected ValueFactory valueFactory = SimpleValueFactory.getInstance();
    TLongObjectHashMap<ExternalStore> searchPredicates;
    private Map<IRI, ExternalStore> currentlyBeingBuilt;
    private long discoveryPredicateId;
    private long createPredicateId;
    private long repairPredicateId;
    private long updatePredicateId;
    private long listPredicateId;
    private long listOptionsPredicateId;
    private long dropPredicateId;
    private long connectorStatusPredicateId;
    private long queryPredicateId;
    private long searchOptionExtraOptions;
    private long searchOptionFacetFieldsId;
    private long searchOptionFacetLimitId;
    private long searchOptionOrderById;
    private long searchOptionLimitId;
    private long searchOptionOffsetId;
    private long searchOptionSnippetSize;
    private long searchOptionSnippetPreId;
    private long searchOptionSnippetPostId;
    private long[] searchOptionsIds;
    private long entityResultPredicateId;
    private long scorePredicateId;
    private long facetResultPredicateId;
    private long facetPredicatePredicateId;
    private long facetValuePredicateId;
    private long facetCountPredicateId;
    private long aggregationsResultPredicateId;
    private long[] bucketPredicateIds;
    private long snippetResultPredicateId;
    private long snippetFieldPredicateId;
    private long snippetTextPredicateId;
    private long snippetInnerFieldPredicateId;
    private long syncedFieldPredicateId;
    private long totalHitsPredicateId;
    private long apiOptionsPredicateId;
    private long rdfTypeId;
    private TLongObjectHashMap<Class<?>> predicateToIteratorMap;
    private TLongObjectHashMap<FlexibleBucketItem> predicateToItemNameMap;
    private long pluginPrefixID;
    EntityUpdateListener entityUpdateListener;
    private String uriPrefixControl = String.format("http://www.ontotext.com/connectors/%s#", this.getURIComponent());
    private String uriPrefixInstance = String.format("http://www.ontotext.com/connectors/%s/instance#", this.getURIComponent());
    private int entityIdSize;
    private boolean initialized = false;

    public static Option<List<Option<?>>> createFieldsOptions(Option<?> ... extraChildOptions) {
        return ExternalSyncPlugin.createFieldsOptions(FIELDS_PARAM_NAME, extraChildOptions);
    }

    public static Option<List<Option<?>>> createFieldsOptions(String paramName, Option<?> ... extraChildOptions) {
        return ExternalSyncPlugin.createFieldsOptions(paramName, true, true, true, extraChildOptions);
    }

    public static Option<List<Option<?>>> createFieldsOptions(String paramName, boolean hasDatatype, boolean hasStored, boolean hasAnalyzed, Option<?> ... extraChildOptions) {
        Option.OptionBuilder<List<Option<Object>>> builder = Option.optionList(paramName, RESOURCE_BUNDLE).withValidator(new PropertiesValidator()).childOption(Option.string(FIELDS_FIELD_NAME, RESOURCE_BUNDLE).required().build()).childOption(Option.string(FIELDS_FIELD_NAME_TRANSFORM, RESOURCE_BUNDLE).build()).childOption(Option.stringList(FIELDS_PROPERTY_CHAIN, RESOURCE_BUNDLE).required().build()).childOption(Option.string(FIELD_DEFAULT_VALUE, RESOURCE_BUNDLE).build());
        if (hasDatatype) {
            builder.childOption(Option.string(FIELD_DATATYPE, RESOURCE_BUNDLE).build());
        }
        builder.childOption(VALUE_FILTER).childOption(Option.flag(FIELD_INDEXED, RESOURCE_BUNDLE).defaultValue(true).build());
        if (hasStored) {
            builder.childOption(Option.flag(FIELD_STORED, RESOURCE_BUNDLE).defaultValue(true).build());
        }
        if (hasAnalyzed) {
            builder.childOption(Option.flag(FIELD_ANALYZED, RESOURCE_BUNDLE).defaultValue(true).build());
        }
        builder.childOption(Option.flag(FIELD_MULTIVALUED, RESOURCE_BUNDLE).defaultValue(true).build());
        if (hasDatatype) {
            builder.childOption(Option.flag(FIELD_IGNORE_INVALID_VALUES, RESOURCE_BUNDLE).defaultValue(false).build());
        }
        for (Option<?> eco : extraChildOptions) {
            builder.childOption(eco);
        }
        if (FIELDS_PARAM_NAME.equals(paramName)) {
            builder.required();
        }
        return builder.build();
    }

    private static String patternToString(long subject, long predicate, long[] objects, PluginConnection pluginConnection) {
        StringBuilder sb = new StringBuilder();
        Entities entities = pluginConnection.getEntities();
        sb.append(ExternalSyncPlugin.getEntityString(entities, subject)).append(' ');
        sb.append(ExternalSyncPlugin.getEntityString(entities, predicate)).append(' ');
        if (objects.length == 1) {
            sb.append(ExternalSyncPlugin.getEntityString(entities, objects[0]));
        } else {
            sb.append('(');
            sb.append(ExternalSyncPlugin.getEntityString(entities, objects[0]));
            for (int i = 1; i < objects.length; ++i) {
                sb.append(' ').append(ExternalSyncPlugin.getEntityString(entities, objects[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private static String getEntityString(Entities entities, long id) {
        Value v = entities.get(id);
        return v == null ? "*" + id : v.stringValue();
    }

    protected ExternalSyncPlugin() {
        this.urisForControlPredicates = this.asUriMap(this.getURIPrefixControl(), new Enum[][]{ControlPredicate.values(), FlexibleBucketItem.values(), this.getCustomPluginPredicates()});
        this.predicateToIteratorMap = new TLongObjectHashMap(ControlPredicate.values().length);
        this.predicateToItemNameMap = new TLongObjectHashMap(FlexibleBucketItem.values().length);
        this.currentlyBeingBuilt = Collections.synchronizedMap(new HashMap());
    }

    protected Enum<? extends ConnectorPredicate>[] getCustomPluginPredicates() {
        return new Enum[0];
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        File dataDir = this.getDataDir();
        dataDir.mkdirs();
        if (!dataDir.exists() || !dataDir.isDirectory()) {
            throw new PluginException("The data directory does not exist: " + dataDir.getAbsolutePath());
        }
        this.storesManager = new StoresManager(this);
        this.storesManager.loadStores(pluginConnection);
        Entities entities = pluginConnection.getEntities();
        this.registerControlPredicates(entities);
        this.registerSearchPredicates(entities);
        this.registerQueryTimePredicates(entities);
        this.rdfTypeId = entities.put((Value)RDF.TYPE, Entities.Scope.DEFAULT);
        long rdfsResourceId = entities.put((Value)RDFS.RESOURCE, Entities.Scope.DEFAULT);
        this.entityUpdateListener = new EntityUpdateListener(this, this.storesManager.getStores().values(), this.rdfTypeId, rdfsResourceId);
        this.entityIdSize = entities.getEntityIdSize();
        this.initialized = true;
    }

    private void registerControlPredicates(Entities entities) {
        this.discoveryPredicateId = this.registerControlPredicate(entities, ControlPredicate.DISCOVERY);
        this.createPredicateId = this.registerControlPredicate(entities, ControlPredicate.CREATE);
        this.repairPredicateId = this.registerControlPredicate(entities, ControlPredicate.REPAIR);
        this.updatePredicateId = this.registerControlPredicate(entities, ControlPredicate.UPDATE);
        this.listPredicateId = this.registerControlPredicate(entities, ControlPredicate.LIST);
        this.listOptionsPredicateId = this.registerControlPredicate(entities, ControlPredicate.LIST_OPTIONS);
        this.dropPredicateId = this.registerControlPredicate(entities, ControlPredicate.DROP);
        this.connectorStatusPredicateId = this.registerControlPredicate(entities, ControlPredicate.CONNECTOR_STATUS);
        this.syncedFieldPredicateId = this.registerControlPredicate(entities, ControlPredicate.SYNCED_FIELD);
        this.apiOptionsPredicateId = this.registerControlPredicate(entities, ControlPredicate.OPTIONS);
        this.pluginPrefixID = entities.put((Value)this.valueFactory.createIRI(this.getURIPrefixControl()), Entities.Scope.SYSTEM);
    }

    private void registerSearchPredicates(Entities entities) {
        this.searchPredicates = new TLongObjectHashMap();
        for (Map.Entry<String, ExternalStore> e : this.storesManager.getStores().entrySet()) {
            IRI uri = this.valueFactory.createIRI(this.getURIPrefixInstance(), e.getKey());
            long uriId = entities.put((Value)uri, Entities.Scope.SYSTEM);
            this.searchPredicates.put(uriId, (Object)e.getValue());
        }
    }

    private void registerSearchOptions(Entities entities) {
        this.searchOptionLimitId = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_LIMIT);
        long[] _searchOptionsIds = new long[]{this.searchOptionLimitId, this.searchOptionOffsetId = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_OFFSET), this.searchOptionOrderById = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_ORDERBY), this.searchOptionFacetFieldsId = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_FACET_FIELDS), this.searchOptionFacetLimitId = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_FACETS_LIMIT), this.searchOptionSnippetSize = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_SNIPPET_SIZE), this.searchOptionSnippetPreId = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_SNIPPET_PRE), this.searchOptionSnippetPostId = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_SNIPPET_POST), this.searchOptionExtraOptions = this.registerControlPredicate(entities, ControlPredicate.SEARCH_OPTION_EXTRA_OPTIONS)};
        long[] _customSearchOptionsIds = this.getCustomSearchOptions(entities);
        if (_customSearchOptionsIds.length == 0) {
            this.searchOptionsIds = _searchOptionsIds;
        } else {
            this.searchOptionsIds = new long[_searchOptionsIds.length + _customSearchOptionsIds.length];
            System.arraycopy(_searchOptionsIds, 0, this.searchOptionsIds, 0, _searchOptionsIds.length);
            System.arraycopy(_customSearchOptionsIds, 0, this.searchOptionsIds, _searchOptionsIds.length, _customSearchOptionsIds.length);
        }
    }

    private void registerQueryTimePredicates(Entities entities) {
        this.queryPredicateId = this.registerControlPredicate(entities, ControlPredicate.SEARCH_QUERY);
        this.registerSearchOptions(entities);
        this.registerCustomPredicates(entities);
        this.entityResultPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_RESULT_ENTITIES, EntityResultIterator.class);
        this.facetResultPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_RESULT_FACETS, FacetResultIterator.class);
        this.aggregationsResultPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.AGGREGATIONS, AggregationResultIterator.class);
        this.totalHitsPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_TOTALHITS, TotalHitsIterator.class);
        this.scorePredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_SCORE, ScoreIterator.class);
        this.snippetResultPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_RESULT_SNIPPETS, SnippetResultIterator.class);
        this.snippetFieldPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_SNIPPET_FIELD, SnippetFieldIterator.class);
        this.snippetTextPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_SNIPPET_TEXT, SnippetTextIterator.class);
        this.snippetInnerFieldPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.SEARCH_SNIPPET_INNER_FIELD, SnippetInnerFieldIterator.class);
        this.facetPredicatePredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.FACET_NAME, FacetPredicateIterator.class);
        this.facetValuePredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.FACET_VALUE, FacetValueIterator.class);
        this.facetCountPredicateId = this.registerControlPredicateWithIterator(entities, ControlPredicate.FACET_COUNT, FacetCountIterator.class);
        this.bucketPredicateIds = new long[FlexibleBucketItem.values().length];
        for (FlexibleBucketItem item : FlexibleBucketItem.values()) {
            this.bucketPredicateIds[item.ordinal()] = this.registerControlPredicateWithIterator(entities, item, AggregationBucketItemIterator.class);
        }
    }

    protected void registerCustomPredicates(Entities entities) {
    }

    private long registerControlPredicate(Entities entities, ConnectorPredicate connectorPredicate) {
        return entities.put((Value)this.urisForControlPredicates.get(connectorPredicate), Entities.Scope.SYSTEM);
    }

    protected final long registerControlPredicateWithIterator(Entities entities, ConnectorPredicate connectorPredicate, Class<?> implementation) {
        long pid = entities.put((Value)this.urisForControlPredicates.get(connectorPredicate), Entities.Scope.SYSTEM);
        this.predicateToIteratorMap.put(pid, implementation);
        if (connectorPredicate instanceof FlexibleBucketItem) {
            this.predicateToItemNameMap.put(pid, (Object)((FlexibleBucketItem)connectorPredicate));
        }
        return pid;
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        this.logPattern("estimate   ", subject, predicate, new long[]{object}, pluginConnection);
        if (predicate == this.queryPredicateId || ExternalSyncPlugin.valueIsIn(predicate, this.searchOptionsIds)) {
            if (object == 0L) {
                return Double.POSITIVE_INFINITY;
            }
            return subject == Long.MAX_VALUE ? 0.1 : 1.1;
        }
        if (predicate == this.apiOptionsPredicateId || predicate == this.syncedFieldPredicateId) {
            return subject == Long.MAX_VALUE ? 0.1 : 1.1;
        }
        if (predicate == this.entityResultPredicateId || predicate == this.facetResultPredicateId || predicate == this.totalHitsPredicateId || predicate == this.aggregationsResultPredicateId) {
            return subject == Long.MAX_VALUE ? 0.2 : 1.2;
        }
        if (predicate == this.snippetResultPredicateId || predicate == this.scorePredicateId || predicate == this.facetPredicatePredicateId || predicate == this.facetValuePredicateId || predicate == this.facetCountPredicateId || ExternalSyncPlugin.valueIsIn(predicate, this.bucketPredicateIds)) {
            return subject == Long.MAX_VALUE ? 0.3 : 1.3;
        }
        if (predicate == this.snippetFieldPredicateId || predicate == this.snippetTextPredicateId || predicate == this.snippetInnerFieldPredicateId) {
            return subject == Long.MAX_VALUE ? 0.4 : 1.4;
        }
        if (predicate == this.rdfTypeId) {
            return subject == 0L ? 0.01 : Double.POSITIVE_INFINITY;
        }
        return 1.0;
    }

    private AbstractResultIterator createIteratorInstance(Class<?> iteratorClass, Entities entities, long subject, long predicate, long object) {
        try {
            AbstractResultIterator ari = (AbstractResultIterator)((Object)iteratorClass.newInstance());
            ari.setSPO(subject, predicate, object);
            ari.setEntities(entities);
            return ari;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PluginException("Something went really wrong. This should not happen.");
        }
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        this.logPattern("interpret  ", subject, predicate, new long[]{object}, pluginConnection);
        Entities entities = pluginConnection.getEntities();
        Class iteratorClass = (Class)this.predicateToIteratorMap.get(predicate);
        if (iteratorClass != null) {
            SnippetResultIterator sri;
            if (object != 0L && !ObjectMayBeBound.class.isAssignableFrom(iteratorClass)) {
                return new DummyIterator("Bound object found where unbound expected.");
            }
            ExternalSyncRequestContext esrc = (ExternalSyncRequestContext)requestContext;
            if (subject == 0L) {
                if (predicate == this.snippetResultPredicateId) {
                    esrc.setCollectSnippets(true);
                } else if (predicate == this.totalHitsPredicateId) {
                    esrc.setTrackTotalHits(true);
                } else if (predicate == this.scorePredicateId) {
                    esrc.setTrackScore(true);
                }
                return new DummyIterator(iteratorClass.getSimpleName());
            }
            AbstractResultIterator itty = null;
            if (NeedsMasterResult.class.isAssignableFrom(iteratorClass)) {
                MasterResultIterator mri = esrc.findMasterIterator(subject);
                if (mri != null) {
                    itty = this.createIteratorInstance(iteratorClass, entities, subject, predicate, object);
                    ((NeedsMasterResult)((Object)itty)).setMasterResultIterator(mri);
                }
            } else if (NeedsEntityResult.class.isAssignableFrom(iteratorClass)) {
                EntityResultIterator eri = esrc.findEntityResultIterator(subject);
                if (eri != null) {
                    itty = this.createIteratorInstance(iteratorClass, entities, subject, predicate, object);
                    ((NeedsEntityResult)((Object)itty)).setEntityResultIterator(eri);
                }
            } else if (NeedsFacetResult.class.isAssignableFrom(iteratorClass)) {
                FacetResultIterator fri = esrc.findFacetResultIterator(subject);
                if (fri != null) {
                    itty = this.createIteratorInstance(iteratorClass, entities, subject, predicate, object);
                    ((NeedsFacetResult)((Object)itty)).setFacetResultIterator(fri);
                }
            } else if (NeedsAggregationResult.class.isAssignableFrom(iteratorClass)) {
                AggregationResultIterator ari = esrc.findAggregationResultIterator(subject);
                if (ari != null) {
                    itty = this.createIteratorInstance(iteratorClass, entities, subject, predicate, object);
                    ((NeedsAggregationResult)((Object)itty)).setAggregationResultIterator(ari);
                    ((NeedsAggregationResult)((Object)itty)).setItemName((FlexibleBucketItem)this.predicateToItemNameMap.get(predicate));
                }
            } else if (NeedsSnippetResult.class.isAssignableFrom(iteratorClass) && (sri = esrc.findSnippetResultIterator(subject)) != null) {
                itty = this.createIteratorInstance(iteratorClass, entities, subject, predicate, object);
                ((NeedsSnippetResult)((Object)itty)).setSnippetResultIterator(sri);
            }
            if (itty != null) {
                esrc.registerIterator(itty);
                return itty;
            }
            return StatementIterator.EMPTY;
        }
        if (predicate == this.queryPredicateId) {
            if (subject == 0L) {
                return new DummyIterator("query");
            }
            ExternalSyncRequestContext esrc = (ExternalSyncRequestContext)requestContext;
            MasterResultIterator mri = esrc.findMasterIterator(subject);
            if (mri != null) {
                Value queryValue = entities.get(object);
                if (queryValue == null) {
                    throw new BadRequestException("No value for connector query. Is the variable bound?");
                }
                String queryStr = queryValue.stringValue();
                mri.setQueryString(queryStr);
            }
            return StatementIterator.TRUE();
        }
        if (ExternalSyncPlugin.valueIsIn(predicate, this.searchOptionsIds)) {
            String optionsStr;
            if (subject == 0L) {
                return new DummyIterator("searchOptions");
            }
            ExternalSyncRequestContext esrc = (ExternalSyncRequestContext)requestContext;
            MasterResultIterator mri = esrc.findMasterIterator(subject);
            if (mri != null && (optionsStr = entities.get(object).stringValue()) != null && !optionsStr.isEmpty()) {
                SearchOptions o = mri.getSearchOptions();
                if (predicate == this.searchOptionLimitId) {
                    o.setLimit(optionsStr);
                } else if (predicate == this.searchOptionOffsetId) {
                    o.setOffset(optionsStr);
                } else if (predicate == this.searchOptionOrderById) {
                    o.setOrderBy(optionsStr);
                } else if (predicate == this.searchOptionFacetFieldsId) {
                    o.setFacetFields(optionsStr);
                } else if (predicate == this.searchOptionFacetLimitId) {
                    o.setFacetLimit(optionsStr);
                } else if (predicate == this.searchOptionSnippetSize) {
                    o.setSnippetSize(optionsStr);
                } else if (predicate == this.searchOptionSnippetPreId) {
                    o.setSnippetPre(optionsStr);
                } else if (predicate == this.searchOptionSnippetPostId) {
                    o.setSnippetPost(optionsStr);
                } else if (predicate == this.searchOptionExtraOptions) {
                    o.setExtraOptions(optionsStr);
                } else {
                    this.processCustomSearchOption(predicate, o, optionsStr);
                }
            }
            return StatementIterator.TRUE();
        }
        if (predicate == this.listPredicateId) {
            return this.createListIndexesIterator(subject, predicate, object, context, entities);
        }
        if (predicate == this.listOptionsPredicateId) {
            if (!this.searchPredicates.contains(subject)) {
                throw new BadRequestException("List options of non existing index!");
            }
            return StatementIterator.create((long)subject, (long)predicate, (long)entities.put((Value)this.valueFactory.createLiteral(this.getStoreOptionsForUser(pluginConnection, subject)), Entities.Scope.REQUEST), (long)context);
        }
        if (predicate == this.syncedFieldPredicateId) {
            ExternalStore externalStore = (ExternalStore)this.searchPredicates.get(subject);
            if (externalStore == null) {
                throw new BadRequestException("List options of non existing index!");
            }
            List<String> syncedFields = externalStore.getSyncedFields();
            return this.createSyncedFields(syncedFields, subject, predicate, context, entities);
        }
        if (predicate == this.connectorStatusPredicateId) {
            return this.createHealthCheckIterator(subject, predicate, object, context, entities);
        }
        if (predicate == this.apiOptionsPredicateId) {
            if (subject == 0L) {
                throw new BadRequestException("Options invoked on non existing subject!");
            }
            if (subject != this.pluginPrefixID) {
                return null;
            }
            long optionDiscoveryJSON = entities.put((Value)this.valueFactory.createLiteral(this.getOptionsAsJSON().toJSONString()), Entities.Scope.REQUEST);
            return StatementIterator.create((long)subject, (long)predicate, (long)optionDiscoveryJSON, (long)context);
        }
        if (predicate == this.rdfTypeId && object < 0L) {
            return this.tryCreateMasterResultIterator(object, (ExternalSyncRequestContext)requestContext, pluginConnection);
        }
        if (predicate == this.discoveryPredicateId) {
            ((ExternalSyncRequestContext)requestContext).detectDiscoveryPattern();
        }
        return null;
    }

    protected StatementIterator createSyncedFields(List<String> syncedFields, long subject, long predicate, long context, Entities entities) {
        long[][] result = new long[syncedFields.size()][];
        for (int i = 0; i < syncedFields.size(); ++i) {
            String fieldName = syncedFields.get(i);
            result[i] = new long[]{subject, predicate, entities.put((Value)this.valueFactory.createLiteral(fieldName), Entities.Scope.REQUEST), context};
        }
        return StatementIterator.create((long[][])result);
    }

    private MasterResultIterator tryCreateMasterResultIterator(long connector, ExternalSyncRequestContext requestContext, PluginConnection pluginConnection) {
        ExternalStore handler = (ExternalStore)this.searchPredicates.get(connector);
        if (handler != null) {
            this.checkRequiredCapabilities(pluginConnection);
            MasterResultIterator mri = new MasterResultIterator(pluginConnection.getEntities(), this.createSearchOptions(), requestContext);
            try {
                ExternalRetrieve externalRetrieve = handler.createRetrieve(mri, requestContext);
                mri.setState(externalRetrieve);
                requestContext.registerIterator(mri);
            }
            catch (RuntimeException e) {
                mri.close();
                throw e;
            }
            return mri;
        }
        return null;
    }

    private StatementIterator createListIndexesIterator(final long subject, final long predicate, long object, final long context, final Entities entities) {
        final TreeMap ret = new TreeMap();
        final String requestObject = object == 0L ? null : entities.get(object).stringValue();
        this.searchPredicates.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<ExternalStore>(){

            public boolean execute(long storeId, ExternalStore store) {
                if (ExternalSyncPlugin.this.filterResultStatement(subject, requestObject, storeId, store.getName())) {
                    ret.put(store.getName(), new long[]{storeId, predicate, ExternalSyncPlugin.this.putReqScopeString(entities, store.getName()), context});
                }
                return true;
            }
        });
        return StatementIterator.create((long[][])((long[][])ret.values().toArray((T[])new long[ret.size()][])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementIterator createHealthCheckIterator(long subject, long predicate, long object, long context, Entities entities) {
        if (object != 0L) {
            return StatementIterator.EMPTY;
        }
        HashMap<Long, ExternalStore> requestedStores = new HashMap<Long, ExternalStore>();
        TLongObjectHashMap<ExternalStore> tLongObjectHashMap = this.searchPredicates;
        synchronized (tLongObjectHashMap) {
            if (subject == 0L) {
                this.searchPredicates.forEachEntry((id, store) -> {
                    requestedStores.put(id, (ExternalStore)store);
                    return true;
                });
                for (Map.Entry<IRI, ExternalStore> e : this.currentlyBeingBuilt.entrySet()) {
                    requestedStores.put(entities.put((Value)e.getKey(), Entities.Scope.REQUEST), e.getValue());
                }
            } else {
                ExternalStore store2 = (ExternalStore)this.searchPredicates.get(subject);
                if (store2 != null) {
                    requestedStores.put(subject, store2);
                } else {
                    ExternalStore currentlyBeingBuiltStore = this.currentlyBeingBuilt.get(entities.get(subject));
                    if (currentlyBeingBuiltStore != null) {
                        requestedStores.put(subject, currentlyBeingBuiltStore);
                    }
                }
            }
        }
        return new StatusIterator(requestedStores, entities);
    }

    private boolean filterResultStatement(long requestSubject, @Nullable String requestObject, long responseSubject, String responseObject) {
        return !(requestSubject != 0L && requestSubject != responseSubject || requestObject != null && !requestObject.equals(responseObject));
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.createPredicateId, this.dropPredicateId, this.repairPredicateId, this.updatePredicateId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (!isExplicit) {
            return false;
        }
        Entities entities = pluginConnection.getEntities();
        if (predicate == this.createPredicateId) {
            this.checkRequiredCapabilities(pluginConnection);
            IRI uri = (IRI)entities.get(subject);
            String optionsString = entities.get(object).stringValue();
            this.prepareCollectionsAndCreateStore(uri, optionsString, pluginConnection);
            return true;
        }
        if (predicate == this.dropPredicateId) {
            boolean force = entities.get(object).stringValue().toLowerCase().equals("force");
            ExternalStore handler = this.getHandlerOrThrow(subject, entities);
            this.removeStore(handler, force, entities);
            return true;
        }
        if (predicate == this.repairPredicateId) {
            this.checkRequiredCapabilities(pluginConnection);
            ExternalStore handler = this.getHandlerOrThrow(subject, entities);
            this.prepareCollectionsAndRepairStore(handler, pluginConnection);
            return true;
        }
        if (predicate == this.updatePredicateId) {
            this.checkRequiredCapabilities(pluginConnection);
            ExternalStore handler = this.getHandlerOrThrow(subject, entities);
            String optionsString = entities.get(object).stringValue();
            Options options = this.parseOptions(handler.getName(), optionsString);
            this.validateOptions(options, handler.getOptions());
            handler.updateOptions(options);
            this.saveStoresOptions();
            return true;
        }
        return false;
    }

    private String getStoreOptionsForUser(PluginConnection pluginConnection, long subject) {
        boolean allowAll = pluginConnection.getSecurityContext().hasWriteAccess();
        return ((ExternalStore)this.searchPredicates.get(subject)).getOptions().toJSONStringForUser(allowAll ? Collections.emptySet() : this.getOptionsToRedactForUser()).replaceAll(Pattern.quote("\\/"), "/");
    }

    protected Set<String> getOptionsToRedactForUser() {
        return Collections.emptySet();
    }

    private ExternalStore getHandlerOrThrow(long subject, Entities entities) {
        ExternalStore handler = (ExternalStore)this.searchPredicates.get(subject);
        if (handler == null) {
            throw new BadRequestException("Index does not exist: " + String.valueOf(entities.get(subject)));
        }
        return handler;
    }

    public void shutdown(ShutdownReason shutdownReason) {
        this.storesManager.shutdownStores();
    }

    private void prepareCollectionsAndCreateStore(IRI uri, String optionsString, PluginConnection pluginConnection) {
        String importFile;
        Entities entitiesForCreation = pluginConnection.getEntities();
        Statements statementsForCreation = pluginConnection.getStatements();
        String storeName = this.getStoreNameFromIRI(uri);
        Options options = this.parseOptions(storeName, optionsString);
        boolean readonly = options.getValueWithDefault(READONLY);
        boolean importGraph = options.getValueWithDefault(IMPORT_GRAPH);
        boolean isDetectFields = options.getValueWithDefault(DETECT_FIELDS);
        boolean skipInitialIndexing = options.getValueWithDefault(SKIP_INITIAL_INDEXING);
        if (readonly && skipInitialIndexing) {
            throw new ConnectorUserException("Options 'readonly' and 'skipInitialIndexing' cannot be true at the same time");
        }
        if (importGraph) {
            if (!readonly) {
                throw new ConnectorUserException("Option 'importGraph' requires option 'readonly'");
            }
            this.useCollectionModel = true;
        }
        if ((importFile = options.getValue(IMPORT_FILE)) != null) {
            if (!readonly) {
                throw new ConnectorUserException("Option 'importFile' requires option 'readonly'");
            }
            this.importDataFromFile(importFile);
        }
        if (this.useCollectionModel) {
            if (this.temporaryGraph == null) {
                throw new ConnectorUserException("No data was inserted in the temporary graph");
            }
            this.temporaryGraph.commit();
            entitiesForCreation = this.temporaryGraph.getEntities();
            statementsForCreation = this.temporaryGraph.getStatements();
            if (isDetectFields) {
                optionsString = this.detectAndInjectFields(optionsString);
            }
        } else if (isDetectFields) {
            throw new ConnectorUserException("Option 'detectFields' can be used only with 'importGraph' or 'importFile'");
        }
        options = this.parseOptions(storeName, optionsString);
        this.validateOptions(options, null);
        this.storesManager.createStore(uri, options, pluginConnection, entitiesForCreation, statementsForCreation);
    }

    private void prepareCollectionsAndRepairStore(ExternalStore store, PluginConnection pluginConnection) {
        Entities entitiesForCreation = pluginConnection.getEntities();
        Statements statementsForCreation = pluginConnection.getStatements();
        Options options = this.parseOptions(store.getName(), store.getOptions().toJSONString());
        boolean isDetectFields = options.getValue(DETECT_FIELDS);
        if (this.useCollectionModel) {
            if (this.temporaryGraph == null) {
                throw new ConnectorUserException("No data was inserted in the temporary graph");
            }
            this.temporaryGraph.commit();
            entitiesForCreation = this.temporaryGraph.getEntities();
            statementsForCreation = this.temporaryGraph.getStatements();
            if (isDetectFields) {
                options = this.parseOptions(store.getName(), this.detectAndInjectFields(store.getOptions().toJSONString()));
                this.validateOptions(options, null);
            }
        } else if (isDetectFields) {
            throw new ConnectorUserException("Option 'detectFields' can be used only with 'importGraph' or 'importFile'");
        }
        store.recreateIndex(options);
        this.storesManager.repairStore(store, pluginConnection, entitiesForCreation, statementsForCreation);
    }

    private Options parseOptions(String storeName, String optionsString) {
        try {
            Options options = new OptionsParser(this.getPossibleOptions(true), IMPLEMENTATION_VERSION).parseFromJSON(optionsString);
            options.setStoreName(storeName);
            return options;
        }
        catch (ParseException e) {
            throw new ConnectorUserException("Invalid JSON: " + e.getMessage());
        }
    }

    private void validateOptions(Options options, @Nullable Options optionsToUpdate) {
        if (this.isTestingTransaction()) {
            new OptionsValidator(optionsToUpdate).validate(this, options, this.getPossibleOptions(false));
        }
    }

    private String detectAndInjectFields(String options) {
        try {
            JSONArray jsonPropertyChain;
            JSONObject jsonField;
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonOptions = (JSONObject)jsonParser.parse(options);
            JSONArray jsonFields = (JSONArray)jsonOptions.get((Object)FIELDS_PARAM_NAME);
            if (jsonFields == null) {
                jsonFields = new JSONArray();
                jsonOptions.put((Object)FIELDS_PARAM_NAME, (Object)jsonFields);
            }
            Set predicatesInData = this.temporaryGraph.predicates().stream().map(Value::stringValue).collect(Collectors.toSet());
            HashMap<String, JSONObject> existingFields = new HashMap<String, JSONObject>();
            for (Object fieldObject : jsonFields) {
                jsonField = (JSONObject)fieldObject;
                jsonPropertyChain = (JSONArray)jsonField.get((Object)FIELDS_PROPERTY_CHAIN);
                if (jsonPropertyChain == null || jsonPropertyChain.size() != 1 || !predicatesInData.contains(jsonPropertyChain.get(0).toString())) continue;
                existingFields.put(jsonPropertyChain.get(0).toString(), jsonField);
            }
            for (String predicate : predicatesInData) {
                jsonField = (JSONObject)existingFields.get(predicate);
                if (jsonField == null) {
                    jsonField = new JSONObject();
                    jsonFields.add((Object)jsonField);
                    jsonPropertyChain = new JSONArray();
                    jsonPropertyChain.add((Object)predicate);
                    jsonField.put((Object)FIELDS_PROPERTY_CHAIN, (Object)jsonPropertyChain);
                }
                jsonField.putIfAbsent((Object)FIELDS_FIELD_NAME, (Object)predicate);
                jsonField.putIfAbsent((Object)FIELD_INDEXED, (Object)true);
                jsonField.putIfAbsent((Object)FIELD_STORED, (Object)true);
                jsonField.putIfAbsent((Object)FIELD_ANALYZED, (Object)true);
                jsonField.putIfAbsent((Object)FIELD_MULTIVALUED, (Object)true);
                jsonField.putIfAbsent((Object)FIELD_FACET, (Object)false);
            }
            return jsonOptions.toString();
        }
        catch (ParseException e) {
            throw new ConnectorUserException("Unable to parse options", e);
        }
    }

    public void removeStore(ExternalStore handler, boolean force, Entities entities) {
        IRI storeIri = this.valueFactory.createIRI(this.getURIPrefixInstance() + handler.getName());
        try {
            block4: {
                try {
                    handler.remove(force);
                }
                catch (Exception e) {
                    if (force) break block4;
                    throw e;
                }
            }
            this.storesManager.removeStore(handler, storeIri, entities);
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Failed to remove connector " + String.valueOf(storeIri) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private void logPattern(String msg, long subject, long predicate, long[] objects, PluginConnection pluginConnection) {
    }

    private long putReqScopeString(Entities entities, String s) {
        return entities.put((Value)this.valueFactory.createLiteral(s), Entities.Scope.REQUEST);
    }

    public RequestContext preprocess(Request request) {
        return new ExternalSyncRequestContext(request);
    }

    public long getFingerprint() {
        long fp = 0L;
        for (ExternalStore handler : this.storesManager.getStores().values()) {
            fp ^= handler.getFingerprint();
        }
        return fp;
    }

    public synchronized void saveStoresOptions() {
        JSONObject optionsJson = new JSONObject();
        Map<String, ExternalStore> stores = this.storesManager.getStores();
        for (Map.Entry<String, ExternalStore> entry : stores.entrySet()) {
            optionsJson.put((Object)entry.getKey(), (Object)entry.getValue().getOptions().toJSONObject(true));
        }
        try {
            FileUtils.writeStringToFile((File)new File(this.getDataDir(), "config.json"), (String)optionsJson.toString());
        }
        catch (IOException e) {
            throw new BadRequestException("Unable to save connector config", (Throwable)e);
        }
    }

    public synchronized void saveDynamicSettings() {
        JSONObject json = new JSONObject();
        Map<String, ExternalStore> stores = this.storesManager.getStores();
        for (Map.Entry<String, ExternalStore> entry : stores.entrySet()) {
            json.put((Object)entry.getKey(), (Object)entry.getValue().getSettingsAsJSON());
        }
        try {
            this.getLogger().debug("Saving dynamic settings.");
            FileUtils.writeStringToFile((File)new File(this.getDataDir(), "dynamic_settings.json"), (String)json.toString());
        }
        catch (IOException e) {
            throw new BadRequestException("Unable to save dynamic settings", (Throwable)e);
        }
    }

    protected abstract ExternalStore openExistingStore(String var1, Options var2, PluginConnection var3);

    protected abstract ExternalStore createNewStore(String var1, Options var2, PluginConnection var3, Entities var4);

    public abstract List<Option<?>> getAllOptions();

    public final List<Option<?>> getPossibleOptions(boolean includeDeprecated) {
        if (includeDeprecated) {
            return this.getAllOptions();
        }
        return this.getAllOptions().stream().filter(o -> !o.isDeprecated()).collect(Collectors.toList());
    }

    protected JSONArray getOptionsAsJSON() {
        List<Option<?>> options = this.getPossibleOptions(false);
        JSONArray optionsJSON = new JSONArray();
        for (Option<?> option : options) {
            optionsJSON.add((Object)option.toJSONObject());
        }
        return optionsJSON;
    }

    protected final String getURIPrefixControl() {
        return this.uriPrefixControl;
    }

    protected final String getURIPrefixInstance() {
        return this.uriPrefixInstance;
    }

    protected abstract String getURIComponent();

    public boolean shouldPostprocess(RequestContext requestContext) {
        return ((ExternalSyncRequestContext)requestContext).hasDiscoveryPattern();
    }

    public BindingSet postprocess(BindingSet bindings, RequestContext requestContext) {
        return bindings;
    }

    public Iterator<BindingSet> flush(RequestContext requestContext) {
        MapBindingSet mbs = new MapBindingSet(2);
        ExternalSyncRequestContext esrc = (ExternalSyncRequestContext)requestContext;
        mbs.addBinding(esrc.getDiscoverySubject(), (Value)this.valueFactory.createIRI(this.getURIPrefixControl()));
        mbs.addBinding(esrc.getDiscoveryObject(), (Value)this.valueFactory.createLiteral(this.getShortName()));
        return new SingletonIterator((Object)mbs);
    }

    public abstract String getShortName();

    protected static boolean valueIsIn(long value, long ... otherValues) {
        for (long otherValue : otherValues) {
            if (value != otherValue) continue;
            return true;
        }
        return false;
    }

    protected void processCustomSearchOption(long predicate, SearchOptions searchOptions, String optionStr) {
    }

    protected long[] getCustomSearchOptions(Entities entities) {
        return ArrayUtils.EMPTY_LONG_ARRAY;
    }

    protected SearchOptions createSearchOptions() {
        return new SearchOptions();
    }

    public boolean isTestingTransaction() {
        return this.entityUpdateListener == null || this.entityUpdateListener.isTestingTransaction();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private Map<ConnectorPredicate, IRI> asUriMap(String prefix, Enum<? extends ConnectorPredicate>[][] enums) {
        HashMap<ConnectorPredicate, IRI> urisForControlPredicates = new HashMap<ConnectorPredicate, IRI>();
        Enum<? extends ConnectorPredicate>[][] enumArray = enums;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum<? extends ConnectorPredicate>[] e;
            for (Enum<? extends ConnectorPredicate> cp : e = enumArray[i]) {
                String uriSuffix = ((ConnectorPredicate)((Object)cp)).getURISuffix();
                IRI uri = uriSuffix.startsWith("http:") ? this.valueFactory.createIRI(uriSuffix) : this.valueFactory.createIRI(prefix + uriSuffix);
                urisForControlPredicates.put((ConnectorPredicate)((Object)cp), uri);
            }
        }
        return urisForControlPredicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeClear(long context, PluginConnection pluginConnection) {
        if (context == 0L) {
            for (Map.Entry<String, ExternalStore> storeEntry : this.storesManager.getStores().entrySet()) {
                storeEntry.getValue().removeAllEntities();
            }
        } else {
            try (StatementIterator sit = pluginConnection.getStatements().get(0L, 0L, 0L, context);){
                while (sit.next()) {
                    this.entityUpdateListener.statementRemoved(sit.subject, sit.predicate, sit.object, sit.context, sit.isExplicit(), pluginConnection);
                }
            }
        }
    }

    public void afterClear(long context, PluginConnection pluginConnection) {
    }

    public void setCurrentlyBeingBuilt(String name, ExternalStore store) {
        this.currentlyBeingBuilt.put(SimpleValueFactory.getInstance().createIRI(this.getURIPrefixInstance(), name), store);
    }

    public void resetCurrentlyBeingBuilt(String name) {
        this.currentlyBeingBuilt.remove(SimpleValueFactory.getInstance().createIRI(this.getURIPrefixInstance(), name));
    }

    public HealthResult runHealthCheck() {
        CompositeHealthResult allResult = new CompositeHealthResult(this.getName());
        for (Map.Entry<String, ExternalStore> storeEntry : this.storesManager.getStores().entrySet()) {
            allResult.addComposite(storeEntry.getValue().runHealthCheck());
        }
        return allResult;
    }

    public Resource[] getUpdateContexts() {
        return new Resource[]{this.valueFactory.createIRI(this.uriPrefixControl, "graph")};
    }

    public void handleContextUpdate(Resource subject, IRI predicate, Value object, Resource context, boolean isAddition, PluginConnection pluginConnection) {
        if (context == null) {
            return;
        }
        if (!context.equals((Object)this.valueFactory.createIRI(this.uriPrefixControl, "graph"))) {
            throw new IllegalStateException("handleContextUpdate for the wrong graph called");
        }
        if (this.temporaryGraph == null) {
            this.temporaryGraph = this.createTemporaryGraph();
            this.temporaryGraph.begin();
        }
        this.temporaryGraph.add(subject, predicate, object, new Resource[0]);
    }

    private TemporaryGraph createTemporaryGraph() {
        return new TemporaryGraph("empty", this.getLogger());
    }

    private void importDataFromFile(String importFile) {
        try {
            Optional fileFormat = RDFParserRegistry.getInstance().getFileFormatForFileName(importFile);
            if (!fileFormat.isPresent()) {
                throw new ConnectorUserException("Unknown file format: " + importFile);
            }
            Optional parserFactory = RDFParserRegistry.getInstance().get((Object)((RDFFormat)fileFormat.get()));
            if (!parserFactory.isPresent()) {
                throw new ConnectorUserException("Unknown file format: " + importFile);
            }
            if (this.temporaryGraph == null) {
                this.temporaryGraph = this.createTemporaryGraph();
                this.temporaryGraph.begin();
            }
            RDFParser parser = ((RDFParserFactory)parserFactory.get()).getParser();
            parser.setRDFHandler(new RDFHandler(){

                public void startRDF() throws RDFHandlerException {
                }

                public void endRDF() throws RDFHandlerException {
                }

                public void handleNamespace(String s, String s1) throws RDFHandlerException {
                }

                public void handleStatement(Statement statement) throws RDFHandlerException {
                    ExternalSyncPlugin.this.temporaryGraph.add(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext());
                }

                public void handleComment(String s) throws RDFHandlerException {
                }
            });
            try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(importFile));){
                parser.parse((InputStream)fis, "urn:");
            }
            this.temporaryGraph.commit();
            this.temporaryGraph.begin();
            this.useCollectionModel = true;
        }
        catch (Exception e) {
            throw new ConnectorServerException("Unable to import file", e);
        }
    }

    void closeTemporaryGraph() {
        this.useCollectionModel = false;
        if (this.temporaryGraph != null) {
            try {
                this.temporaryGraph.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.temporaryGraph = null;
            }
        }
    }

    public int getEntityIdSize() {
        return this.entityIdSize;
    }

    public void checkRequiredCapabilities(PluginConnection pluginConnection) {
        String requiredCapability = this.getName().toUpperCase().replaceAll("-", "_");
        if (!pluginConnection.getProperties().hasProductCapability(requiredCapability)) {
            throw new PluginException("The '" + this.getName() + "' plugin requires a GraphDB " + License.Capability.valueOf((String)requiredCapability).toHumanReadable() + " capability but your current capabilities are: " + Arrays.stream(License.Capability.values()).filter(lic -> pluginConnection.getProperties().hasProductCapability(lic.toString())).map(License.Capability::toHumanReadable).collect(Collectors.joining(", ")));
        }
    }

    public void setExecutorService(PluginExecutorService executorService) {
        this.executorService = executorService;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        this.entityUpdateListener.transactionStarted(pluginConnection);
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.entityUpdateListener.transactionCommit(pluginConnection);
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        this.entityUpdateListener.transactionCompleted(pluginConnection);
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        this.entityUpdateListener.transactionAborted(pluginConnection);
    }

    public void commitExternalTransaction() {
    }

    public boolean statementAdded(long subject, long property, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        return this.entityUpdateListener.statementAdded(subject, property, object, context, explicit, pluginConnection);
    }

    public boolean statementRemoved(long subject, long property, long object, long context, boolean explicit, PluginConnection pluginConnection) {
        return this.entityUpdateListener.statementRemoved(subject, property, object, context, explicit, pluginConnection);
    }

    public void transactionAbortedByUser(PluginConnection pluginConnection) {
        this.entityUpdateListener.transactionAbortedByUser(pluginConnection);
    }

    private String getStoreNameFromIRI(IRI uri) {
        if (!uri.stringValue().startsWith(this.getURIPrefixInstance())) {
            throw new ConnectorUserException("Connector name must be within the instance namespace " + this.getURIPrefixInstance());
        }
        return uri.stringValue().substring(this.getURIPrefixInstance().length());
    }

    private static class PropertiesValidator
    implements Validator<List<Option<?>>> {
        private static final Validator<String> uriValidator = new URIValidator();
        private static final ListValidator<String> uriListValidator = new ListValidator<String>(uriValidator, Collections.singletonMap(Integer.MAX_VALUE, new Validator<String>(){

            @Override
            @Nullable
            public Object validate(@Nullable String value, Options optionsSet) {
                return "lang()".equalsIgnoreCase(value) || "graph()".equalsIgnoreCase(value) || "$literal".equalsIgnoreCase(value) || "localname()".equalsIgnoreCase(value) ? null : "Value must be lang(), graph(), localName() or $literal";
            }
        }));

        private PropertiesValidator() {
        }

        @Override
        @Nullable
        public Object validate(@Nullable List<Option<?>> value, Options optionsSet) {
            return this.validate(value, optionsSet, false);
        }

        @Nullable
        private Object validate(@Nullable List<Option<?>> value, Options optionsSet, boolean nested) {
            assert (value != null) : "Fields is a required field";
            JSONArray errors = new JSONArray();
            boolean hasError = false;
            for (Option<?> property : value) {
                Object objectFieldErrors;
                Object objectFields;
                Object validate;
                List chainList;
                String fieldNameTransform;
                if (!(property instanceof Map)) continue;
                JSONObject propertyErrors = new JSONObject();
                if (!((Map)((Object)property)).containsKey(ExternalSyncPlugin.FIELDS_FIELD_NAME)) {
                    propertyErrors.put((Object)ExternalSyncPlugin.FIELDS_FIELD_NAME, (Object)"Missing field name fieldName");
                }
                if ((fieldNameTransform = (String)((Map)((Object)property)).get(ExternalSyncPlugin.FIELDS_FIELD_NAME_TRANSFORM)) != null && !FieldNameTransform.isValidTransform(fieldNameTransform)) {
                    propertyErrors.put((Object)ExternalSyncPlugin.FIELDS_FIELD_NAME_TRANSFORM, (Object)("Invalid value for 'fieldNameTransform': " + fieldNameTransform));
                }
                if ((chainList = (List)((Map)((Object)property)).get(ExternalSyncPlugin.FIELDS_PROPERTY_CHAIN)) == null || chainList.isEmpty()) {
                    propertyErrors.put((Object)ExternalSyncPlugin.FIELDS_PROPERTY_CHAIN, (Object)("Property chain for " + String.valueOf(((Map)((Object)property)).get(ExternalSyncPlugin.FIELDS_FIELD_NAME)) + " is empty!"));
                }
                boolean skipUriListValidator = false;
                if (chainList != null && chainList.size() == 1) {
                    String chain1 = (String)chainList.get(0);
                    if ("$self".equals(chain1)) {
                        skipUriListValidator = true;
                    } else if ("$literal".equals(chain1)) {
                        skipUriListValidator = true;
                    } else if (chain1.startsWith("@")) {
                        skipUriListValidator = true;
                    } else if (!nested && "lang()".equalsIgnoreCase(chain1)) {
                        skipUriListValidator = true;
                        propertyErrors.put((Object)ExternalSyncPlugin.FIELDS_PROPERTY_CHAIN, (Object)"The pseudo URI lang() may not be used in the initial position.");
                    } else if (!nested && "graph()".equalsIgnoreCase(chain1)) {
                        skipUriListValidator = true;
                        propertyErrors.put((Object)ExternalSyncPlugin.FIELDS_PROPERTY_CHAIN, (Object)"The pseudo URI graph() may not be used in the initial position.");
                    } else if (!nested && "localname()".equalsIgnoreCase(chain1)) {
                        skipUriListValidator = true;
                    }
                }
                if (!skipUriListValidator && (validate = uriListValidator.validate(chainList, optionsSet)) != null) {
                    propertyErrors.put((Object)ExternalSyncPlugin.FIELDS_PROPERTY_CHAIN, validate);
                }
                if ((objectFields = ((Map)((Object)property)).get(ExternalSyncPlugin.OBJECT_NAME)) != null && (objectFieldErrors = this.validate((List)objectFields, optionsSet, true)) != null) {
                    propertyErrors.put((Object)ExternalSyncPlugin.OBJECT_NAME, objectFieldErrors);
                }
                if (propertyErrors.keySet().size() <= 0) continue;
                hasError = true;
                errors.add((Object)propertyErrors);
            }
            return hasError ? errors : null;
        }
    }

    private static class TypesValidator
    extends ListValidator<String> {
        TypesValidator() {
            super(new URIValidator());
        }

        @Override
        @Nullable
        public Object validate(@Nullable List<String> value, Options optionsSet) {
            if ((value == null || value.isEmpty()) && !optionsSet.getValue(DETECT_FIELDS).booleanValue()) {
                return "Option 'types' is required.";
            }
            if (value != null && value.size() == 1 && ("$any".equals(value.get(0)) || "$untyped".equals(value.get(0)))) {
                return null;
            }
            return super.validate(value, optionsSet);
        }
    }
}

