/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.state;

import com.ontotext.graphdb.cluster.observer.grpc.Node;
import com.ontotext.graphdb.http.HttpClientProvider;
import com.ontotext.graphdb.proxy.ClusterUpdateCallback;
import com.ontotext.graphdb.proxy.grpc.RpcClusterNodeResolver;
import com.ontotext.graphdb.proxy.http.HttpClusterNodeResolver;
import com.ontotext.graphdb.proxy.state.NodeStatus;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateHolder
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterState clusterState;
    private final List<String> initialHosts;
    private final Set<String> clusterAddresses;
    private ClusterUpdateCallback onClusterUpdate;

    public ClusterStateHolder(HttpClientProvider clientProvider, List<String> initialHosts, InetSocketAddress rpcBindAddress, String rpcAddress) throws IOException {
        this.initialHosts = List.copyOf(initialHosts);
        this.clusterState = new ClusterState(clientProvider, rpcBindAddress, rpcAddress);
        this.clusterAddresses = ConcurrentHashMap.newKeySet();
    }

    public String getCurrentRpcAddress() {
        return this.clusterState.getCurrentRpcAddress();
    }

    public List<String> getInitialHosts() {
        return this.initialHosts;
    }

    public Set<String> getClusterAddresses() {
        return this.clusterAddresses;
    }

    public int getClusterSize() {
        return this.clusterState.getNodesCount();
    }

    public Stream<NodeStatus> getClusterState() {
        return this.clusterState.getNodes();
    }

    public Stream<NodeStatus> getCurrentClusterState() {
        return this.clusterState.currentNodes.values().stream();
    }

    void notifyOnClusterChange(ClusterUpdateCallback onNewLeader) {
        this.onClusterUpdate = onNewLeader;
    }

    public void setAccessible(NodeStatus nodeStatus) {
        this.clusterState.nodeBecomeAccessible(nodeStatus);
    }

    public void setNotAccessible(NodeStatus nodeStatus) {
        this.clusterState.nodeBecomeInaccessible(nodeStatus);
    }

    @Override
    public void close() {
        this.clusterState.close();
    }

    public Optional<NodeStatus> refreshLeader() {
        List<String> httpAddresses = Stream.concat(this.clusterState.getNodes().map(NodeStatus::getHttpAddress).filter(StringUtils::isNotBlank), this.getInitialHosts().stream().filter(address -> address.startsWith("http"))).distinct().collect(Collectors.toList());
        if (httpAddresses.isEmpty()) {
            return Optional.empty();
        }
        return this.clusterState.httpResolver.resolveLeader(httpAddresses);
    }

    private class ClusterState
    implements ClusterUpdateCallback,
    Closeable {
        private final HttpClusterNodeResolver httpResolver;
        private final RpcClusterNodeResolver rpcResolver;
        private Map<Node, NodeStatus> currentNodes = new ConcurrentHashMap<Node, NodeStatus>();

        private ClusterState(HttpClientProvider clientProvider, InetSocketAddress rpcBindAddress, String rpcAddress) throws IOException {
            this.httpResolver = new HttpClusterNodeResolver(clientProvider, this);
            this.rpcResolver = new RpcClusterNodeResolver(rpcBindAddress, rpcAddress, this, ClusterStateHolder.this);
        }

        public String getCurrentRpcAddress() {
            return this.rpcResolver.getRpcAddress();
        }

        public Stream<NodeStatus> getNodes() {
            this.loadNodesInformation();
            return this.currentNodes.values().stream();
        }

        public int getNodesCount() {
            return this.currentNodes.size();
        }

        private void loadNodesInformation() {
            if (this.currentNodes.isEmpty()) {
                List<NodeStatus> nodes = this.httpResolver.resolveNodesStatus(ClusterStateHolder.this.initialHosts);
                nodes.stream().filter(NodeStatus::isValid).forEach(node -> this.currentNodes.put(node.getNode(), (NodeStatus)node));
                List<String> rpcAddresses = Stream.concat(ClusterStateHolder.this.initialHosts.stream(), nodes.stream().map(NodeStatus::getRpcAddress).filter(StringUtils::isNotBlank)).distinct().collect(Collectors.toList());
                this.rpcResolver.registerRpcListener(rpcAddresses);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ensuring registered nodes {}", (Object)this.printCurrentNodes());
                }
                if (this.currentNodes.values().stream().anyMatch(status -> status.isDisconnected() || status.notInCluster())) {
                    ArrayList<String> addressesToRegister = new ArrayList<String>();
                    for (Map.Entry<Node, NodeStatus> nodeWithStatus : this.currentNodes.entrySet()) {
                        if (!nodeWithStatus.getValue().isDisconnected() && !nodeWithStatus.getValue().notInCluster()) continue;
                        addressesToRegister.add(nodeWithStatus.getKey().getRpcAddress());
                    }
                    LOGGER.info("Retrying to register {}", addressesToRegister);
                    this.rpcResolver.retryRegisterAddresses(addressesToRegister);
                }
                this.rpcResolver.ensureRegistered(() -> this.currentNodes.keySet().stream().map(Node::getRpcAddress).collect(Collectors.toList()));
            }
        }

        private String printCurrentNodes() {
            StringBuilder currentNodesString = new StringBuilder();
            for (Node node : this.currentNodes.keySet()) {
                currentNodesString.append(node.getHttpAddress()).append("=").append(this.currentNodes.get(node).getStatus().name()).append(";");
            }
            return currentNodesString.toString();
        }

        @Override
        public void nodeUpdated(NodeStatus status) {
            this.currentNodes.compute(status.getNode(), (node, oldValue) -> {
                if (oldValue == null) {
                    LOGGER.info("Setting node {} status to {}", (Object)status.getNode().getHttpAddress(), (Object)status.getStatus().name());
                    return new NodeStatus(status.getNode(), status.getStatus());
                }
                if (status.notInCluster()) {
                    return null;
                }
                LOGGER.info("Changing node {} status to {}", (Object)status.getNode().getHttpAddress(), (Object)status.getStatus().name());
                return oldValue.setStatus(status.getStatus());
            });
            if (!status.notInCluster()) {
                ClusterStateHolder.this.clusterAddresses.add(status.getHttpAddress());
                ClusterStateHolder.this.clusterAddresses.add(status.getRpcAddress());
            }
            this.currentNodes.values().removeIf(NodeStatus::notInCluster);
            if (this.currentNodes.values().stream().filter(NodeStatus::isLeader).count() > 1L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Detected multiple leaders: {}", this.currentNodes);
                }
                this.currentNodes.clear();
                this.rpcResolver.setNoCluster();
            } else if (this.currentNodes.isEmpty()) {
                LOGGER.info("Cluster has been deleted. No active nodes");
                this.rpcResolver.setNoCluster();
            } else if (this.currentNodes.values().stream().anyMatch(NodeStatus::isLeader)) {
                this.currentNodes.values().forEach(ClusterStateHolder.this.onClusterUpdate::nodeUpdated);
            }
        }

        @Override
        public void nodeRemoved(Node node) {
            this.currentNodes.remove(node);
            ClusterStateHolder.this.onClusterUpdate.nodeRemoved(node);
            ClusterStateHolder.this.clusterAddresses.remove(node.getHttpAddress());
            ClusterStateHolder.this.clusterAddresses.remove(node.getRpcAddress());
        }

        public void nodeBecomeAccessible(NodeStatus nodeStatus) {
            this.rpcResolver.recheckNodeState(nodeStatus);
            this.httpResolver.recheckNodeState(nodeStatus);
        }

        public void nodeBecomeInaccessible(NodeStatus nodeStatus) {
            this.currentNodes.remove(nodeStatus.getNode());
        }

        @Override
        public void close() {
            try {
                this.httpResolver.close();
            }
            finally {
                this.rpcResolver.close();
            }
        }
    }
}

