/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.ConfigException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Options {
    private static final String GRAPHDB_HOSTS = "graphdb.proxy.hosts";
    private static final String GRAPHDB_FOLLOWER_RETRIES = "graphdb.proxy.followerRetries";
    private static final int DEFAULT_REQUEST_RETRIES = 3;

    private Options() {
    }

    public static List<String> getHosts() {
        String hosts = Config.getProperty((String)GRAPHDB_HOSTS);
        if (hosts == null) {
            throw new ConfigException("graphdb.proxy.hosts must be set or passed as argument to start GraphDB Cluster Proxy.");
        }
        List<String> validatedHosts = Options.parseHosts(hosts);
        if (validatedHosts.isEmpty()) {
            throw new ConfigException("graphdb.proxy.hosts must be set or passed as argument to start GraphDB Cluster Proxy.");
        }
        return validatedHosts;
    }

    @NotNull
    static List<String> parseHosts(String hosts) {
        String[] split = hosts.split("\\s*[,;]\\s*");
        return Arrays.stream(split).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public static InetSocketAddress getRpcBindAddress() {
        String rpcHost = Config.getProperty((String)"graphdb.connector.address");
        int rpcPort = Config.getRPCPort();
        return rpcHost != null ? new InetSocketAddress(rpcHost, rpcPort) : new InetSocketAddress(rpcPort);
    }

    public static int getRequestRetries() {
        return Config.getPropertyAsInt((String)GRAPHDB_FOLLOWER_RETRIES, (int)3);
    }
}

