/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyStorageIOException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.OntologyIRIMappingNotFoundException;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.DefaultChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.DefaultImpendingChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.HasAxiomsByType;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImmutableOWLOntologyChangeException;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVetoException;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactoryNotFoundException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.OWLStorerNotFoundException;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAnnotationPropertyTransformer;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.HasTrimToSize;
import uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentPriorityCollection;

public class OWLOntologyManagerImpl
implements OWLOntologyManager,
OWLOntologyFactory.OWLOntologyCreationHandler,
Serializable {
    private static final String BADLISTENER = "BADLY BEHAVING LISTENER: {} has been removed";
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLOntologyManagerImpl.class);
    protected final Map<OWLOntologyID, OWLOntology> ontologiesByID = CollectionFactory.createSyncMap();
    protected final Map<OWLOntologyID, IRI> documentIRIsByID = CollectionFactory.createSyncMap();
    protected final Map<OWLOntologyID, OWLOntologyLoaderConfiguration> ontologyConfigurationsByOntologyID = CollectionFactory.createSyncMap();
    protected final Map<OWLOntologyID, OWLDocumentFormat> ontologyFormatsByOntology = CollectionFactory.createSyncMap();
    protected final Map<OWLImportsDeclaration, OWLOntologyID> ontologyIDsByImportsDeclaration = CollectionFactory.createSyncMap();
    protected final AtomicInteger loadCount = new AtomicInteger(0);
    protected final AtomicInteger importsLoadCount = new AtomicInteger(0);
    protected final Map<IRI, Object> importedIRIs = CollectionFactory.createSyncMap();
    protected final OWLDataFactory dataFactory;
    protected final Map<OWLOntologyID, Set<OWLOntology>> importsClosureCache = CollectionFactory.createSyncMap();
    protected final List<MissingImportListener> missingImportsListeners = CollectionFactory.createSyncList();
    protected final List<OWLOntologyLoaderListener> loaderListeners = CollectionFactory.createSyncList();
    protected final List<OWLOntologyChangeProgressListener> progressListeners = CollectionFactory.createSyncList();
    protected final AtomicLong autoGeneratedURICounter = new AtomicLong();
    protected final PriorityCollection<OWLOntologyIRIMapper> documentMappers;
    protected final PriorityCollection<OWLOntologyFactory> ontologyFactories;
    protected final PriorityCollection<OWLParserFactory> parserFactories;
    protected final PriorityCollection<OWLStorerFactory> ontologyStorers;
    private final AtomicBoolean broadcastChanges = new AtomicBoolean(true);
    private final Lock readLock;
    private final Lock writeLock;
    private final ReadWriteLock lock;
    protected OWLOntologyChangeBroadcastStrategy defaultChangeBroadcastStrategy = new DefaultChangeBroadcastStrategy();
    protected ImpendingOWLOntologyChangeBroadcastStrategy defaultImpendingChangeBroadcastStrategy = new DefaultImpendingChangeBroadcastStrategy();
    private transient Map<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy> listenerMap = CollectionFactory.createSyncMap();
    private transient Map<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy> impendingChangeListenerMap = CollectionFactory.createSyncMap();
    private transient List<OWLOntologyChangesVetoedListener> vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
    private OntologyConfigurator configProvider = new OntologyConfigurator();
    private transient Optional<OWLOntologyLoaderConfiguration> loaderConfig = OWLAPIPreconditions.emptyOptional();
    private transient Optional<OWLOntologyWriterConfiguration> writerConfig = OWLAPIPreconditions.emptyOptional();

    @Inject
    public OWLOntologyManagerImpl(OWLDataFactory dataFactory, ReadWriteLock readWriteLock) {
        this(dataFactory, readWriteLock, PriorityCollectionSorting.ON_SET_INJECTION_ONLY);
    }

    public OWLOntologyManagerImpl(OWLDataFactory dataFactory, ReadWriteLock readWriteLock, PriorityCollectionSorting sorting) {
        this.dataFactory = (OWLDataFactory)OWLAPIPreconditions.checkNotNull((Object)dataFactory, (String)"dataFactory cannot be null");
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.lock = readWriteLock;
        this.documentMappers = new ConcurrentPriorityCollection<OWLOntologyIRIMapper>(readWriteLock, sorting);
        this.ontologyFactories = new ConcurrentPriorityCollection<OWLOntologyFactory>(readWriteLock, sorting);
        this.parserFactories = new ConcurrentPriorityCollection<OWLParserFactory>(readWriteLock, sorting);
        this.ontologyStorers = new ConcurrentPriorityCollection<OWLStorerFactory>(readWriteLock, sorting);
    }

    public void clearOntologies() {
        this.writeLock.lock();
        try {
            this.documentIRIsByID.clear();
            this.impendingChangeListenerMap.clear();
            this.importedIRIs.clear();
            this.importsClosureCache.clear();
            this.listenerMap.clear();
            this.loaderListeners.clear();
            this.missingImportsListeners.clear();
            this.ontologiesByID.values().forEach(o -> o.setOWLOntologyManager(null));
            this.ontologiesByID.clear();
            this.ontologyConfigurationsByOntologyID.clear();
            this.ontologyFormatsByOntology.clear();
            this.ontologyIDsByImportsDeclaration.clear();
            this.progressListeners.clear();
            this.vetoListeners.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OntologyConfigurator getOntologyConfigurator() {
        this.readLock.lock();
        try {
            OntologyConfigurator ontologyConfigurator = this.configProvider;
            return ontologyConfigurator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOntologyConfigurator(OntologyConfigurator configurator) {
        this.writeLock.lock();
        try {
            this.configProvider = configurator;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLOntologyLoaderConfiguration getOntologyLoaderConfiguration() {
        this.readLock.lock();
        try {
            if (this.loaderConfig.isPresent()) {
                OWLOntologyLoaderConfiguration oWLOntologyLoaderConfiguration = this.loaderConfig.get();
                return oWLOntologyLoaderConfiguration;
            }
            OWLOntologyLoaderConfiguration oWLOntologyLoaderConfiguration = this.configProvider.buildLoaderConfiguration();
            return oWLOntologyLoaderConfiguration;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOntologyLoaderConfiguration(OWLOntologyLoaderConfiguration newConfig) {
        this.writeLock.lock();
        try {
            this.loaderConfig = OWLAPIPreconditions.optional((Object)newConfig);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLOntologyWriterConfiguration getOntologyWriterConfiguration() {
        this.readLock.lock();
        try {
            if (this.writerConfig.isPresent()) {
                OWLOntologyWriterConfiguration oWLOntologyWriterConfiguration = this.writerConfig.get();
                return oWLOntologyWriterConfiguration;
            }
            OWLOntologyWriterConfiguration oWLOntologyWriterConfiguration = this.configProvider.buildWriterConfiguration();
            return oWLOntologyWriterConfiguration;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOntologyWriterConfiguration(OWLOntologyWriterConfiguration newConfig) {
        this.writeLock.lock();
        try {
            this.writerConfig = OWLAPIPreconditions.optional((Object)newConfig);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    public Stream<OWLOntology> ontologies() {
        this.readLock.lock();
        try {
            Stream<OWLOntology> stream = this.ontologiesByID.values().stream();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLOntology> ontologies(OWLAxiom axiom) {
        this.readLock.lock();
        try {
            Stream<OWLOntology> stream = this.ontologies().filter(o -> o.containsAxiom(axiom));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(OWLOntology ontology) {
        this.readLock.lock();
        try {
            boolean bl = this.ontologiesByID.containsValue(ontology);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"Ontology IRI cannot be null");
        this.readLock.lock();
        try {
            boolean bl = this.ids().anyMatch(o -> o.match(iri));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected Stream<OWLOntologyID> ids() {
        this.readLock.lock();
        try {
            Stream<OWLOntologyID> stream = this.ontologiesByID.keySet().stream();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(OWLOntologyID id) {
        if (id.isAnonymous()) {
            return false;
        }
        this.readLock.lock();
        try {
            if (this.ontologiesByID.containsKey(id)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.ids().anyMatch(arg_0 -> ((OWLOntologyID)id).match(arg_0));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsVersion(IRI iri) {
        this.readLock.lock();
        try {
            boolean bl = this.ids().anyMatch(o -> o.matchVersion(iri));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLOntologyID> ontologyIDsByVersion(IRI iri) {
        this.readLock.lock();
        try {
            Stream<OWLOntologyID> stream = this.ids().filter(o -> o.matchVersion(iri));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OWLOntology getOntology(IRI iri) {
        OWLOntologyID ontologyID = new OWLOntologyID(OWLAPIPreconditions.optional((Object)iri), OWLAPIPreconditions.emptyOptional());
        this.readLock.lock();
        try {
            OWLOntology result = this.ontologiesByID.get(ontologyID);
            if (result != null) {
                OWLOntology oWLOntology = result;
                return oWLOntology;
            }
            Optional<Map.Entry> findAny = this.ontologiesByID.entrySet().stream().filter(o -> ((OWLOntologyID)o.getKey()).match(iri)).findAny();
            OWLOntology oWLOntology = findAny.isPresent() ? (OWLOntology)findAny.get().getValue() : null;
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OWLOntology getOntology(OWLOntologyID id) {
        this.readLock.lock();
        try {
            Optional<OWLOntologyID> findAny;
            OWLOntology result = this.ontologiesByID.get(id);
            if (result == null && !id.isAnonymous() && (findAny = this.ids().filter(o -> o.matchOntology((IRI)id.getOntologyIRI().get())).findAny()).isPresent()) {
                result = this.ontologiesByID.get(findAny.get());
            }
            if (result == null) {
                this.checkDocumentIRI(id);
            }
            OWLOntology oWLOntology = result;
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void checkDocumentIRI(OWLOntologyID id) {
        IRI documentIRI = this.getDocumentIRIFromMappers(id);
        if (documentIRI != null && this.documentIRIsByID.values().contains(documentIRI)) {
            throw new OWLRuntimeException((Throwable)new OWLOntologyDocumentAlreadyExistsException(documentIRI));
        }
    }

    public Stream<OWLOntology> versions(IRI ontology) {
        this.readLock.lock();
        try {
            Stream stream = super.versions(ontology);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OWLOntology getImportedOntology(OWLImportsDeclaration declaration) {
        this.readLock.lock();
        try {
            OWLOntologyID ontologyID = this.ontologyIDsByImportsDeclaration.get(declaration);
            if (ontologyID == null) {
                OWLOntology ontology = this.getOntology(declaration.getIRI());
                if (ontology == null) {
                    ontology = this.getOntologyByDocumentIRI(declaration.getIRI());
                }
                OWLOntology oWLOntology = ontology;
                return oWLOntology;
            }
            OWLOntology oWLOntology = this.getOntology(ontologyID);
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLOntology> directImports(OWLOntology ontology) {
        this.readLock.lock();
        try {
            if (!this.contains(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            Stream<OWLOntology> stream = ontology.importsDeclarations().map(this::getImportedOntology).filter(Objects::nonNull);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Stream<OWLOntology> imports(OWLOntology ontology) {
        this.readLock.lock();
        try {
            Stream<OWLOntology> stream = this.getImports(ontology, new TreeSet<OWLOntology>()).stream();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<OWLOntology> getImports(OWLOntology ont, Set<OWLOntology> result) {
        this.readLock.lock();
        try {
            this.directImports(ont).filter(result::add).forEach(o -> this.getImports((OWLOntology)o, result));
            Set<OWLOntology> set = result;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLOntology> importsClosure(OWLOntology ontology) {
        this.readLock.lock();
        try {
            OWLOntologyID id = ontology.getOntologyID();
            Stream<OWLOntology> stream = this.importsClosureCache.computeIfAbsent(id, i -> this.getImportsClosure(ontology, new TreeSet<OWLOntology>())).stream();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<OWLOntology> getImportsClosure(OWLOntology ontology, Set<OWLOntology> ontologies) {
        this.readLock.lock();
        try {
            ontologies.add(ontology);
            this.directImports(ontology).filter(o -> !ontologies.contains(o)).forEach(o -> this.getImportsClosure((OWLOntology)o, ontologies));
            Set<OWLOntology> set = ontologies;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<OWLOntology> getSortedImportsClosure(OWLOntology ontology) {
        this.readLock.lock();
        try {
            List list = OWLAPIStreamUtils.asList(ontology.importsClosure().sorted());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isChangeApplicable(OWLOntologyChange change) {
        OWLOntologyLoaderConfiguration ontologyConfig = this.ontologyConfigurationsByOntologyID.get(change.getOntology().getOntologyID());
        return ontologyConfig == null || ontologyConfig.isLoadAnnotationAxioms() || !change.isAddAxiom() || !(change.getAxiom() instanceof OWLAnnotationAxiom);
    }

    private ChangeApplied enactChangeApplication(OWLOntologyChange change) {
        if (!this.isChangeApplicable(change)) {
            return ChangeApplied.UNSUCCESSFULLY;
        }
        OWLOntology ont = change.getOntology();
        if (!(ont instanceof OWLMutableOntology)) {
            throw new ImmutableOWLOntologyChangeException(change.getChangeData(), ont.toString());
        }
        this.checkForOntologyIDChange(change);
        ChangeApplied appliedChange = ((OWLMutableOntology)ont).applyDirectChange(change);
        this.checkForImportsChange(change);
        return appliedChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> changes) {
        this.writeLock.lock();
        try {
            this.broadcastImpendingChanges(changes);
            AtomicBoolean rollbackRequested = new AtomicBoolean(false);
            AtomicBoolean allNoOps = new AtomicBoolean(true);
            ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
            this.fireBeginChanges(changes.size());
            this.actuallyApply(changes, rollbackRequested, allNoOps, appliedChanges);
            if (rollbackRequested.get()) {
                this.rollBack(appliedChanges);
                appliedChanges.clear();
            }
            this.fireEndChanges();
            this.broadcastChanges(appliedChanges);
            if (rollbackRequested.get()) {
                ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, appliedChanges);
                return changeDetails;
            }
            if (allNoOps.get()) {
                ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.NO_OPERATION, appliedChanges);
                return changeDetails;
            }
            ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.SUCCESSFULLY, appliedChanges);
            return changeDetails;
        }
        catch (OWLOntologyChangeVetoException e) {
            this.broadcastOntologyChangesVetoed(changes, e);
            ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, Collections.emptyList());
            return changeDetails;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void actuallyApply(List<? extends OWLOntologyChange> changes, AtomicBoolean rollbackRequested, AtomicBoolean allNoOps, List<OWLOntologyChange> appliedChanges) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (rollbackRequested.get()) continue;
            assert (oWLOntologyChange != null);
            ChangeApplied enactChangeApplication = this.enactChangeApplication(oWLOntologyChange);
            if (enactChangeApplication == ChangeApplied.UNSUCCESSFULLY) {
                rollbackRequested.set(true);
            }
            if (enactChangeApplication == ChangeApplied.SUCCESSFULLY) {
                allNoOps.set(false);
                appliedChanges.add(oWLOntologyChange);
            }
            this.fireChangeApplied(oWLOntologyChange);
        }
    }

    protected void rollBack(List<OWLOntologyChange> appliedChanges) {
        for (OWLOntologyChange c : appliedChanges) {
            if (this.enactChangeApplication(c.reverseChange()) != ChangeApplied.UNSUCCESSFULLY) continue;
            throw new OWLRuntimeException("Rollback of changes unsuccessful: Change " + String.valueOf(c) + " could not be rolled back");
        }
    }

    public ChangeApplied addAxiom(OWLOntology ont, OWLAxiom axiom) {
        return this.applyChanges(CollectionFactory.list((Object)new AddAxiom(ont, axiom)));
    }

    public ChangeApplied addAxioms(OWLOntology ont, Stream<? extends OWLAxiom> axioms) {
        return this.applyChanges(OWLAPIStreamUtils.asList(axioms.map(ax -> new AddAxiom(ont, ax))));
    }

    public ChangeApplied removeAxiom(OWLOntology ont, OWLAxiom axiom) {
        return this.applyChanges(CollectionFactory.list((Object)new RemoveAxiom(ont, axiom)));
    }

    public ChangeApplied removeAxioms(OWLOntology ont, Stream<? extends OWLAxiom> axioms) {
        return this.applyChanges(OWLAPIStreamUtils.asList(axioms.map(ax -> new RemoveAxiom(ont, ax))));
    }

    public ChangeApplied applyChange(OWLOntologyChange change) {
        return this.applyChanges(CollectionFactory.list((Object)change));
    }

    private void checkForImportsChange(OWLOntologyChange change) {
        if (change.isImportChange()) {
            this.resetImportsClosureCache();
            if (change instanceof AddImport) {
                OWLImportsDeclaration addImportDeclaration = ((AddImport)change).getImportDeclaration();
                IRI iri = addImportDeclaration.getIRI();
                Optional<OWLOntologyID> findFirst = this.ids().filter(o -> o.match(iri) || o.matchDocument(iri)).findFirst();
                findFirst.ifPresent(o -> this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, (OWLOntologyID)o));
                if (!findFirst.isPresent()) {
                    this.documentIRIsByID.entrySet().stream().filter(o -> ((IRI)o.getValue()).equals((Object)iri)).findAny().ifPresent(o -> this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, (OWLOntologyID)o.getKey()));
                }
            } else {
                OWLImportsDeclaration importDeclaration = ((RemoveImport)change).getImportDeclaration();
                this.ontologyIDsByImportsDeclaration.remove(importDeclaration);
                this.importedIRIs.remove(importDeclaration.getIRI());
            }
        }
    }

    private void checkForOntologyIDChange(OWLOntologyChange change) {
        if (!(change instanceof SetOntologyID)) {
            return;
        }
        SetOntologyID setID = (SetOntologyID)change;
        OWLOntology existingOntology = this.ontologiesByID.get(setID.getNewOntologyID());
        OWLOntology o = setID.getOntology();
        if (existingOntology != null && !o.equals((Object)existingOntology) && !o.equalAxioms((HasAxiomsByType)existingOntology)) {
            String location = "OWLOntologyManagerImpl.checkForOntologyIDChange()";
            LOGGER.error(location + " existing:{}", (Object)existingOntology);
            LOGGER.error(location + " new:{}", (Object)o);
            Set diff1 = OWLAPIStreamUtils.asUnorderedSet((Stream)o.logicalAxioms());
            Set diff2 = OWLAPIStreamUtils.asUnorderedSet((Stream)existingOntology.logicalAxioms());
            existingOntology.logicalAxioms().forEach(diff1::remove);
            o.logicalAxioms().forEach(diff2::remove);
            LOGGER.error(location + " only in existing:{}", (Object)diff2);
            LOGGER.error(location + " only in new:{}", (Object)diff1);
            throw new OWLOntologyRenameException((OWLOntologyChangeData)setID.getChangeData(), setID.getNewOntologyID());
        }
        this.renameOntology(setID.getOriginalOntologyID(), setID.getNewOntologyID());
        this.resetImportsClosureCache();
    }

    public void ontologyCreated(OWLOntology ontology) {
        this.addOntology(ontology);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOntologyFormat(OWLOntology ontology, OWLDocumentFormat ontologyFormat) {
        this.writeLock.lock();
        try {
            OWLOntologyID ontologyID = ontology.getOntologyID();
            this.ontologyFormatsByOntology.put(ontologyID, ontologyFormat);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OWLDocumentFormat getOntologyFormat(OWLOntology ontology) {
        this.readLock.lock();
        try {
            OWLOntologyID ontologyID = ontology.getOntologyID();
            OWLDocumentFormat oWLDocumentFormat = this.ontologyFormatsByOntology.get(ontologyID);
            return oWLDocumentFormat;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public OWLOntology createOntology(OWLOntologyID ontologyID) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLOntology ontology = this.ontologiesByID.get(ontologyID);
            if (ontology != null) {
                throw new OWLOntologyAlreadyExistsException(ontologyID);
            }
            IRI documentIRI = this.computeDocumentIRI(ontologyID);
            if (this.documentIRIsByID.values().contains(documentIRI)) {
                throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
            }
            for (OWLOntologyFactory factory : this.ontologyFactories) {
                if (!factory.canCreateFromDocumentIRI(documentIRI)) continue;
                this.documentIRIsByID.put(ontologyID, documentIRI);
                factory.setLock(this.lock);
                OWLOntology oWLOntology = factory.createOWLOntology((OWLOntologyManager)this, ontologyID, documentIRI, (OWLOntologyFactory.OWLOntologyCreationHandler)this);
                return oWLOntology;
            }
            throw new OWLOntologyFactoryNotFoundException(documentIRI);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected IRI computeDocumentIRI(OWLOntologyID ontologyID) {
        IRI documentIRI = this.getDocumentIRIFromMappers(ontologyID);
        if (documentIRI == null) {
            documentIRI = !ontologyID.isAnonymous() ? (IRI)ontologyID.getDefaultDocumentIRI().orElse(null) : IRI.generateDocumentIRI();
        }
        return documentIRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology createOntology(IRI ontologyIRI, Stream<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            if (this.contains(ontologyIRI)) {
                throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(OWLAPIPreconditions.optional((Object)ontologyIRI), OWLAPIPreconditions.emptyOptional()));
            }
            OWLOntology ont = this.createOntology(ontologyIRI);
            this.addAxioms(ont, ontologies.flatMap(o -> copyLogicalAxiomsOnly ? o.logicalAxioms() : o.axioms()));
            OWLOntology oWLOntology = ont;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology createOntology(Stream<OWLAxiom> axioms, IRI ontologyIRI) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            if (this.contains(ontologyIRI)) {
                throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(OWLAPIPreconditions.optional((Object)ontologyIRI), OWLAPIPreconditions.emptyOptional()));
            }
            OWLOntology ont = this.createOntology(ontologyIRI);
            this.addAxioms(ont, axioms);
            OWLOntology oWLOntology = ont;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology copyOntology(OWLOntology toCopy, OntologyCopy settings) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLAPIPreconditions.checkNotNull((Object)toCopy);
            OWLAPIPreconditions.checkNotNull((Object)settings);
            OWLOntology toReturn = null;
            switch (settings) {
                case MOVE: {
                    toReturn = toCopy;
                    this.ontologiesByID.put(toReturn.getOntologyID(), toReturn);
                    break;
                }
                case SHALLOW: 
                case DEEP: {
                    OWLOntology o = this.createOntology(toCopy.getOntologyID());
                    AxiomType.AXIOM_TYPES.forEach(t -> this.addAxioms(o, toCopy.axioms(t)));
                    toCopy.annotations().forEach(a -> this.applyChange((OWLOntologyChange)new AddOntologyAnnotation(o, a)));
                    toCopy.importsDeclarations().forEach(a -> this.applyChange((OWLOntologyChange)new AddImport(o, a)));
                    toReturn = o;
                    break;
                }
                default: {
                    throw new OWLRuntimeException("settings value not understood: " + String.valueOf(settings));
                }
            }
            OWLOntologyManager m = toCopy.getOWLOntologyManager();
            if (settings == OntologyCopy.MOVE || settings == OntologyCopy.DEEP) {
                this.setOntologyDocumentIRI(toReturn, m.getOntologyDocumentIRI(toCopy));
                OWLDocumentFormat ontologyFormat = m.getOntologyFormat(toCopy);
                if (ontologyFormat != null) {
                    this.setOntologyFormat(toReturn, ontologyFormat);
                }
            }
            if (settings == OntologyCopy.MOVE) {
                m.removeOntology(toCopy);
                toReturn.setOWLOntologyManager((OWLOntologyManager)this);
                if (toReturn instanceof OWLMutableOntology) {
                    ((OWLMutableOntology)toReturn).setLock(this.lock);
                }
            }
            OWLOntology oWLOntology = toReturn;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLOntology loadOntology(IRI ontologyIRI) throws OWLOntologyCreationException {
        Object value = new Object();
        if (!this.importedIRIs.containsKey(ontologyIRI)) {
            this.importedIRIs.put(ontologyIRI, value);
        }
        OWLOntology loadOntology = this.loadOntology(ontologyIRI, false, this.getOntologyLoaderConfiguration());
        this.importedIRIs.remove(ontologyIRI, value);
        return loadOntology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OWLOntology loadOntology(IRI iri, boolean allowExists, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLOntology ontByDocumentIRI;
            OWLOntology ontByID = null;
            Optional<OWLOntologyID> findAny = this.ids().filter(o -> o.match(iri)).findAny();
            if (findAny.isPresent()) {
                ontByID = this.ontologiesByID.get(findAny.get());
            }
            if (ontByID != null) {
                OWLOntology oWLOntology = ontByID;
                return oWLOntology;
            }
            OWLOntologyID id = new OWLOntologyID(OWLAPIPreconditions.optional((Object)iri), OWLAPIPreconditions.emptyOptional());
            IRI documentIRI = this.getDocumentIRIFromMappers(id);
            if (documentIRI != null) {
                if (this.documentIRIsByID.values().contains(documentIRI) && !allowExists) {
                    throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
                }
                ontByDocumentIRI = this.loadOntologyByDocumentIRI(documentIRI);
                if (ontByDocumentIRI != null) {
                    OWLOntology oWLOntology = ontByDocumentIRI;
                    return oWLOntology;
                }
            } else {
                throw new OntologyIRIMappingNotFoundException(iri);
            }
            if (this.documentIRIsByID.values().contains(documentIRI) && !allowExists) {
                throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
            }
            ontByDocumentIRI = this.loadOntologyByDocumentIRI(documentIRI);
            if (ontByDocumentIRI != null) {
                OWLOntology oWLOntology = ontByDocumentIRI;
                return oWLOntology;
            }
            OWLOntology oWLOntology = this.loadOntology(iri, (OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI, null, null), configuration);
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OWLOntology loadOntologyByDocumentIRI(IRI iri) {
        this.readLock.lock();
        try {
            Optional<Map.Entry> findAny = this.documentIRIsByID.entrySet().stream().filter(o -> iri.equals(o.getValue())).findAny();
            if (findAny.isPresent()) {
                OWLOntology oWLOntology = this.getOntology((OWLOntologyID)findAny.get().getKey());
                return oWLOntology;
            }
            OWLOntology oWLOntology = null;
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OWLOntology getOntologyByDocumentIRI(IRI documentIRI) {
        this.readLock.lock();
        try {
            Optional<Map.Entry> findAny = this.documentIRIsByID.entrySet().stream().filter(o -> documentIRI.equals(o.getValue())).findAny();
            if (findAny.isPresent()) {
                OWLOntology oWLOntology = this.ontologiesByID.get(findAny.get().getKey());
                return oWLOntology;
            }
            OWLOntology oWLOntology = null;
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public OWLOntology loadOntologyFromOntologyDocument(IRI documentIRI) throws OWLOntologyCreationException {
        return this.loadOntology(null, (OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI, null, null), this.getOntologyLoaderConfiguration());
    }

    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, this.getOntologyLoaderConfiguration());
    }

    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, conf);
    }

    public OWLOntology loadOntologyFromOntologyDocument(File file) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new FileDocumentSource(file));
    }

    public OWLOntology loadOntologyFromOntologyDocument(InputStream inputStream) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new StreamDocumentSource(inputStream));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OWLOntology loadOntology(@Nullable IRI ontologyIRI, OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLOntologyID idOfLoadedOntology;
            Throwable ex;
            block13: {
                OWLOntology oWLOntology;
                if (this.loadCount.get() != this.importsLoadCount.get()) {
                    LOGGER.warn("Runtime Warning: Parsers should load imported ontologies using the makeImportLoadRequest method.");
                }
                this.fireStartedLoadingEvent(new OWLOntologyID(OWLAPIPreconditions.optional((Object)ontologyIRI), OWLAPIPreconditions.emptyOptional()), documentSource.getDocumentIRI(), this.loadCount.get() > 0);
                this.loadCount.incrementAndGet();
                this.broadcastChanges.set(false);
                ex = null;
                idOfLoadedOntology = new OWLOntologyID();
                try {
                    OWLOntology o = this.load(documentSource, configuration);
                    if (o == null) break block13;
                    idOfLoadedOntology = o.getOntologyID();
                    oWLOntology = o;
                    if (this.loadCount.decrementAndGet() == 0) {
                        this.broadcastChanges.set(true);
                    }
                }
                catch (OWLOntologyCreationException | UnloadableImportException e) {
                    try {
                        ex = e;
                        throw e;
                        catch (OWLRuntimeException e2) {
                            if (!(e2.getCause() instanceof OWLOntologyCreationException)) throw e2;
                            ex = (OWLOntologyCreationException)e2.getCause();
                            throw (OWLOntologyCreationException)e2.getCause();
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.loadCount.decrementAndGet() == 0) {
                            this.broadcastChanges.set(true);
                        }
                        this.fireFinishedLoadingEvent(idOfLoadedOntology, documentSource.getDocumentIRI(), this.loadCount.get() > 0, (Exception)ex);
                        throw throwable;
                    }
                }
                this.fireFinishedLoadingEvent(idOfLoadedOntology, documentSource.getDocumentIRI(), this.loadCount.get() > 0, (Exception)ex);
                return oWLOntology;
            }
            if (this.loadCount.decrementAndGet() == 0) {
                this.broadcastChanges.set(true);
            }
            this.fireFinishedLoadingEvent(idOfLoadedOntology, documentSource.getDocumentIRI(), this.loadCount.get() > 0, (Exception)ex);
            throw new OWLOntologyFactoryNotFoundException(documentSource.getDocumentIRI());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Nullable
    protected OWLOntology load(OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        if (documentSource instanceof IRIDocumentSource) {
            IRIDocumentSource source = (IRIDocumentSource)documentSource;
            Optional<Map.Entry> findAny = this.documentIRIsByID.entrySet().stream().filter(v -> Objects.equals(source.getDocumentIRI(), v.getValue())).findAny();
            if (findAny.isPresent()) {
                return this.getOntology((OWLOntologyID)findAny.get().getKey());
            }
        }
        for (OWLOntologyFactory factory : this.ontologyFactories) {
            if (!factory.canAttemptLoading(documentSource)) continue;
            try {
                factory.setLock(this.lock);
                OWLOntology ontology = factory.loadOWLOntology((OWLOntologyManager)this, documentSource, (OWLOntologyFactory.OWLOntologyCreationHandler)this, configuration);
                if (configuration.shouldRepairIllegalPunnings()) {
                    this.fixIllegalPunnings(ontology);
                }
                this.documentIRIsByID.put(ontology.getOntologyID(), documentSource.getDocumentIRI());
                this.ontologyConfigurationsByOntologyID.put(ontology.getOntologyID(), configuration);
                if (ontology instanceof HasTrimToSize && configuration.shouldTrimToSize()) {
                    ((HasTrimToSize)ontology).trimToSize();
                }
                return ontology;
            }
            catch (OWLOntologyRenameException e) {
                throw new OWLOntologyAlreadyExistsException(e.getOntologyID(), (Throwable)e);
            }
        }
        return null;
    }

    protected void fixIllegalPunnings(OWLOntology o) {
        Collection illegals = OWLDocumentFormat.determineIllegalPunnings((boolean)true, Imports.INCLUDED.stream((HasImportsClosure)o).flatMap(HasSignature::unsortedSignature), (Collection)o.getPunnedIRIs(Imports.INCLUDED));
        HashMap illegalDeclarations = new HashMap();
        o.axioms(AxiomType.DECLARATION, Imports.INCLUDED).filter(d -> illegals.contains(d.getEntity().getIRI())).forEach(d -> illegalDeclarations.computeIfAbsent(d.getEntity().getIRI(), x -> new HashSet()).add(d));
        HashMap<OWLAnnotationProperty, OWLEntity> replacementMap = new HashMap<OWLAnnotationProperty, OWLEntity>();
        for (Map.Entry e : illegalDeclarations.entrySet()) {
            if (((Collection)e.getValue()).size() == 1) {
                OWLDeclarationAxiom correctDeclaration = (OWLDeclarationAxiom)((Collection)e.getValue()).iterator().next();
                OWLEntity entity = correctDeclaration.getEntity();
                if (!entity.isOWLDataProperty() && !entity.isOWLObjectProperty()) continue;
                OWLAnnotationProperty wrongProperty = this.dataFactory.getOWLAnnotationProperty(entity.getIRI());
                replacementMap.put(wrongProperty, entity);
                continue;
            }
            String errorMessage = "Illegal redeclarations of entities: reuse of entity {} in punning not allowed {}";
            LOGGER.warn(errorMessage, e.getKey(), e.getValue());
        }
        OWLAnnotationPropertyTransformer changer = new OWLAnnotationPropertyTransformer(replacementMap, this.dataFactory);
        ArrayList list = new ArrayList();
        o.importsClosure().forEach(ont -> {
            for (OWLEntity e : replacementMap.keySet()) {
                ont.referencingAxioms((OWLPrimitive)e).forEach(ax -> {
                    list.add(new RemoveAxiom(ont, ax));
                    list.add(new AddAxiom(ont, (OWLAxiom)changer.transformObject((OWLObject)ax)));
                });
            }
        });
        o.getOWLOntologyManager().applyChanges(list);
    }

    public void removeOntology(OWLOntology ontology) {
        this.writeLock.lock();
        try {
            this.removeOntology(ontology.getOntologyID());
            ontology.setOWLOntologyManager(null);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntology(OWLOntologyID ontologyID) {
        this.writeLock.lock();
        try {
            OWLOntology o = this.ontologiesByID.remove(ontologyID);
            this.ontologyFormatsByOntology.remove(ontologyID);
            this.documentIRIsByID.remove(ontologyID);
            this.removeValue(this.ontologyIDsByImportsDeclaration, ontologyID);
            this.removeValue(this.importedIRIs, ontologyID);
            if (o != null) {
                o.setOWLOntologyManager(null);
                this.resetImportsClosureCache();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected <Q, S> void removeValue(Map<Q, S> map, S id) {
        List keys = OWLAPIStreamUtils.asList(map.entrySet().stream().filter(e -> e.getValue().equals(id)).map(Map.Entry::getKey));
        keys.forEach(map::remove);
    }

    private void addOntology(OWLOntology ont) {
        this.writeLock.lock();
        try {
            this.ontologiesByID.put(ont.getOntologyID(), ont);
            this.resetImportsClosureCache();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public IRI getOntologyDocumentIRI(OWLOntology ontology) {
        this.readLock.lock();
        try {
            if (!this.contains(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            IRI iRI = (IRI)OWLAPIPreconditions.verifyNotNull((Object)this.documentIRIsByID.get(ontology.getOntologyID()));
            return iRI;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOntologyDocumentIRI(OWLOntology ontology, IRI documentIRI) {
        this.writeLock.lock();
        try {
            if (!this.ontologiesByID.containsKey(ontology.getOntologyID())) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            this.documentIRIsByID.put(ontology.getOntologyID(), documentIRI);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void renameOntology(OWLOntologyID oldID, OWLOntologyID newID) {
        IRI documentIRI;
        OWLOntology ont = this.ontologiesByID.get(oldID);
        if (ont == null) {
            return;
        }
        this.ontologiesByID.remove(oldID);
        this.ontologiesByID.put(newID, ont);
        if (this.ontologyFormatsByOntology.containsKey(oldID)) {
            this.ontologyFormatsByOntology.put(newID, this.ontologyFormatsByOntology.remove(oldID));
        }
        if ((documentIRI = this.documentIRIsByID.remove(oldID)) != null) {
            this.documentIRIsByID.put(newID, documentIRI);
        }
        this.resetImportsClosureCache();
    }

    protected void resetImportsClosureCache() {
        this.writeLock.lock();
        try {
            this.importsClosureCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void saveOntology(OWLOntology ontology) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            OWLDocumentFormat format = this.getNonnullOntologyFormat(ontology);
            this.saveOntology(ontology, format);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.saveOntology(ontology, ontologyFormat, this.getOntologyDocumentIRI(ontology));
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOntology(OWLOntology ontology, IRI documentIRI) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            OWLDocumentFormat format = this.getNonnullOntologyFormat(ontology);
            this.saveOntology(ontology, format, documentIRI);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, IRI documentIRI) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            Iterator iterator = this.ontologyStorers.iterator();
            while (iterator.hasNext()) {
                OWLStorerFactory storerFactory = (OWLStorerFactory)iterator.next();
                OWLStorer storer = storerFactory.createStorer();
                if (storer.canStoreOntology(ontologyFormat)) {
                    storer.storeOntology(ontology, documentIRI, ontologyFormat);
                    return;
                }
            }
            throw new OWLStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLOntology ontology, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, (OWLOntologyDocumentTarget)new StreamDocumentTarget(outputStream));
    }

    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, ontologyFormat, (OWLOntologyDocumentTarget)new StreamDocumentTarget(outputStream));
    }

    public void saveOntology(OWLOntology ontology, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.saveOntology(ontology, this.getNonnullOntologyFormat(ontology), documentTarget);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            Iterator iterator = this.ontologyStorers.iterator();
            while (iterator.hasNext()) {
                OWLStorerFactory storerFactory = (OWLStorerFactory)iterator.next();
                OWLStorer storer = storerFactory.createStorer();
                if (storer.canStoreOntology(ontologyFormat)) {
                    storer.storeOntology(ontology, documentTarget, ontologyFormat);
                    return;
                }
            }
            throw new OWLStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public PriorityCollection<OWLStorerFactory> getOntologyStorers() {
        return this.ontologyStorers;
    }

    @Inject
    public void setOntologyStorers(Set<OWLStorerFactory> storers) {
        this.ontologyStorers.set(storers);
    }

    public PriorityCollection<OWLOntologyIRIMapper> getIRIMappers() {
        return this.documentMappers;
    }

    @Inject
    public void setIRIMappers(Set<OWLOntologyIRIMapper> mappers) {
        this.documentMappers.set(mappers);
    }

    public void addIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.add((Serializable)mapper);
    }

    public void removeIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.remove((Serializable)mapper);
    }

    public void clearIRIMappers() {
        this.documentMappers.clear();
    }

    public void addOntologyStorer(OWLStorerFactory storer) {
        this.ontologyStorers.add((Serializable)storer);
    }

    public void removeOntologyStorer(OWLStorerFactory storer) {
        this.ontologyStorers.remove((Serializable)storer);
    }

    public void clearOntologyStorers() {
        this.ontologyStorers.clear();
    }

    public PriorityCollection<OWLParserFactory> getOntologyParsers() {
        return this.parserFactories;
    }

    @Inject
    public void setOntologyParsers(Set<OWLParserFactory> parsers) {
        this.parserFactories.set(parsers);
    }

    public PriorityCollection<OWLOntologyFactory> getOntologyFactories() {
        return this.ontologyFactories;
    }

    @Inject
    public void setOntologyFactories(Set<OWLOntologyFactory> factories) {
        this.ontologyFactories.set(factories);
    }

    @Nullable
    private IRI getDocumentIRIFromMappers(OWLOntologyID ontologyID) {
        Optional defIRI = ontologyID.getDefaultDocumentIRI();
        if (!defIRI.isPresent()) {
            return null;
        }
        for (OWLOntologyIRIMapper mapper : this.documentMappers) {
            IRI documentIRI = mapper.getDocumentIRI((IRI)defIRI.get());
            if (documentIRI == null) continue;
            return documentIRI;
        }
        return (IRI)defIRI.get();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.loaderConfig = OWLAPIPreconditions.optional((Object)((OWLOntologyLoaderConfiguration)stream.readObject()));
        this.listenerMap = new ConcurrentHashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
        this.impendingChangeListenerMap = new ConcurrentHashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
        this.vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.getOntologyLoaderConfiguration());
    }

    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.listenerMap.put(listener, this.defaultChangeBroadcastStrategy);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastChanges(List<? extends OWLOntologyChange> changes) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeListener listener : new ArrayList<OWLOntologyChangeListener>(this.listenerMap.keySet())) {
                OWLOntologyChangeBroadcastStrategy strategy = this.listenerMap.get(listener);
                if (strategy == null) continue;
                try {
                    strategy.broadcastChanges(listener, changes);
                }
                catch (Exception e) {
                    LOGGER.warn(BADLISTENER, (Object)e.getMessage(), (Object)e);
                    this.listenerMap.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastImpendingChanges(List<? extends OWLOntologyChange> changes) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (ImpendingOWLOntologyChangeListener listener : new ArrayList<ImpendingOWLOntologyChangeListener>(this.impendingChangeListenerMap.keySet())) {
                ImpendingOWLOntologyChangeBroadcastStrategy strategy = this.impendingChangeListenerMap.get(listener);
                if (strategy == null) continue;
                strategy.broadcastChanges(listener, changes);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setDefaultChangeBroadcastStrategy(OWLOntologyChangeBroadcastStrategy strategy) {
        this.writeLock.lock();
        try {
            this.defaultChangeBroadcastStrategy = strategy;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyChangeListener(OWLOntologyChangeListener listener, OWLOntologyChangeBroadcastStrategy strategy) {
        this.writeLock.lock();
        try {
            this.listenerMap.put(listener, strategy);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.impendingChangeListenerMap.put(listener, this.defaultImpendingChangeBroadcastStrategy);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.impendingChangeListenerMap.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.listenerMap.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.writeLock.lock();
        try {
            this.vetoListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.writeLock.lock();
        try {
            this.vetoListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void broadcastOntologyChangesVetoed(List<? extends OWLOntologyChange> changes, OWLOntologyChangeVetoException veto) {
        this.writeLock.lock();
        try {
            new ArrayList<OWLOntologyChangesVetoedListener>(this.vetoListeners).forEach(l -> l.ontologyChangesVetoed(changes, veto));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected OWLOntology loadImports(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            this.importsLoadCount.incrementAndGet();
            OWLOntology ont = null;
            try {
                ont = this.loadOntology(declaration.getIRI(), true, configuration);
            }
            catch (OWLOntologyCreationException e) {
                if (configuration.getMissingImportHandlingStrategy() == MissingImportHandlingStrategy.THROW_EXCEPTION) {
                    throw e;
                }
                MissingImportEvent evt = new MissingImportEvent(declaration.getIRI(), e);
                this.fireMissingImportEvent(evt);
            }
            finally {
                this.importsLoadCount.decrementAndGet();
            }
            OWLOntology oWLOntology = ont;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void makeLoadImportRequest(OWLImportsDeclaration declaration) {
        this.writeLock.lock();
        try {
            this.makeLoadImportRequest(declaration, this.getOntologyLoaderConfiguration());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeLoadImportRequest(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration configuration) {
        block6: {
            this.writeLock.lock();
            try {
                IRI iri = declaration.getIRI();
                if (configuration.isIgnoredImport(iri) || this.importedIRIs.containsKey(iri)) break block6;
                this.importedIRIs.put(iri, new Object());
                try {
                    OWLOntology ont = this.loadImports(declaration, configuration);
                    if (ont != null) {
                        this.ontologyIDsByImportsDeclaration.put(declaration, ont.getOntologyID());
                        this.importedIRIs.put(iri, ont.getOntologyID());
                    }
                }
                catch (OWLOntologyCreationException e) {
                    throw new UnloadableImportException(e, declaration);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public void addMissingImportListener(MissingImportListener listener) {
        this.writeLock.lock();
        try {
            this.missingImportsListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeMissingImportListener(MissingImportListener listener) {
        this.writeLock.lock();
        try {
            this.missingImportsListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void fireMissingImportEvent(MissingImportEvent evt) {
        this.writeLock.lock();
        try {
            new ArrayList<MissingImportListener>(this.missingImportsListeners).forEach(l -> l.importMissing(evt));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.writeLock.lock();
        try {
            this.loaderListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.writeLock.lock();
        try {
            this.loaderListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStartedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported) {
        this.writeLock.lock();
        try {
            for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
                listener.startedLoadingOntology(new OWLOntologyLoaderListener.LoadingStartedEvent(ontologyID, documentIRI, imported));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFinishedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported, @Nullable Exception ex) {
        this.writeLock.lock();
        try {
            for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
                listener.finishedLoadingOntology(new OWLOntologyLoaderListener.LoadingFinishedEvent(ontologyID, documentIRI, imported, ex));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.writeLock.lock();
        try {
            this.progressListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.writeLock.lock();
        try {
            this.progressListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginChanges(int size) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.begin(size);
                }
                catch (Exception e) {
                    LOGGER.warn(BADLISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndChanges() {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.end();
                }
                catch (Exception e) {
                    LOGGER.warn(BADLISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeApplied(OWLOntologyChange change) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            if (this.progressListeners.isEmpty()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.appliedChange(change);
                }
                catch (Exception e) {
                    LOGGER.warn(BADLISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

