/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImpl;

public class OWLHasKeyAxiomImpl
extends OWLLogicalAxiomImpl
implements OWLHasKeyAxiom {
    private final OWLClassExpression expression;
    private final List<OWLPropertyExpression> propertyExpressions;

    public OWLHasKeyAxiomImpl(OWLClassExpression expression, Collection<? extends OWLPropertyExpression> propertyExpressions, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.expression = (OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)expression, (String)"expression cannot be null");
        OWLAPIPreconditions.checkNotNull(propertyExpressions, (String)"propertyExpressions cannot be null");
        this.propertyExpressions = OWLAPIStreamUtils.sorted(OWLPropertyExpression.class, propertyExpressions);
    }

    public OWLHasKeyAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLHasKeyAxiomImpl(this.getClassExpression(), this.propertyExpressions, NO_ANNOTATIONS);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLHasKeyAxiomImpl(this.getClassExpression(), this.propertyExpressions, this.mergeAnnos(anns));
    }

    public OWLClassExpression getClassExpression() {
        return this.expression;
    }

    public Stream<OWLPropertyExpression> propertyExpressions() {
        return OWLAPIStreamUtils.streamFromSorted(this.propertyExpressions);
    }

    public Stream<OWLPropertyExpression> operands() {
        return this.propertyExpressions();
    }

    public List<OWLPropertyExpression> getOperandsAsList() {
        return this.propertyExpressions;
    }
}

