/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collections;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImplNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends OWLDataFactoryInternalsImplNoCache {
    private static final LoadingCache<IRI, OWLAnnotationProperty> annotationProperties = OWLDataFactoryInternalsImpl.builder(OWLAnnotationPropertyImpl::new);
    private static final LoadingCache<OWLAnnotation, OWLAnnotation> annotations = OWLDataFactoryInternalsImpl.builder(OWLDataFactoryInternalsImpl::ann);
    private static final LoadingCache<IRI, OWLClass> classes = OWLDataFactoryInternalsImpl.builder(OWLClassImpl::new);
    private static final LoadingCache<IRI, OWLObjectProperty> objectProperties = OWLDataFactoryInternalsImpl.builder(OWLObjectPropertyImpl::new);
    private static final LoadingCache<IRI, OWLDataProperty> dataProperties = OWLDataFactoryInternalsImpl.builder(OWLDataPropertyImpl::new);
    private static final LoadingCache<IRI, OWLDatatype> datatypes = OWLDataFactoryInternalsImpl.builder(OWLDatatypeImpl::new);
    private static final LoadingCache<IRI, OWLNamedIndividual> individuals = OWLDataFactoryInternalsImpl.builder(OWLNamedIndividualImpl::new);

    public OWLDataFactoryInternalsImpl(boolean useCompression) {
        super(useCompression);
    }

    private static OWLAnnotation ann(OWLAnnotation o) {
        return o;
    }

    private static <F, T> LoadingCache<F, T> builder(CacheLoader<F, T> f) {
        return Caffeine.newBuilder().weakKeys().maximumSize(OWLDataFactoryInternalsImpl.size()).build(f);
    }

    protected static long size() {
        return ((Integer)ConfigurationOptions.CACHE_SIZE.getValue(Integer.class, Collections.emptyMap())).longValue();
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return (OWLClass)classes.get((Object)iri);
    }

    @Override
    public void purge() {
        classes.invalidateAll();
        objectProperties.invalidateAll();
        dataProperties.invalidateAll();
        datatypes.invalidateAll();
        individuals.invalidateAll();
        annotationProperties.invalidateAll();
        annotations.invalidateAll();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return (OWLObjectProperty)objectProperties.get((Object)iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return (OWLDataProperty)dataProperties.get((Object)iri);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return (OWLNamedIndividual)individuals.get((Object)iri);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return (OWLDatatype)datatypes.get((Object)iri);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return (OWLAnnotationProperty)annotationProperties.get((Object)iri);
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> anns) {
        return (OWLAnnotation)annotations.get((Object)new OWLAnnotationImpl(property, value, anns));
    }
}

