/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.proof;

import com.ontotext.trree.AbstractInferencer;
import com.ontotext.trree.AbstractRepositoryConnection;
import com.ontotext.trree.ReportSupportedSolution;
import com.ontotext.trree.StatementIdIterator;
import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.query.QueryResultIterator;
import com.ontotext.trree.query.StatementSource;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.ListPatternInterpreter;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.RequestOptions;
import com.ontotext.trree.sdk.StatelessPlugin;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.SystemPlugin;
import com.ontotext.trree.sdk.SystemPluginOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofPlugin
extends PluginBase
implements StatelessPlugin,
SystemPlugin,
Preprocessor,
PatternInterpreter,
ListPatternInterpreter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String REPOSITORY_CONNECTION = "repconn";
    private static final String INFERENCER = "infer";
    public static final String NAMESPACE = "http://www.ontotext.com/proof/";
    public static final IRI EXPLAIN_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/proof/explain");
    public static final IRI RULE_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/proof/rule");
    public static final IRI SUBJ_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/proof/subject");
    public static final IRI PRED_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/proof/predicate");
    public static final IRI OBJ_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/proof/object");
    public static final IRI CONTEXT_URI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/proof/context");
    private static final String KEY_STORAGE = "storage";
    int contextMask = 41;
    long explainId = 0L;
    long ruleId = 0L;
    long subjId = 0L;
    long predId = 0L;
    long objId = 0L;
    long contextId = 0L;

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        ContextImpl ctx;
        if (predicate != this.explainId && predicate != this.ruleId && predicate != this.contextId && predicate != this.subjId && predicate != this.predId && predicate != this.objId) {
            return null;
        }
        ContextImpl contextImpl = ctx = requestContext instanceof ContextImpl ? (ContextImpl)requestContext : null;
        if (ctx == null) {
            return StatementIterator.EMPTY;
        }
        if (predicate == this.ruleId) {
            ExplainIter task = (ExplainIter)((Object)ctx.getAttribute(KEY_STORAGE + subject));
            if (task == null || task.current == null) {
                return StatementIterator.EMPTY;
            }
            return StatementIterator.create((long)task.reificationId, (long)predicate, (long)pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createLiteral(task.current.rule), Entities.Scope.REQUEST), (long)0L);
        }
        if (predicate == this.subjId) {
            ExplainIter task = (ExplainIter)((Object)ctx.getAttribute(KEY_STORAGE + subject));
            if (task == null || task.current == null) {
                return StatementIterator.EMPTY;
            }
            if (object != 0L && task.values[0] != object) {
                return StatementIterator.EMPTY;
            }
            return StatementIterator.create((long)task.reificationId, (long)predicate, (long)task.values[0], (long)0L);
        }
        if (predicate == this.predId) {
            ExplainIter task = (ExplainIter)((Object)ctx.getAttribute(KEY_STORAGE + subject));
            if (task == null || task.current == null) {
                return StatementIterator.EMPTY;
            }
            if (object != 0L && task.values[1] != object) {
                return StatementIterator.EMPTY;
            }
            return StatementIterator.create((long)task.reificationId, (long)predicate, (long)task.values[1], (long)0L);
        }
        if (predicate == this.objId) {
            ExplainIter task = (ExplainIter)((Object)ctx.getAttribute(KEY_STORAGE + subject));
            if (task == null || task.current == null) {
                return StatementIterator.EMPTY;
            }
            if (object != 0L && task.values[2] != object) {
                return StatementIterator.EMPTY;
            }
            return StatementIterator.create((long)task.reificationId, (long)predicate, (long)task.values[2], (long)0L);
        }
        if (predicate == this.contextId) {
            ExplainIter task = (ExplainIter)((Object)ctx.getAttribute(KEY_STORAGE + subject));
            if (task == null || task.current == null) {
                return StatementIterator.EMPTY;
            }
            if (object != 0L && task.values[3] != object) {
                return StatementIterator.EMPTY;
            }
            return StatementIterator.create((long)task.reificationId, (long)predicate, (long)task.values[3], (long)0L);
        }
        return null;
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (subject == 0L) {
            return Double.MAX_VALUE;
        }
        if (predicate == this.ruleId || predicate == this.subjId || predicate == this.predId || predicate == this.objId || predicate == this.contextId) {
            return 1.0;
        }
        return Double.MAX_VALUE;
    }

    public String getName() {
        return "proof";
    }

    public RequestContext preprocess(Request request) {
        RequestOptions ops;
        ContextImpl impl = new ContextImpl();
        impl.setRequest(request);
        if (request != null && (ops = request.getOptions()) != null && ops instanceof SystemPluginOptions) {
            Object obj = ((SystemPluginOptions)ops).getOption(SystemPluginOptions.Option.ACCESS_INFERENCER);
            if (obj instanceof AbstractInferencer) {
                impl.setAttribute(INFERENCER, obj);
            }
            if ((obj = ((SystemPluginOptions)ops).getOption(SystemPluginOptions.Option.ACCESS_REPOSITORY_CONNECTION)) instanceof AbstractRepositoryConnection) {
                impl.setAttribute(REPOSITORY_CONNECTION, obj);
            }
        }
        return impl;
    }

    public void initialize(InitReason initReason, PluginConnection pluginConnection) {
        this.explainId = pluginConnection.getEntities().put((Value)EXPLAIN_URI, Entities.Scope.SYSTEM);
        this.ruleId = pluginConnection.getEntities().put((Value)RULE_URI, Entities.Scope.SYSTEM);
        this.subjId = pluginConnection.getEntities().put((Value)SUBJ_URI, Entities.Scope.SYSTEM);
        this.predId = pluginConnection.getEntities().put((Value)PRED_URI, Entities.Scope.SYSTEM);
        this.objId = pluginConnection.getEntities().put((Value)OBJ_URI, Entities.Scope.SYSTEM);
        this.contextId = pluginConnection.getEntities().put((Value)CONTEXT_URI, Entities.Scope.SYSTEM);
    }

    public double estimate(long subject, long predicate, long[] objects, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.explainId) {
            if (objects.length != 3) {
                return Double.MAX_VALUE;
            }
            if (objects[0] == 0L || objects[1] == 0L || objects[2] == 0L) {
                return Double.MAX_VALUE;
            }
            return 10.0;
        }
        return Double.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementIterator interpret(long subject, long predicate, long[] objects, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        ContextImpl ctx;
        ContextImpl contextImpl = ctx = requestContext instanceof ContextImpl ? (ContextImpl)requestContext : null;
        if (ctx == null) {
            return StatementIterator.EMPTY;
        }
        if (predicate == this.explainId) {
            if (objects == null || objects.length != 3) {
                return StatementIterator.EMPTY;
            }
            long subj = objects[0];
            long pred = objects[1];
            long obj = objects[2];
            if (subj <= 0L || obj <= 0L || pred <= 0L) {
                return StatementIterator.EMPTY;
            }
            long aContext = 0L;
            AbstractInferencer infer = (AbstractInferencer)ctx.getAttribute(INFERENCER);
            if (!infer.getInferStatementsFlag()) {
                return StatementIterator.EMPTY;
            }
            AbstractRepositoryConnection conn = (AbstractRepositoryConnection)ctx.getAttribute(REPOSITORY_CONNECTION);
            boolean isExplicit = false;
            boolean isDerivedFromSameAs = false;
            try (StatementIdIterator iter = conn.getStatements(subj, pred, obj, 41);){
                isExplicit = iter.hasNext();
                aContext = iter.context;
                isDerivedFromSameAs = 0 != (iter.status & 0x10);
            }
            long reificationId = pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createBNode(), Entities.Scope.REQUEST);
            ExplainIter ret = new ExplainIter(ctx, reificationId, subj, pred, obj, isExplicit, isDerivedFromSameAs, aContext);
            ret.infer = infer;
            ret.conn = conn;
            ret.init();
            ctx.setAttribute(KEY_STORAGE + reificationId, (Object)ret);
            return ret;
        }
        return null;
    }

    class ExplainIter
    extends StatementIterator
    implements ReportSupportedSolution {
        ContextImpl ctx;
        String key;
        long reificationId;
        AbstractInferencer infer;
        AbstractRepositoryConnection conn;
        long subj;
        long pred;
        long obj;
        boolean isExplicit = false;
        boolean isDerivedFromSameAs = false;
        long aContext = 0L;
        ArrayList<Solution> solutions = new ArrayList();
        Iterator<Solution> iter;
        Solution current = null;
        int currentNo = -1;
        long[] values = null;

        public ExplainIter(ContextImpl ctx2, long reificationId2, long subj, long pred, long obj, boolean isExplicit, boolean isDerivedFromSameAs, long aContext) {
            this.ctx = ctx2;
            this.reificationId = reificationId2;
            this.subj = subj;
            this.pred = pred;
            this.obj = obj;
            this.isExplicit = isExplicit;
            this.isDerivedFromSameAs = isDerivedFromSameAs;
            this.aContext = aContext;
            this.subject = this.reificationId;
            this.predicate = ProofPlugin.this.explainId;
        }

        public void init() {
            if (!this.isExplicit) {
                this.infer.isSupported(this.subj, this.pred, this.obj, 0L, 0, (ReportSupportedSolution)this);
                this.iter = this.solutions.iterator();
                if (this.iter.hasNext()) {
                    this.current = this.iter.next();
                }
                if (this.current != null) {
                    this.currentNo = 0;
                }
            } else {
                ArrayList<long[]> arr = new ArrayList<long[]>();
                arr.add(new long[]{this.subj, this.pred, this.obj, this.aContext});
                this.current = new Solution("explicit", arr);
                this.currentNo = 0;
                this.iter = new Iterator<Solution>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public Solution next() {
                        return null;
                    }
                };
            }
        }

        public boolean report(String ruleName, QueryResultIterator q) {
            ProofPlugin.this.logger.debug("report rule {} for {},{},{}", new Object[]{ruleName, this.subj, this.pred, this.obj});
            while (q.hasNext()) {
                if (q instanceof StatementSource) {
                    StatementSource source = (StatementSource)q;
                    Iterator sol = source.solution();
                    boolean isSame = false;
                    ArrayList<long[]> aSolution = new ArrayList<long[]>();
                    while (sol.hasNext()) {
                        StatementIdIterator iter = (StatementIdIterator)sol.next();
                        try (StatementIdIterator ctxIter = this.conn.getStatements(iter.subj, iter.pred, iter.obj, 0L, ProofPlugin.this.contextMask);){
                            while (ctxIter.hasNext()) {
                                if (ctxIter.context != (long)SystemGraphs.EXPLICIT_GRAPH.getId()) {
                                    iter.context = ctxIter.context;
                                    iter.status = ctxIter.status;
                                    break;
                                }
                                ctxIter.next();
                            }
                            ctxIter.close();
                        }
                        if (iter.subj == this.subj && iter.pred == this.pred && iter.obj == this.obj) {
                            isSame = true;
                        }
                        aSolution.add(new long[]{iter.subj, iter.pred, iter.obj, iter.context, iter.status});
                    }
                    Solution solution = new Solution(ruleName, aSolution);
                    ProofPlugin.this.logger.debug("isSelfReferentioal {} for solution {}", (Object)isSame, (Object)solution);
                    if (!isSame) {
                        if (!this.solutions.contains(solution)) {
                            ProofPlugin.this.logger.debug("added");
                            this.solutions.add(solution);
                        } else {
                            ProofPlugin.this.logger.debug("already added");
                        }
                    } else {
                        ProofPlugin.this.logger.debug("not added - self referential");
                    }
                }
                q.next();
            }
            return false;
        }

        public void close() {
            this.current = null;
            this.solutions = null;
        }

        public boolean next() {
            while (this.current != null) {
                if (this.currentNo < this.current.premises.size()) {
                    this.values = this.current.premises.get(this.currentNo);
                    ++this.currentNo;
                    return true;
                }
                this.values = null;
                this.currentNo = 0;
                if (this.iter.hasNext()) {
                    this.current = this.iter.next();
                    continue;
                }
                this.current = null;
            }
            return false;
        }

        public AbstractRepositoryConnection getConnection() {
            return this.conn;
        }

        class Solution {
            String rule;
            ArrayList<long[]> premises;

            Solution(String rule, ArrayList<long[]> premises) {
                this.rule = rule;
                this.premises = premises;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("rule:").append(this.rule).append("\n");
                for (long[] p : this.premises) {
                    builder.append(p[0]).append(",").append(p[1]).append(",");
                    builder.append(p[2]).append(",").append(p[3]).append("\n");
                }
                return builder.toString();
            }

            public boolean equals(Object oObj) {
                if (!(oObj instanceof Solution)) {
                    return false;
                }
                Solution other = (Solution)oObj;
                if (other == this) {
                    return true;
                }
                if (!other.rule.equals(this.rule)) {
                    return false;
                }
                if (other.premises.size() != this.premises.size()) {
                    return false;
                }
                for (long[] p : this.premises) {
                    boolean exists = false;
                    for (long[] o : other.premises) {
                        if (o[0] != p[0] || o[1] != p[1] || o[2] != p[2] || o[3] != p[3] || o[4] != p[4]) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    return false;
                }
                return true;
            }
        }
    }

    class ContextImpl
    implements RequestContext {
        HashMap<String, Object> map = new HashMap();
        Request request;

        ContextImpl() {
        }

        public Request getRequest() {
            return this.request;
        }

        public void setRequest(Request request) {
            this.request = request;
        }

        public Object getAttribute(String key) {
            return this.map.get(key);
        }

        public void setAttribute(String key, Object value) {
            this.map.put(key, value);
        }

        public void removeAttribute(String key) {
            this.map.remove(key);
        }
    }
}

