/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.schema.preprocess;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.extensions.SchemaExtension;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Order(value=1000)
public class SetDefaultExpressions
implements SchemaExtension {
    public void process(SomlSchema somlSchema) {
        Pattern prefixPattern = SetDefaultExpressions.createPrefixPattern(somlSchema);
        for (Shape shape : somlSchema.getObjects().values()) {
            SetDefaultExpressions.processShape(shape, prefixPattern);
        }
    }

    private static Pattern createPrefixPattern(SomlSchema somlSchema) {
        String prefixes = somlSchema.getPrefixes().keySet().stream().collect(Collectors.joining("|", "\\$\\{(", "):"));
        return Pattern.compile(prefixes);
    }

    private static void processShape(Shape shape, Pattern prefixPattern) {
        if (shape.isUnion()) {
            return;
        }
        SetDefaultExpressions.setDefaultExpressions(() -> ((Shape)shape).getPattern(), arg_0 -> ((Shape)shape).setPattern(arg_0), shape.getPrefix());
        for (PropertyShape property : shape.getProps().values()) {
            if (StringUtils.isBlank((CharSequence)property.getGen())) continue;
            property.setGen(prefixPattern.matcher(property.getGen()).replaceAll("\\${$1_"));
            SetDefaultExpressions.setDefaultExpressions(() -> ((PropertyShape)property).getGen(), arg_0 -> ((PropertyShape)property).setGen(arg_0), null);
        }
    }

    private static void setDefaultExpressions(Supplier<String> value, Consumer<String> setter, String prefix) {
        String pattern = value.get();
        if ("uuid".equals(pattern)) {
            setter.accept(StringUtils.trimToEmpty((String)prefix) + "${uuid()}");
        } else if ("autoinc".equals(pattern)) {
            setter.accept(StringUtils.trimToEmpty((String)prefix) + "${autoinc()}");
        }
    }
}

