/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.schema.preprocess;

import com.ontotext.models.EnumValueDef;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.text.RandomStringGenerator;

public class DataGenerator {
    private static final String RANDOM_STR_SUFFIX = "rss";
    private static final int UNSIGNED_BYTE_MAX_VALUE = 255;
    private static final int UNSIGNED_SHORT_MAX_VALUE = 65535;
    private final Map<String, Supplier<Object>> dataGenerators = new HashMap<String, Supplier<Object>>();

    public DataGenerator() {
        this.createDataGenerators();
    }

    private void createDataGenerators() {
        SecureRandom secureRandom = new SecureRandom();
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        RandomStringGenerator stringGenerator = new RandomStringGenerator.Builder().withinRange(32, 126).build();
        this.dataGenerators.put("ID", DataGenerator::generateIri);
        this.dataGenerators.put("String", () -> stringGenerator.generate(secureRandom.nextInt(129) + 1) + RANDOM_STR_SUFFIX);
        this.dataGenerators.put("Literal", () -> {
            HashMap<String, Object> literal = new HashMap<String, Object>(4);
            literal.put("value", stringGenerator.generate(secureRandom.nextInt(129) + 1) + RANDOM_STR_SUFFIX);
            literal.put("lang", "en");
            return literal;
        });
        this.dataGenerators.put("Date", () -> DataGenerator.generateLocalDate(secureRandom));
        this.dataGenerators.put("DateTime", () -> DataGenerator.generateLocalDateTime(secureRandom));
        this.dataGenerators.put("Time", () -> DataGenerator.generateLocalTime(secureRandom));
        this.dataGenerators.put("Year", () -> DataGenerator.generateYear(secureRandom));
        this.dataGenerators.put("YearMonth", () -> DataGenerator.generateYearMonth(secureRandom));
        this.dataGenerators.put("Byte", () -> secureRandom.nextInt(127));
        this.dataGenerators.put("Short", () -> secureRandom.nextInt(Short.MAX_VALUE));
        this.dataGenerators.put("Int", secureRandom::nextInt);
        this.dataGenerators.put("Long", secureRandom::nextLong);
        this.dataGenerators.put("Integer", () -> DataGenerator.generateBigInteger(secureRandom));
        this.dataGenerators.put("UnsignedByte", () -> secureRandom.nextInt(255));
        this.dataGenerators.put("UnsignedShort", () -> secureRandom.nextInt(65535));
        this.dataGenerators.put("UnsignedLong", secureRandom::nextLong);
        this.dataGenerators.put("UnsignedInteger", secureRandom::nextLong);
        this.dataGenerators.put("PositiveInteger", () -> DataGenerator.generateBigInteger(secureRandom));
        this.dataGenerators.put("NonPositiveInteger", () -> DataGenerator.generateBigInteger(secureRandom).negate());
        this.dataGenerators.put("NegativeInteger", () -> DataGenerator.generateBigInteger(secureRandom).negate());
        this.dataGenerators.put("NonNegativeInteger", () -> DataGenerator.generateBigInteger(secureRandom));
        this.dataGenerators.put("Float", secureRandom::nextDouble);
        this.dataGenerators.put("Decimal", () -> BigDecimal.valueOf(secureRandom.nextDouble()));
        this.dataGenerators.put("PositiveFloat", secureRandom::nextDouble);
        this.dataGenerators.put("NonPositiveFloat", () -> -secureRandom.nextDouble());
        this.dataGenerators.put("NegativeFloat", () -> -secureRandom.nextDouble());
        this.dataGenerators.put("NonNegativeFloat", secureRandom::nextDouble);
        this.dataGenerators.put("Duration", () -> "P" + secureRandom.nextInt() + "Y");
        this.dataGenerators.put("DayTimeDuration", () -> "P" + secureRandom.nextInt() + "D");
        this.dataGenerators.put("YearMonthDuration", () -> "P" + secureRandom.nextInt() + "Y");
        this.dataGenerators.put("Boolean", () -> atomicBoolean.getAndSet(!atomicBoolean.get()));
    }

    public Map<String, Object> generateDataFor(Shape shape) {
        HashMap<String, Object> dummyData = new HashMap<String, Object>();
        for (PropertyShape propertyShape : shape.getAllProperties().values()) {
            if (propertyShape.isMultivalued()) continue;
            dummyData.computeIfAbsent(propertyShape.getName(), k -> this.generateData(propertyShape));
        }
        return dummyData;
    }

    public Object generateData(PropertyShape propertyShape) {
        if (propertyShape.isScalarType()) {
            if (propertyShape.getScalarType().isEnum()) {
                return ((EnumValueDef)propertyShape.getScalarType().getValues().get(0)).getName();
            }
            String graphqlType = propertyShape.getScalarType().getGraphql();
            Supplier<Object> dataProvider = this.dataGenerators.get(graphqlType);
            if (dataProvider != null) {
                return dataProvider.get();
            }
            throw new IllegalArgumentException("Unsupported type: " + graphqlType);
        }
        return this.dataGenerators.get("ID").get();
    }

    private static BigInteger generateBigInteger(SecureRandom secureRandom) {
        return BigInteger.valueOf(secureRandom.nextLong());
    }

    private static Year generateYear(SecureRandom secureRandom) {
        return Year.of(secureRandom.nextInt(5000));
    }

    private static YearMonth generateYearMonth(SecureRandom secureRandom) {
        return YearMonth.of(secureRandom.nextInt(5000), DataGenerator.getMonth(secureRandom));
    }

    private static LocalDate generateLocalDate(SecureRandom secureRandom) {
        return LocalDate.ofYearDay(secureRandom.nextInt(5000), secureRandom.nextInt(365) + 1);
    }

    private static Object generateLocalDateTime(SecureRandom secureRandom) {
        return LocalDateTime.of(secureRandom.nextInt(5000), DataGenerator.getMonth(secureRandom), DataGenerator.getDayOfMonth(secureRandom), secureRandom.nextInt(24), secureRandom.nextInt(60), secureRandom.nextInt(60), secureRandom.nextInt(999999));
    }

    private static int getMonth(SecureRandom secureRandom) {
        return secureRandom.nextInt(12) + 1;
    }

    private static int getDayOfMonth(SecureRandom secureRandom) {
        return secureRandom.nextInt(28) + 1;
    }

    private static LocalTime generateLocalTime(SecureRandom secureRandom) {
        return LocalTime.of(secureRandom.nextInt(24), secureRandom.nextInt(60), secureRandom.nextInt(60), secureRandom.nextInt(999999));
    }

    private static Object generateIri() {
        return "http://example.org/resource/" + UUID.randomUUID().toString();
    }
}

