/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.ontotext.script.model.JsValue;
import com.ontotext.script.model.ValueResolver;
import java.util.function.BiFunction;
import java.util.function.Function;

public class JsStringValue
extends JsValue<String> {
    private Function<String, String> transformation = Function.identity();

    JsStringValue(String name, String value) {
        super(name, value);
    }

    JsStringValue(String name, ValueResolver<String> valueResolver) {
        super(name, valueResolver);
    }

    public JsStringValue lowerCase() {
        this.transformation = String::toLowerCase;
        return this;
    }

    public JsStringValue upperCase() {
        this.transformation = String::toUpperCase;
        return this;
    }

    @Override
    public String asString() {
        String value = super.asString();
        if ("null".equals(value)) {
            return value;
        }
        return this.transformation.apply(value);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    protected BiFunction<String, String, JsValue> copyFactory() {
        return JsStringValue::new;
    }
}

