/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script.model;

import com.ontotext.models.SpecialPrefixes;
import com.ontotext.script.engine.ScriptEngine;
import com.ontotext.script.model.JsValue;
import com.ontotext.script.model.ScriptEngineListener;
import com.ontotext.script.model.ValueResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class JsIriValue
extends JsValue<String>
implements ScriptEngineListener {
    private ScriptEngine jsEngine;
    private boolean compact;
    private boolean relativeToBase = false;
    private String compactValue;

    JsIriValue(String name, String value) {
        super(name, value);
    }

    JsIriValue(String name, ValueResolver<String> valueResolver) {
        super(name, valueResolver);
    }

    @Override
    protected BiFunction<String, String, JsValue> copyFactory() {
        return JsIriValue::new;
    }

    public JsIriValue compact() {
        this.compact = true;
        return this;
    }

    @Override
    public boolean isIri() {
        return true;
    }

    @Override
    public String asString() {
        if (this.compact) {
            if (this.compactValue == null) {
                this.compactValue = this.resolveCompactValue();
            }
            return Objects.toString(this.compactValue);
        }
        return super.asString();
    }

    private String resolveCompactValue() {
        String iri = (String)this.get();
        if (iri == null) {
            return null;
        }
        Map<String, String> prefixes = this.getPrefixesFromScriptEnvironment();
        if (prefixes == null) {
            return iri;
        }
        HashMap<String, String> prefixCopy = new HashMap<String, String>(prefixes);
        prefixCopy.keySet().removeAll(SpecialPrefixes.ALL);
        for (Map.Entry entry : prefixCopy.entrySet()) {
            if (!iri.startsWith((String)entry.getValue())) continue;
            return (String)entry.getKey() + ":" + iri.replace((CharSequence)entry.getValue(), "");
        }
        String baseIri = prefixes.get("base_iri");
        if (baseIri != null && iri.startsWith(baseIri)) {
            this.relativeToBase = true;
            return iri.replace(baseIri, "");
        }
        return iri;
    }

    private Map<String, String> getPrefixesFromScriptEnvironment() {
        if (this.jsEngine == null) {
            return null;
        }
        return this.jsEngine.getPrefixes();
    }

    @Override
    protected String doEscape(String val, String escapeChar) {
        if (this.compact && this.relativeToBase) {
            return val;
        }
        return super.doEscape(val, escapeChar);
    }

    @Override
    public void onEngineSet(ScriptEngine jsEngine) {
        this.jsEngine = jsEngine;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsIriValue)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        JsIriValue that = (JsIriValue)obj;
        return this.compact == that.compact;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.compact);
    }
}

