/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.script;

import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.script.engine.JsValueGenerator;
import com.ontotext.script.model.JsValue;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.plugin.PluginsManager;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueGenerator
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ID = "id";
    private JsValueGenerator scriptEvaluator;

    public void generateValues(Mutation mutation) {
        SomlSchema schema = mutation.getReturnTypeInstance().getContainedIn().getContainedIn();
        for (Change change : mutation.getChanges()) {
            if (change.getType() != OperationType.CREATE) continue;
            LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
            bindings.put("_prefix", ValueGenerator.createPrefixMapping(schema));
            List<JsValue> computedValues = ValueGenerator.collectComputedValues(change, bindings);
            this.getScriptEvaluator().generateValues(computedValues, bindings);
            computedValues.forEach(jsValue -> ValueGenerator.readComputedValue(change, jsValue));
        }
    }

    private synchronized JsValueGenerator getScriptEvaluator() {
        if (this.scriptEvaluator == null) {
            this.scriptEvaluator = (JsValueGenerator)PluginsManager.loader(JsValueGenerator.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).loadFirst();
        }
        return this.scriptEvaluator;
    }

    public Object genIri(String pattern, Map<String, Object> values, Shape shape) {
        return this.evalExpression("_iri", pattern, values, shape);
    }

    public Object genValue(String genPattern, Map<String, Object> values, Shape shape) {
        return this.evalExpression("genValue", genPattern, values, shape);
    }

    public Object evalExpression(String template, String expression, Map<String, Object> values, Shape shape) {
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        values.forEach((key, value) -> {
            String name = ValueGenerator.escapeName(key);
            String type = shape.getProperty(key).map(ValueGenerator::getType).orElse(null);
            bindings.put(name, JsValue.ofValue(name, type, value));
        });
        SomlSchema schema = shape.getContainedIn().getContainedIn();
        bindings.put("_prefix", ValueGenerator.createPrefixMapping(schema));
        return this.getScriptEvaluator().evalTemplate(template, expression, bindings);
    }

    private static Map<String, Object> createPrefixMapping(SomlSchema schema) {
        HashMap<String, Object> prefixMapping = new HashMap<String, Object>((Map<String, Object>)schema.getPrefixes());
        prefixMapping.putAll((Map<String, Object>)schema.getSpecialPrefixes());
        return prefixMapping;
    }

    private static List<JsValue> collectComputedValues(Change change, Map<String, Object> bindings) {
        Shape typeInstance = change.getShape();
        Map<String, Object> changeMap = change.getChanges().stream().filter(PropertyChange::hasValue).collect(Collectors.toMap(PropertyChange::getName, PropertyChange::getValue, ValueGenerator.resolveDuplicateValues(change)));
        LinkedList<JsValue> computedValues = new LinkedList<JsValue>();
        for (PropertyShape propertyShape : typeInstance.getAllProperties().values()) {
            JsValue jsValue;
            String name = ValueGenerator.getName(propertyShape);
            String type = ValueGenerator.getType(propertyShape);
            if (changeMap.containsKey(name)) {
                jsValue = JsValue.ofValue(name, type, changeMap.get(name));
                if (propertyShape.getName().equals(typeInstance.getName())) {
                    bindings.put("name", JsValue.ofValue("name", type, changeMap.get(name)));
                }
            } else if (StringUtils.isNotBlank((CharSequence)propertyShape.getGen())) {
                jsValue = JsValue.ofExpression(name, type, propertyShape.getGen());
                computedValues.add(jsValue);
            } else {
                jsValue = JsValue.ofType(name, type);
            }
            bindings.put(name, jsValue);
        }
        if (ReferenceId.isReferenceId((String)change.getId()) && !ReferenceId.isTemporaryId((String)change.getId())) {
            String pattern = typeInstance.getPattern();
            bindings.computeIfPresent(ID, (key, value) -> ValueGenerator.registerIdExpression(computedValues, pattern, (JsValue)value));
        }
        return computedValues;
    }

    private static BinaryOperator<Object> resolveDuplicateValues(Change change) {
        return (previous, current) -> {
            LOGGER.warn("Duplicate property change for id={}, previous='{}', current='{}'", new Object[]{change.getId(), previous, current});
            return current;
        };
    }

    private static Object registerIdExpression(List<JsValue> computedValues, String pattern, JsValue currentValue) {
        if (!currentValue.isLazy() && currentValue.isEmpty()) {
            JsValue jsValue = JsValue.ofExpression(ID, "ID", pattern);
            if (computedValues.stream().noneMatch(value -> ID.equals(value.getName()))) {
                computedValues.add(0, jsValue);
            }
            return jsValue;
        }
        return currentValue;
    }

    private static void readComputedValue(Change change, JsValue jsValue) {
        String name = jsValue.getName();
        Object value = jsValue.get();
        if (value == null) {
            return;
        }
        if (ID.equals(name)) {
            change.setId(value.toString());
        } else {
            List<SourceLocation> location = Collections.singletonList(change.getSourceLocation());
            change.addPropertyValue(name, value, location);
        }
    }

    private static String getType(PropertyShape propertyShape) {
        if (propertyShape.isScalarType()) {
            return propertyShape.getScalarType().getGraphql();
        }
        return "ID";
    }

    private static String getName(PropertyShape propertyShape) {
        return ValueGenerator.escapeName(propertyShape.getName());
    }

    private static String escapeName(String name) {
        return StringManipulation.replaceColonWithUnderscore((String)name);
    }

    @Override
    public void close() {
        if (this.scriptEvaluator != null) {
            this.scriptEvaluator.close();
        }
    }
}

