/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.ontotext.graphdb.jdbc.GraphDBEnumerator;
import com.ontotext.graphdb.jdbc.GraphDBFieldType;
import com.ontotext.graphdb.jdbc.GraphDBTableMetadata;
import com.ontotext.graphdb.jdbc.GraphDBTableStatistic;
import com.ontotext.graphdb.jdbc.filter.GraphDBFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Source;
import org.eclipse.rdf4j.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphDBTable
extends AbstractTable
implements FilterableTable {
    protected static final Logger LOG = LoggerFactory.getLogger(GraphDBTable.class);
    protected final Source source;
    protected final RelProtoDataType protoRowType;
    protected final GraphDBTableStatistic statistic;
    protected final Repository repository;
    protected final GraphDBTableMetadata metadata;
    private RelDataType rowType;
    private List<GraphDBFieldType> fieldTypes;

    GraphDBTable(Source source, RelProtoDataType protoRowType, Repository repository) throws Exception {
        Objects.requireNonNull(repository, "Repository must be specified");
        this.source = source;
        this.protoRowType = protoRowType;
        this.repository = repository;
        this.metadata = new GraphDBTableMetadata(repository, source);
        this.statistic = new GraphDBTableStatistic(this.metadata);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        if (this.rowType == null) {
            this.rowType = this.metadata.getRowType((JavaTypeFactory)typeFactory, null);
        }
        return this.rowType;
    }

    protected List<GraphDBFieldType> getFieldTypes(RelDataTypeFactory typeFactory) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new ArrayList<GraphDBFieldType>();
            this.metadata.getRowType((JavaTypeFactory)typeFactory, this.fieldTypes);
        }
        return this.fieldTypes;
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters) {
        final List<GraphDBFieldType> fieldTypes = this.getFieldTypes((RelDataTypeFactory)root.getTypeFactory());
        final ArrayList filterValues = new ArrayList();
        filters.removeIf(filter -> this.metadata.addFilter((RexNode)filter, filterValues));
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new GraphDBEnumerator(GraphDBTable.this.metadata, cancelFlag, fieldTypes, GraphDBFilter.convertToSparql(filterValues));
            }
        };
    }

    GraphDBTableMetadata getMetadata() {
        return this.metadata;
    }

    public static enum Flavor {
        READABLE,
        WRITABLE;

    }
}

