/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.ontotext.graphdb.jdbc.GraphDBFieldType;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;

class GraphDBRowConverter {
    private final GraphDBFieldType[] fieldTypes;
    private final int[] fields;

    GraphDBRowConverter(List<GraphDBFieldType> fieldTypes, int[] fields) {
        this.fieldTypes = fieldTypes.toArray(new GraphDBFieldType[0]);
        this.fields = fields;
    }

    public Object[] convertRow(Value[] values) {
        Object[] objects = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int field = this.fields[i];
            objects[i] = this.convert(this.fieldTypes[field], values[field]);
        }
        return objects;
    }

    protected Object convert(GraphDBFieldType fieldType, Value value) {
        if (value == null) {
            return null;
        }
        if (fieldType == null) {
            return value.stringValue();
        }
        switch (fieldType) {
            case BOOLEAN: {
                return this.castLiteral(value, Literal::booleanValue);
            }
            case BYTE: {
                return this.castLiteral(value, Literal::byteValue);
            }
            case SHORT: {
                return this.castLiteral(value, Literal::shortValue);
            }
            case INT: {
                return this.castLiteral(value, Literal::intValue);
            }
            case LONG: {
                return this.castLiteral(value, Literal::longValue);
            }
            case FLOAT: {
                return this.castLiteral(value, Literal::floatValue);
            }
            case DOUBLE: {
                return this.castLiteral(value, Literal::doubleValue);
            }
            case DECIMAL: {
                return this.castLiteral(value, Literal::decimalValue);
            }
            case DATE: {
                return this.castLiteral(value, v -> (int)(this.milliseconds((Literal)v, true) / 86400000L));
            }
            case TIME: {
                return this.castLiteral(value, v -> (int)this.milliseconds((Literal)v, true));
            }
            case TIMESTAMP: {
                return this.castLiteral(value, v -> this.milliseconds((Literal)v, false));
            }
        }
        return value.stringValue();
    }

    private <T> T castLiteral(Value value, Function<Literal, T> converter) {
        if (value instanceof Literal) {
            try {
                return converter.apply((Literal)value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private long milliseconds(Literal literal, boolean ignoreTimeZone) {
        XMLGregorianCalendar cal = literal.calendarValue();
        if (ignoreTimeZone) {
            return cal.toGregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT, null).getTimeInMillis();
        }
        if (cal.getTimezone() == Integer.MIN_VALUE) {
            cal.setTimezone(0);
        }
        return cal.toGregorianCalendar().getTimeInMillis();
    }
}

