/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class RDFFactImpl
implements RDFFact {
    private final ObjectConstant subject;
    private final IRIConstant property;
    private final RDFConstant object;
    private final @Nullable ObjectConstant graph;
    private final ObjectConstant classOrProperty;

    private RDFFactImpl(ObjectConstant subject, IRIConstant property, RDFConstant object, @Nullable ObjectConstant graph) {
        this.subject = Objects.requireNonNull(subject);
        this.property = Objects.requireNonNull(property);
        this.object = Objects.requireNonNull(object);
        this.graph = graph;
        this.classOrProperty = RDFFactImpl.extractClassOrProperty(property, object);
    }

    public static RDFFact createQuadFact(ObjectConstant subject, IRIConstant property, RDFConstant object, ObjectConstant graph) {
        return new RDFFactImpl(subject, property, object, graph);
    }

    public static RDFFact createTripleFact(ObjectConstant subject, IRIConstant property, RDFConstant object) {
        return new RDFFactImpl(subject, property, object, null);
    }

    private static ObjectConstant extractClassOrProperty(IRIConstant property, RDFConstant object) {
        if (property.getIRI().equals((Object)RDF.TYPE)) {
            if (object instanceof ObjectConstant) {
                return (ObjectConstant)object;
            }
            throw new IllegalArgumentException("The class must be an IRI or a b-node");
        }
        return property;
    }

    @Override
    public ObjectConstant getSubject() {
        return this.subject;
    }

    @Override
    public IRIConstant getProperty() {
        return this.property;
    }

    @Override
    public RDFConstant getObject() {
        return this.object;
    }

    @Override
    public Optional<ObjectConstant> getGraph() {
        return Optional.ofNullable(this.graph);
    }

    @Override
    public ObjectConstant getClassOrProperty() {
        return this.classOrProperty;
    }

    @Override
    public boolean isClassAssertion() {
        return !this.getClassOrProperty().equals(this.property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RDFFactImpl) {
            RDFFactImpl rdfFact = (RDFFactImpl)o;
            return this.subject.equals(rdfFact.subject) && this.property.equals(rdfFact.property) && this.object.equals(rdfFact.object) && Objects.equals(this.graph, rdfFact.graph);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.property, this.object, this.graph);
    }

    public String toString() {
        return "RDFFact{subject=" + this.subject + ", property=" + this.property + ", object=" + this.object + ", graph=" + this.graph + ", classOrProperty=" + this.classOrProperty + "}";
    }
}

