/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.spec.ontology.AnnotationProperty;
import it.unibz.inf.ontop.spec.ontology.BinaryAxiom;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataPropertyRangeExpression;
import it.unibz.inf.ontop.spec.ontology.DataRangeExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Datatype;
import it.unibz.inf.ontop.spec.ontology.DescriptionBT;
import it.unibz.inf.ontop.spec.ontology.InconsistentOntologyException;
import it.unibz.inf.ontop.spec.ontology.NaryAxiom;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.OntologyBuilder;
import it.unibz.inf.ontop.spec.ontology.OntologyVocabularyCategory;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.spec.ontology.impl.AnnotationPropertyImpl;
import it.unibz.inf.ontop.spec.ontology.impl.BinaryAxiomImpl;
import it.unibz.inf.ontop.spec.ontology.impl.ClassImpl;
import it.unibz.inf.ontop.spec.ontology.impl.DataPropertyExpressionImpl;
import it.unibz.inf.ontop.spec.ontology.impl.DatatypeImpl;
import it.unibz.inf.ontop.spec.ontology.impl.NaryAxiomImpl;
import it.unibz.inf.ontop.spec.ontology.impl.ObjectPropertyExpressionImpl;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;

public class OntologyBuilderImpl
implements OntologyBuilder {
    private final Hierarchy<ClassExpression> classAxioms = new Hierarchy();
    private final Hierarchy<ObjectPropertyExpression> objectPropertyAxioms = new Hierarchy();
    private final Hierarchy<DataPropertyExpression> dataPropertyAxioms = new Hierarchy();
    private final ImmutableList.Builder<BinaryAxiom<DataRangeExpression>> subDataRangeAxioms = ImmutableList.builder();
    private final ImmutableSet.Builder<ObjectPropertyExpression> reflexiveObjectPropertyAxioms = ImmutableSet.builder();
    private final ImmutableSet.Builder<ObjectPropertyExpression> irreflexiveObjectPropertyAxioms = ImmutableSet.builder();
    private final ImmutableSet.Builder<ObjectPropertyExpression> functionalObjectPropertyAxioms = ImmutableSet.builder();
    private final ImmutableSet.Builder<DataPropertyExpression> functionalDataPropertyAxioms = ImmutableSet.builder();
    private static final String CLASS_NOT_FOUND = "Class not found: ";
    private static final String OBJECT_PROPERTY_NOT_FOUND = "ObjectProperty not found: ";
    private static final String DATA_PROPERTY_NOT_FOUND = "DataProperty not found: ";
    private static final String DATATYPE_NOT_FOUND = "Datatype not found: ";
    private static final String ANNOTATION_PROPERTY_NOT_FOUND = "AnnotationProperty not found: ";
    private final OntologyCategoryImpl<OClass> classes;
    private final OntologyCategoryImpl<ObjectPropertyExpression> objectProperties;
    private final OntologyCategoryImpl<DataPropertyExpression> dataProperties;
    private final OntologyCategoryImpl<AnnotationProperty> annotationProperties;
    private final RDF rdfFactory;
    private final TermFactory termFactory;
    private final ImmutableSet.Builder<RDFFact> assertions = ImmutableSet.builder();
    private final IRIConstant rdfType;
    private final Set<ObjectPropertyExpression> auxObjectProperties = new HashSet<ObjectPropertyExpression>();
    private static final String AUXROLEURI = "urn:AUX.ROLE";
    private int auxCounter = 0;

    private OntologyBuilderImpl(RDF rdfFactory, TermFactory termFactory) {
        this.termFactory = termFactory;
        this.classes = new OntologyCategoryImpl<OClass>(ClassImpl::new, CLASS_NOT_FOUND, "");
        this.objectProperties = new OntologyCategoryImpl<ObjectPropertyExpression>(ObjectPropertyExpressionImpl::new, OBJECT_PROPERTY_NOT_FOUND, "");
        this.dataProperties = new OntologyCategoryImpl<DataPropertyExpression>(DataPropertyExpressionImpl::new, DATA_PROPERTY_NOT_FOUND, "");
        this.annotationProperties = new OntologyCategoryImpl<AnnotationProperty>(AnnotationPropertyImpl::new, ANNOTATION_PROPERTY_NOT_FOUND, "");
        this.classes.map.put(OWL.THING, ClassImpl.owlThing);
        this.classes.map.put(OWL.NOTHING, ClassImpl.owlNothing);
        this.objectProperties.map.put(OWL.TOP_OBJECT_PROPERTY, ObjectPropertyExpressionImpl.owlTopObjectProperty);
        this.objectProperties.map.put(OWL.BOTTOM_OBJECT_PROPERTY, ObjectPropertyExpressionImpl.owlBottomObjectProperty);
        this.dataProperties.map.put(OWL.TOP_DATA_PROPERTY, DataPropertyExpressionImpl.owlTopDataProperty);
        this.dataProperties.map.put(OWL.BOTTOM_DATA_PROPERTY, DataPropertyExpressionImpl.owlBottomDataProperty);
        this.rdfType = termFactory.getConstantIRI(it.unibz.inf.ontop.model.vocabulary.RDF.TYPE);
        this.rdfFactory = rdfFactory;
    }

    public static OntologyBuilder builder(RDF rdfFactory, TermFactory termFactory) {
        return new OntologyBuilderImpl(rdfFactory, termFactory);
    }

    @Override
    public OntologyVocabularyCategory<OClass> classes() {
        return this.classes;
    }

    @Override
    public OntologyVocabularyCategory<ObjectPropertyExpression> objectProperties() {
        return this.objectProperties;
    }

    @Override
    public OntologyVocabularyCategory<DataPropertyExpression> dataProperties() {
        return this.dataProperties;
    }

    @Override
    public OntologyVocabularyCategory<AnnotationProperty> annotationProperties() {
        return this.annotationProperties;
    }

    @Override
    public OClass declareClass(IRI iri) {
        return this.classes.create(iri);
    }

    @Override
    public ObjectPropertyExpression declareObjectProperty(IRI iri) {
        return this.objectProperties.create(iri);
    }

    @Override
    public DataPropertyExpression declareDataProperty(IRI uri) {
        return this.dataProperties.create(uri);
    }

    @Override
    public AnnotationProperty declareAnnotationProperty(IRI iri) {
        return this.annotationProperties.create(iri);
    }

    @Override
    public Datatype getDatatype(String uri) {
        Datatype dt = (Datatype)OntologyImpl.OWL2QLDatatypes.get((Object)uri);
        if (dt == null) {
            throw new RuntimeException(DATATYPE_NOT_FOUND + uri);
        }
        return dt;
    }

    @Override
    public void addSubClassOfAxiom(ClassExpression ce1, ClassExpression ce2) throws InconsistentOntologyException {
        this.checkSignature(ce1);
        this.checkSignature(ce2);
        if (ce1.isTop()) {
            ce1 = ClassImpl.owlThing;
        }
        this.classAxioms.addInclusion(ce1, ce2);
    }

    @Override
    public void addDataPropertyRangeAxiom(DataPropertyRangeExpression range, Datatype datatype) throws InconsistentOntologyException {
        this.checkSignature(range);
        this.checkSignature(datatype);
        if (datatype.equals(DatatypeImpl.rdfsLiteral)) {
            return;
        }
        if (range.getProperty().isBottom()) {
            return;
        }
        if (range.getProperty().isTop()) {
            throw new InconsistentOntologyException();
        }
        BinaryAxiomImpl<Datatype> ax = new BinaryAxiomImpl<Datatype>((Datatype)((Object)range), datatype);
        this.subDataRangeAxioms.add(ax);
    }

    @Override
    public void addSubPropertyOfAxiom(ObjectPropertyExpression ope1, ObjectPropertyExpression ope2) throws InconsistentOntologyException {
        this.checkSignature(ope1);
        this.checkSignature(ope2);
        this.objectPropertyAxioms.addInclusion(ope1, ope2);
    }

    @Override
    public void addSubPropertyOfAxiom(DataPropertyExpression dpe1, DataPropertyExpression dpe2) throws InconsistentOntologyException {
        this.checkSignature(dpe1);
        this.checkSignature(dpe2);
        this.dataPropertyAxioms.addInclusion(dpe1, dpe2);
    }

    @Override
    public void addDisjointClassesAxiom(ClassExpression ... ces) throws InconsistentOntologyException {
        for (ClassExpression c : ces) {
            this.checkSignature(c);
        }
        this.classAxioms.addDisjointness(ces);
    }

    @Override
    public void addDisjointObjectPropertiesAxiom(ObjectPropertyExpression ... opes) throws InconsistentOntologyException {
        for (ObjectPropertyExpression p : opes) {
            this.checkSignature(p);
        }
        this.objectPropertyAxioms.addDisjointness(opes);
    }

    @Override
    public void addDisjointDataPropertiesAxiom(DataPropertyExpression ... dpes) throws InconsistentOntologyException {
        for (DataPropertyExpression dpe : dpes) {
            this.checkSignature(dpe);
        }
        this.dataPropertyAxioms.addDisjointness(dpes);
    }

    @Override
    public void addReflexiveObjectPropertyAxiom(ObjectPropertyExpression ope) throws InconsistentOntologyException {
        if (ope.isTop()) {
            return;
        }
        if (ope.isBottom()) {
            throw new InconsistentOntologyException();
        }
        this.reflexiveObjectPropertyAxioms.add((Object)(ope.isInverse() ? ope.getInverse() : ope));
    }

    @Override
    public void addIrreflexiveObjectPropertyAxiom(ObjectPropertyExpression ope) throws InconsistentOntologyException {
        if (ope.isTop()) {
            throw new InconsistentOntologyException();
        }
        if (ope.isBottom()) {
            return;
        }
        this.irreflexiveObjectPropertyAxioms.add((Object)(ope.isInverse() ? ope.getInverse() : ope));
    }

    @Override
    public void addFunctionalObjectPropertyAxiom(ObjectPropertyExpression prop) {
        this.checkSignature(prop);
        this.functionalObjectPropertyAxioms.add((Object)prop);
    }

    @Override
    public void addFunctionalDataPropertyAxiom(DataPropertyExpression prop) {
        this.checkSignature(prop);
        this.functionalDataPropertyAxioms.add((Object)prop);
    }

    private RDFFact createClassAssertion(OClass ce, ObjectConstant object) throws InconsistentOntologyException {
        if (ce.isTop()) {
            return null;
        }
        if (ce.isBottom()) {
            throw new InconsistentOntologyException();
        }
        return RDFFact.createTripleFact(object, this.rdfType, (RDFConstant)this.termFactory.getConstantIRI(ce.getIRI()));
    }

    private RDFFact createObjectPropertyAssertion(ObjectPropertyExpression ope, ObjectConstant o1, ObjectConstant o2) throws InconsistentOntologyException {
        if (ope.isTop()) {
            return null;
        }
        if (ope.isBottom()) {
            throw new InconsistentOntologyException();
        }
        if (ope.isInverse()) {
            return RDFFact.createTripleFact(o2, this.termFactory.getConstantIRI(ope.getInverse().getIRI()), (RDFConstant)o1);
        }
        return RDFFact.createTripleFact(o1, this.termFactory.getConstantIRI(ope.getIRI()), (RDFConstant)o2);
    }

    private RDFFact createDataPropertyAssertion(DataPropertyExpression dpe, ObjectConstant o1, RDFLiteralConstant o2) throws InconsistentOntologyException {
        if (dpe.isTop()) {
            return null;
        }
        if (dpe.isBottom()) {
            throw new InconsistentOntologyException();
        }
        return RDFFact.createTripleFact(o1, this.termFactory.getConstantIRI(dpe.getIRI()), (RDFConstant)o2);
    }

    private RDFFact createAnnotationAssertion(AnnotationProperty ap, ObjectConstant o, RDFConstant c) {
        return RDFFact.createTripleFact(o, this.termFactory.getConstantIRI(ap.getIRI()), c);
    }

    @Override
    public void addClassAssertion(OClass ce, ObjectConstant o) throws InconsistentOntologyException {
        this.checkSignature(ce);
        RDFFact assertion = this.createClassAssertion(ce, o);
        if (assertion != null) {
            this.assertions.add((Object)assertion);
        }
    }

    @Override
    public void addObjectPropertyAssertion(ObjectPropertyExpression ope, ObjectConstant o1, ObjectConstant o) throws InconsistentOntologyException {
        this.checkSignature(ope);
        RDFFact assertion = this.createObjectPropertyAssertion(ope, o1, o);
        if (assertion != null) {
            this.assertions.add((Object)assertion);
        }
    }

    @Override
    public void addDataPropertyAssertion(DataPropertyExpression dpe, ObjectConstant o, RDFLiteralConstant v) throws InconsistentOntologyException {
        this.checkSignature(dpe);
        RDFFact assertion = this.createDataPropertyAssertion(dpe, o, v);
        if (assertion != null) {
            this.assertions.add((Object)assertion);
        }
    }

    @Override
    public void addAnnotationAssertion(AnnotationProperty ap, ObjectConstant o, RDFConstant c) {
        this.checkSignature(ap);
        RDFFact assertion = this.createAnnotationAssertion(ap, o, c);
        if (assertion != null) {
            this.assertions.add((Object)assertion);
        }
    }

    @Override
    public Ontology build() {
        return new OntologyImpl(this.classes.getImmutableCopy(), this.objectProperties.getImmutableCopy(), (ImmutableSet<ObjectPropertyExpression>)ImmutableSet.copyOf(this.auxObjectProperties), this.dataProperties.getImmutableCopy(), this.annotationProperties.getImmutableCopy(), (ImmutableList<BinaryAxiom<ClassExpression>>)this.classAxioms.inclusions.build(), (ImmutableList<NaryAxiom<ClassExpression>>)this.classAxioms.disjointness.build(), (ImmutableList<BinaryAxiom<ObjectPropertyExpression>>)this.objectPropertyAxioms.inclusions.build(), (ImmutableList<NaryAxiom<ObjectPropertyExpression>>)this.objectPropertyAxioms.disjointness.build(), (ImmutableList<BinaryAxiom<DataPropertyExpression>>)this.dataPropertyAxioms.inclusions.build(), (ImmutableList<NaryAxiom<DataPropertyExpression>>)this.dataPropertyAxioms.disjointness.build(), (ImmutableList<BinaryAxiom<DataRangeExpression>>)this.subDataRangeAxioms.build(), (ImmutableSet<ObjectPropertyExpression>)this.reflexiveObjectPropertyAxioms.build(), (ImmutableSet<ObjectPropertyExpression>)this.irreflexiveObjectPropertyAxioms.build(), (ImmutableSet<ObjectPropertyExpression>)this.functionalObjectPropertyAxioms.build(), (ImmutableSet<DataPropertyExpression>)this.functionalDataPropertyAxioms.build(), (ImmutableSet<RDFFact>)this.assertions.build());
    }

    @Override
    public ObjectPropertyExpression createAuxiliaryObjectProperty() {
        ObjectPropertyExpressionImpl ope = new ObjectPropertyExpressionImpl(this.rdfFactory.createIRI(AUXROLEURI + this.auxCounter));
        ++this.auxCounter;
        this.auxObjectProperties.add(ope);
        return ope;
    }

    private void checkSignature(ClassExpression desc) {
        if (desc instanceof OClass) {
            OClass cl = (OClass)desc;
            if (!this.classes.contains(cl.getIRI())) {
                throw new IllegalArgumentException(CLASS_NOT_FOUND + desc);
            }
        } else if (desc instanceof ObjectSomeValuesFrom) {
            this.checkSignature(((ObjectSomeValuesFrom)desc).getProperty());
        } else {
            assert (desc instanceof DataSomeValuesFrom);
            this.checkSignature(((DataSomeValuesFrom)desc).getProperty());
        }
    }

    private void checkSignature(Datatype desc) {
        if (!OntologyImpl.OWL2QLDatatypes.containsKey((Object)desc.getIRI().getIRIString())) {
            throw new IllegalArgumentException(DATATYPE_NOT_FOUND + desc);
        }
    }

    private void checkSignature(DataPropertyRangeExpression desc) {
        this.checkSignature(desc.getProperty());
    }

    private void checkSignature(ObjectPropertyExpression prop) {
        if (prop.isInverse()) {
            prop = prop.getInverse();
        }
        if (!this.objectProperties.contains(prop.getIRI()) && !this.auxObjectProperties.contains(prop)) {
            throw new IllegalArgumentException(OBJECT_PROPERTY_NOT_FOUND + prop);
        }
    }

    private void checkSignature(DataPropertyExpression prop) {
        if (!this.dataProperties.contains(prop.getIRI())) {
            throw new IllegalArgumentException(DATA_PROPERTY_NOT_FOUND + prop);
        }
    }

    private void checkSignature(AnnotationProperty prop) {
        if (!this.annotationProperties.contains(prop.getIRI())) {
            throw new IllegalArgumentException(ANNOTATION_PROPERTY_NOT_FOUND + prop);
        }
    }

    static final class Hierarchy<T extends DescriptionBT> {
        private final ImmutableList.Builder<BinaryAxiom<T>> inclusions = ImmutableList.builder();
        private final ImmutableList.Builder<NaryAxiom<T>> disjointness = ImmutableList.builder();

        Hierarchy() {
        }

        void addInclusion(T e1, T e2) throws InconsistentOntologyException {
            if (e1.isBottom() || e2.isTop()) {
                return;
            }
            if (e2.isBottom()) {
                if (e1.isTop()) {
                    throw new InconsistentOntologyException();
                }
                NaryAxiomImpl ax = new NaryAxiomImpl(ImmutableList.of(e1, e1));
                this.disjointness.add(ax);
            } else {
                BinaryAxiomImpl<T> ax = new BinaryAxiomImpl<T>(e1, e2);
                this.inclusions.add(ax);
            }
        }

        @SafeVarargs
        final void addDisjointness(T ... es) throws InconsistentOntologyException {
            ImmutableList.Builder sb = new ImmutableList.Builder();
            int numberOfTop = 0;
            for (T e : es) {
                if (e.isBottom()) continue;
                if (e.isTop()) {
                    ++numberOfTop;
                    continue;
                }
                sb.add(e);
            }
            ImmutableList nonTrivialElements = sb.build();
            if (numberOfTop == 0) {
                if (nonTrivialElements.size() >= 2) {
                    NaryAxiomImpl ax = new NaryAxiomImpl(nonTrivialElements);
                    this.disjointness.add(ax);
                }
            } else if (numberOfTop == 1) {
                for (DescriptionBT dpe : nonTrivialElements) {
                    NaryAxiomImpl ax = new NaryAxiomImpl(ImmutableList.of((Object)dpe, (Object)dpe));
                    this.disjointness.add(ax);
                }
            } else {
                throw new InconsistentOntologyException();
            }
        }
    }

    static final class OntologyCategoryImpl<T>
    implements OntologyVocabularyCategory<T> {
        private final Map<IRI, T> map = new HashMap<IRI, T>();
        private final String NOT_FOUND;
        private final String EXISTS;
        private final Function<IRI, ? extends T> ctor;

        OntologyCategoryImpl(Function<IRI, ? extends T> ctor, String NOT_FOUND, String EXISTS) {
            this.ctor = ctor;
            this.NOT_FOUND = NOT_FOUND;
            this.EXISTS = EXISTS;
        }

        @Override
        public T get(IRI iri) {
            T oc = this.map.get(iri);
            if (oc == null) {
                throw new RuntimeException(this.NOT_FOUND + iri);
            }
            return oc;
        }

        @Override
        public boolean contains(IRI iri) {
            return this.map.containsKey(iri);
        }

        @Override
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }

        private T create(IRI uri) {
            T n = this.ctor.apply(uri);
            this.map.put(uri, n);
            return n;
        }

        OntologyImpl.ImmutableOntologyVocabularyCategoryImpl<T> getImmutableCopy() {
            return new OntologyImpl.ImmutableOntologyVocabularyCategoryImpl(ImmutableMap.copyOf(this.map), this.NOT_FOUND);
        }
    }
}

