/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.impl.GabowSCC;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class EquivalencesDAGImpl<T>
implements EquivalencesDAG<T> {
    private final SimpleDirectedGraph<Equivalences<T>, DefaultEdge> dag;
    private final ImmutableMap<T, Equivalences<T>> vertexIndex;
    private final ImmutableMap<T, Equivalences<T>> fullVertexIndex;
    private final Map<Equivalences<T>, ImmutableSet<T>> subRep = new HashMap<Equivalences<T>, ImmutableSet<T>>();
    private final Map<Equivalences<T>, ImmutableSet<Equivalences<T>>> sub = new HashMap<Equivalences<T>, ImmutableSet<Equivalences<T>>>();
    private DefaultDirectedGraph<T, DefaultEdge> graph;

    private EquivalencesDAGImpl(DefaultDirectedGraph<T, DefaultEdge> graph, SimpleDirectedGraph<Equivalences<T>, DefaultEdge> dag, ImmutableMap<T, Equivalences<T>> vertexIndex, ImmutableMap<T, Equivalences<T>> fullVertexIndex) {
        this.graph = graph;
        this.dag = dag;
        this.vertexIndex = vertexIndex;
        this.fullVertexIndex = fullVertexIndex;
    }

    private static <T> ImmutableSet<T> immutableSetOf(BreadthFirstIterator<T, DefaultEdge> iterator) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            builder.add(child);
        }
        return builder.build();
    }

    private static <T> ImmutableSet<T> immutableSetOfRepresentatives(BreadthFirstIterator<Equivalences<T>, DefaultEdge> iterator) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        while (iterator.hasNext()) {
            Equivalences child = (Equivalences)iterator.next();
            builder.add(child.getRepresentative());
        }
        return builder.build();
    }

    @Override
    public Equivalences<T> getVertex(T v) {
        return (Equivalences)this.vertexIndex.get(v);
    }

    @Override
    public T getCanonicalForm(T v) {
        Equivalences vs = (Equivalences)this.fullVertexIndex.get(v);
        if (vs == null) {
            return null;
        }
        return vs.getRepresentative();
    }

    @Override
    public ImmutableSet<Equivalences<T>> getDirectSub(Equivalences<T> v) {
        return (ImmutableSet)this.dag.incomingEdgesOf(v).stream().map(arg_0 -> this.dag.getEdgeSource(arg_0)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<Equivalences<T>> getSub(Equivalences<T> v) {
        return this.sub.computeIfAbsent(v, n -> EquivalencesDAGImpl.immutableSetOf(new BreadthFirstIterator((Graph)new EdgeReversedGraph(this.dag), n)));
    }

    @Override
    public ImmutableSet<T> getSubRepresentatives(T v) {
        Equivalences eq = (Equivalences)this.vertexIndex.get(v);
        if (eq == null) {
            return ImmutableSet.of(v);
        }
        return this.subRep.computeIfAbsent(eq, n -> EquivalencesDAGImpl.immutableSetOfRepresentatives(new BreadthFirstIterator((Graph)new EdgeReversedGraph(this.dag), n)));
    }

    @Override
    public ImmutableSet<Equivalences<T>> getDirectSuper(Equivalences<T> v) {
        return (ImmutableSet)this.dag.outgoingEdgesOf(v).stream().map(arg_0 -> this.dag.getEdgeTarget(arg_0)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<Equivalences<T>> getSuper(Equivalences<T> v) {
        return EquivalencesDAGImpl.immutableSetOf(new BreadthFirstIterator(this.dag, v));
    }

    @Override
    public Stream<Equivalences<T>> stream() {
        return this.dag.vertexSet().stream();
    }

    public String toString() {
        return this.dag.toString() + "\n\nEquivalencesMap\n" + this.vertexIndex;
    }

    @Override
    public Iterator<Equivalences<T>> iterator() {
        return this.dag.vertexSet().iterator();
    }

    @Deprecated
    public int edgeSetSize() {
        return this.dag.edgeSet().size();
    }

    @Deprecated
    public int vertexSetSize() {
        return this.dag.vertexSet().size();
    }

    public DefaultDirectedGraph<T, DefaultEdge> getGraph() {
        if (this.graph == null) {
            this.graph = new DefaultDirectedGraph(DefaultEdge.class);
            for (Equivalences node : this.dag.vertexSet()) {
                for (Object v : node) {
                    this.graph.addVertex(v);
                }
                for (Object v : node) {
                    this.graph.addEdge(v, node.getRepresentative());
                    this.graph.addEdge(node.getRepresentative(), v);
                }
            }
            for (DefaultEdge edge : this.dag.edgeSet()) {
                this.graph.addEdge(((Equivalences)this.dag.getEdgeSource((Object)edge)).getRepresentative(), ((Equivalences)this.dag.getEdgeTarget((Object)edge)).getRepresentative());
            }
        }
        return this.graph;
    }

    public static <TT> EquivalencesDAGImpl<TT> getEquivalencesDAG(DefaultDirectedGraph<TT, DefaultEdge> graph) {
        GabowSCC<TT, DefaultEdge> inspector = new GabowSCC<TT, DefaultEdge>(graph);
        List<Equivalences<TT>> equivalenceSets = inspector.stronglyConnectedSets();
        ImmutableMap.Builder vertexIndexBuilder = new ImmutableMap.Builder();
        for (Equivalences<TT> equivalenceSet : equivalenceSets) {
            for (TT node : equivalenceSet) {
                vertexIndexBuilder.put(node, equivalenceSet);
            }
        }
        ImmutableMap vertexIndex = vertexIndexBuilder.build();
        HashMap<Equivalences, Set> outgoingEdges = new HashMap<Equivalences, Set>();
        for (DefaultEdge edge : graph.edgeSet()) {
            Equivalences v2;
            Equivalences equivalences = (Equivalences)vertexIndex.get(graph.getEdgeSource((Object)edge));
            if (equivalences == (v2 = (Equivalences)vertexIndex.get(graph.getEdgeTarget((Object)edge)))) continue;
            Set out = outgoingEdges.computeIfAbsent(equivalences, k -> new HashSet());
            out.add(v2);
        }
        SimpleDirectedGraph dag = new SimpleDirectedGraph(DefaultEdge.class);
        for (Equivalences<TT> equivalences : equivalenceSets) {
            dag.addVertex(equivalences);
        }
        for (Map.Entry entry : outgoingEdges.entrySet()) {
            Equivalences v1 = (Equivalences)entry.getKey();
            for (Equivalences v2 : (Set)entry.getValue()) {
                boolean redundant = false;
                if (((Set)entry.getValue()).size() > 1) {
                    for (Equivalences v2p : (Set)entry.getValue()) {
                        Set t2p = (Set)outgoingEdges.get(v2p);
                        if (t2p == null || !t2p.contains(v2)) continue;
                        redundant = true;
                        break;
                    }
                }
                if (redundant) continue;
                dag.addEdge((Object)v1, (Object)v2);
            }
        }
        return new EquivalencesDAGImpl<TT>(graph, dag, vertexIndex, vertexIndex);
    }

    public static <T> EquivalencesDAGImpl<T> reduce(EquivalencesDAGImpl<T> source, SimpleDirectedGraph<Equivalences<T>, DefaultEdge> target) {
        ImmutableMap.Builder vertexIndexBuilder = new ImmutableMap.Builder();
        for (Equivalences tSet : target.vertexSet()) {
            for (T s : source.getVertex(tSet.getRepresentative())) {
                if (!tSet.contains(s)) continue;
                vertexIndexBuilder.put(s, (Object)tSet);
            }
        }
        ImmutableMap vertexIndex = vertexIndexBuilder.build();
        for (Equivalences<T> sSet : source) {
            Equivalences tSet = (Equivalences)vertexIndex.get(sSet.getRepresentative());
            for (Equivalences sSetSub : source.getDirectSub(sSet)) {
                Equivalences tSetSub = (Equivalences)vertexIndex.get(sSetSub.getRepresentative());
                target.addEdge((Object)tSetSub, (Object)tSet);
            }
        }
        return new EquivalencesDAGImpl<T>(null, target, vertexIndex, source.vertexIndex);
    }
}

