/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import it.unibz.inf.ontop.model.vocabulary.OntopInternal;
import it.unibz.inf.ontop.spec.mapping.impl.AbstractPrefixManager;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class SimplePrefixManager
extends AbstractPrefixManager {
    private final ImmutableMap<String, String> prefixToIriMap;
    private static final ImmutableMap<String, String> standardIriPrefixes = ImmutableMap.of((Object)OntopInternal.PREFIX_RDF, (Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)OntopInternal.PREFIX_RDFS, (Object)"http://www.w3.org/2000/01/rdf-schema#", (Object)OntopInternal.PREFIX_OWL, (Object)"http://www.w3.org/2002/07/owl#", (Object)OntopInternal.PREFIX_XSD, (Object)"http://www.w3.org/2001/XMLSchema#", (Object)OntopInternal.PREFIX_OBDA, (Object)"https://w3id.org/obda/vocabulary#");
    private List<Map.Entry<String, String>> orderedMap;

    @Inject
    private SimplePrefixManager(@Assisted ImmutableMap<String, String> prefixToIriMap) {
        if (prefixToIriMap.containsValue(null)) {
            throw new NullPointerException("Prefix name must not be null");
        }
        if (!prefixToIriMap.keySet().stream().allMatch(p -> p.endsWith(":"))) {
            throw new IllegalArgumentException("Prefix names must end with a colon (:)");
        }
        this.prefixToIriMap = (ImmutableMap)Stream.concat(prefixToIriMap.entrySet().stream(), standardIriPrefixes.entrySet().stream()).distinct().collect(ImmutableCollectors.toMap());
    }

    @Override
    protected Optional<String> getIriDefinition(String prefix) {
        return Optional.ofNullable((String)this.prefixToIriMap.get((Object)prefix));
    }

    @Override
    protected List<Map.Entry<String, String>> getOrderedMap() {
        if (this.orderedMap == null) {
            this.orderedMap = SimplePrefixManager.orderMap(this.prefixToIriMap);
        }
        return this.orderedMap;
    }

    @Override
    public Map<String, String> getPrefixMap() {
        return this.prefixToIriMap;
    }
}

