/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopOBDAConfiguration;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOBDAModule;
import it.unibz.inf.ontop.spec.OBDASpecification;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class OntopOBDAConfigurationImpl
extends OntopModelConfigurationImpl
implements OntopOBDAConfiguration {
    private final OntopOBDASettings settings;
    private final OntopOBDAOptions options;

    OntopOBDAConfigurationImpl(OntopOBDASettings settings, OntopOBDAOptions options) {
        super((OntopModelSettings)settings, options.modelOptions);
        this.settings = settings;
        this.options = options;
    }

    OntopOBDAConfigurationImpl(OntopOBDASettings settings, OntopOBDAOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopModelSettings)settings, options.modelOptions, injectorSupplier);
        this.settings = settings;
        this.options = options;
    }

    @Override
    public OntopOBDASettings getSettings() {
        return this.settings;
    }

    @Override
    public final OBDASpecification loadSpecification() throws OBDASpecificationException {
        if (this.options.optionalSpecification.isPresent()) {
            return this.options.optionalSpecification.get();
        }
        return this.loadOBDASpecification();
    }

    protected abstract OBDASpecification loadOBDASpecification() throws OBDASpecificationException;

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopOBDAModule(this)));
    }

    @Override
    public SpecificationFactory getSpecificationFactory() {
        return (SpecificationFactory)this.getInjector().getInstance(SpecificationFactory.class);
    }

    protected static abstract class OntopOBDAConfigurationBuilderMixin<B extends OntopOBDAConfiguration.Builder<B>>
    implements OntopOBDAConfiguration.Builder<B> {
        private final DefaultOntopOBDABuilderFragment<B> localBuilderFragment = new DefaultOntopOBDABuilderFragment<B>(){

            @Override
            protected B self() {
                return this.self();
            }

            @Override
            protected void declareOBDASpecificationAssigned() {
                this.declareOBDASpecificationAssigned();
            }
        };
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B>(){

            protected B self() {
                return this.self();
            }
        };

        OntopOBDAConfigurationBuilderMixin() {
        }

        protected abstract B self();

        @Override
        public B obdaSpecification(OBDASpecification specification) {
            return this.localBuilderFragment.obdaSpecification(specification);
        }

        @Override
        public B sameAsMappings(boolean enable) {
            return this.localBuilderFragment.sameAsMappings(enable);
        }

        protected final OntopOBDAOptions generateOBDAOptions() {
            return this.localBuilderFragment.generateOBDAOptions(this.modelBuilderFragment.generateModelOptions());
        }

        protected Properties generateProperties() {
            Properties properties = this.modelBuilderFragment.generateProperties();
            properties.putAll((Map<?, ?>)this.localBuilderFragment.generateProperties());
            return properties;
        }

        protected void declareOBDASpecificationAssigned() {
        }

        protected final boolean isOBDASpecificationAssigned() {
            return this.localBuilderFragment.isOBDASpecificationAssigned();
        }
    }

    static abstract class DefaultOntopOBDABuilderFragment<B extends OntopOBDAConfiguration.Builder<B>>
    implements OntopOBDAConfiguration.OntopOBDABuilderFragment<B> {
        private Optional<Boolean> sameAsMappings = Optional.empty();
        private Optional<OBDASpecification> specification = Optional.empty();

        DefaultOntopOBDABuilderFragment() {
        }

        protected abstract B self();

        protected abstract void declareOBDASpecificationAssigned();

        @Override
        public B obdaSpecification(OBDASpecification specification) {
            this.declareOBDASpecificationAssigned();
            this.specification = Optional.of(specification);
            return this.self();
        }

        @Override
        public B sameAsMappings(boolean sameAsMappings) {
            this.sameAsMappings = Optional.of(sameAsMappings);
            return this.self();
        }

        protected Properties generateProperties() {
            Properties p = new Properties();
            this.sameAsMappings.ifPresent(b -> p.put("ontop.sameAs", b));
            return p;
        }

        protected final OntopOBDAOptions generateOBDAOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            return new OntopOBDAOptions(modelOptions, this.specification);
        }

        protected final boolean isOBDASpecificationAssigned() {
            return this.specification.isPresent();
        }
    }

    static class OntopOBDAOptions {
        final OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions;
        final Optional<OBDASpecification> optionalSpecification;

        private OntopOBDAOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions, Optional<OBDASpecification> optionalSpecification) {
            this.modelOptions = modelOptions;
            this.optionalSpecification = optionalSpecification;
        }
    }
}

