/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.x509;

import com.ontotext.graphdb.ConfigException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Objects;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class X509HeaderExtractionFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_CERTIFICATE_HEADER = "ssl_client_cert";
    public static final String DEFAULT_ESCAPED_CERTIFICATE_HEADER = "ssl_client_escaped_cert";
    private static final String CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    private final X509TrustManager x509TrustManager;
    private String certificateHeader = "ssl_client_cert";
    private String escapedCertificateHeader = "ssl_client_escaped_cert";

    public X509HeaderExtractionFilter(TrustManager[] trustManagers) {
        Objects.requireNonNull(trustManagers, "Trust managers cannot not be null!");
        this.x509TrustManager = X509HeaderExtractionFilter.getX509TrustManager(trustManagers);
    }

    public String getCertificateHeader() {
        return this.certificateHeader;
    }

    public void setCertificateHeader(String certificateHeader) {
        Objects.requireNonNull(certificateHeader, "Certificate header key cannot be null!");
        this.certificateHeader = certificateHeader;
    }

    public String getEscapedCertificateHeader() {
        return this.escapedCertificateHeader;
    }

    public void setEscapedCertificateHeader(String escapedCertificateHeader) {
        Objects.requireNonNull(this.certificateHeader, "Escaped certificate header key cannot be null!");
        this.escapedCertificateHeader = escapedCertificateHeader;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (X509HeaderExtractionFilter.requestHasCertificates(request)) {
            this.logger.debug((Object)"Request context already has certificate information");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String headerValue = this.extractHeaderValue(request);
        if (StringUtils.isBlank((CharSequence)headerValue)) {
            this.logger.debug((Object)"Missing certificate in the configured headers");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            X509Certificate[] x509Certificates = X509HeaderExtractionFilter.parseCertificates(headerValue);
            if (x509Certificates.length > 0) {
                this.x509TrustManager.checkClientTrusted(x509Certificates, "RSA");
                request.setAttribute("jakarta.servlet.request.X509Certificate", (Object)x509Certificates);
            }
        }
        catch (CertificateException e) {
            this.logger.warn((Object)("Invalid certificate: " + e.getMessage()), (Throwable)e);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static boolean requestHasCertificates(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
        return certs != null && certs.length > 0;
    }

    private String extractHeaderValue(HttpServletRequest request) {
        String headerValue = request.getHeader(this.certificateHeader);
        String escapedHeaderValue = request.getHeader(this.escapedCertificateHeader);
        if (StringUtils.isNotBlank((CharSequence)escapedHeaderValue)) {
            headerValue = URLDecoder.decode(escapedHeaderValue, StandardCharsets.UTF_8);
        }
        return headerValue;
    }

    private static X509Certificate[] parseCertificates(String headerValue) throws CertificateException, IOException {
        String[] values = headerValue.split(CERTIFICATE_HEADER);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            String restored = "-----BEGIN CERTIFICATE-----\n" + value.trim();
            certificates.add(X509HeaderExtractionFilter.parseCertificate(restored));
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    private static X509Certificate parseCertificate(String certificateHeader) throws CertificateException, IOException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream certificateStream = new ByteArrayInputStream(certificateHeader.getBytes());){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(certificateStream);
            return x509Certificate;
        }
    }

    private static X509TrustManager getX509TrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new ConfigException("Could not find X509TrustManager");
    }
}

