/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.rest;

import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.UISecurityConfig;
import com.ontotext.forest.security.rest.AccessBean;
import com.ontotext.forest.security.role.RoleToSpring;
import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.graphdb.security.Role;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/rest/security"})
@Controller
@Tag(name="Security Management", description="Manage GraphDB security")
public class SecurityManagementController {
    public static final String MAPPING = "/rest/security";
    public static final String AUTHENTICATED_USER_PATH = "/authenticated-user";
    @Autowired
    private AccountsService accountsService;
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private UISecurityConfig uiSecurityConfig;

    @GetMapping(value={"/all"})
    @Hidden
    public ResponseEntity<?> getAll() {
        return new ResponseEntity((Object)this.uiSecurityConfig, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping
    @Operation(summary="Check if security is enabled")
    public ResponseEntity<Boolean> isEnabledSecurity() {
        return new ResponseEntity((Object)this.uiSecurityConfig.isEnabled(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping
    @Operation(summary="Enable or disable security", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(mediaType="text/plain")}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    public ResponseEntity<?> setEnableSecurity(@RequestBody Boolean useSecurity) {
        try {
            this.securityConfig.setEnabledSecurity(useSecurity);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
    }

    @GetMapping(value={"/free-access"})
    @Operation(summary="Check if free access is enabled")
    public ResponseEntity<AccessBean> isEnabledFreeAccess() {
        return new ResponseEntity((Object)this.uiSecurityConfig.getFreeAccess(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/override-auth"})
    @Hidden
    public ResponseEntity<AccessBean> isOverrideAuth() {
        return new ResponseEntity((Object)this.uiSecurityConfig.getOverrideAuth(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/free-access"})
    @Operation(summary="Enable or disable free access", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    public ResponseEntity<?> setEnableFreeAccess(@RequestBody AccessBean freeaccess) {
        try {
            this.securityConfig.setEnableFreeAccess(freeaccess.isEnabled());
            if (freeaccess.isEnabled()) {
                this.securityConfig.setFreeAccessAuthorities(freeaccess.getAuthorities());
                this.securityConfig.setFreeAccessSettings(freeaccess.getAppSettings());
            }
        }
        catch (RuntimeException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/authenticated-user"})
    @Hidden
    public ResponseEntity<AuthenticatedUser> authenticatedUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        AuthenticatedUser authUser = (AuthenticatedUser)auth.getPrincipal();
        authUser.setAuthorities(authUser.getExpandedAuthorities());
        return new ResponseEntity((Object)authUser, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/users"})
    @Operation(summary="Get all users", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    public ResponseEntity<Collection<Account>> getAllUsers() {
        Collection accounts = this.accountsService.getAll().stream().map(Account::clonePasswordless).collect(Collectors.toList());
        return new ResponseEntity((Object)accounts, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/users/**"})
    public ResponseEntity<?> getUser(HttpServletRequest request) {
        return this.withAccountFromRequestWithSecurity(request, null, account -> new ResponseEntity(account, (HttpStatusCode)HttpStatus.OK));
    }

    @GetMapping(value={"/users/{username}"})
    @Operation(summary="Get a user", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Account.class))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(mediaType="text/plain")}), @ApiResponse(responseCode="404", description="Not Found")})
    public ResponseEntity<?> getUser(@PathVariable String username, HttpServletRequest request) {
        return this.getUser(request);
    }

    @PostMapping(value={"/users/**"}, produces={"text/plain"})
    public ResponseEntity<?> createUser(@RequestBody Account user, HttpServletRequest request) {
        if (this.accountsService.isLocal()) {
            this.setUsernameFromRequest(user, request);
            Account existingUser = this.accountsService.getAccount(user.getUsername());
            if (existingUser != null) {
                return new ResponseEntity((Object)"An account with the given username already exists.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            try {
                SecurityUtils.validateUser(user);
            }
            catch (IllegalArgumentException e) {
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            this.accountsService.addNewUser(user);
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        return new ResponseEntity((Object)(this.accountsService.getImplementationName() + " does not support user creation"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/users/{username}"}, produces={"text/plain"})
    @Operation(summary="Create a user", responses={@ApiResponse(responseCode="201", description="Created", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    public ResponseEntity<?> createUser(@PathVariable String username, @RequestBody Account user, HttpServletRequest request) {
        return this.createUser(user, request);
    }

    @PutMapping(value={"/users/**"})
    public ResponseEntity<?> editUser(@RequestBody Account user, HttpServletRequest request) {
        this.setUsernameFromRequest(user, request);
        this.verifyAccess(user);
        Account existingUser = this.accountsService.getAccount(user.getUsername());
        if (existingUser != null) {
            SecurityUtils.validateUser(user);
            this.accountsService.editUserAccount(user, user.getPassword() != null);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/users/{username}"})
    @Operation(summary="Edit a user", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content})})
    public ResponseEntity<?> editUser(@PathVariable String username, @RequestBody Account user, HttpServletRequest request) {
        return this.editUser(user, request);
    }

    @PatchMapping(value={"/users/**"})
    public ResponseEntity<?> changeUserSettings(@RequestBody Account user, HttpServletRequest request) {
        if (this.securityConfig.hasOverrideAuthority()) {
            try {
                this.securityConfig.setOverrideAuthSettings(user.getAppSettings());
                return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
            }
            catch (RuntimeException e) {
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
            }
        }
        this.setUsernameFromRequest(user, request);
        this.verifyAccess(user);
        Account account = !this.securityConfig.isEnabledSecurity() && "admin".equals(user.getUsername()) ? this.accountsService.getDefaultAdminAccount() : this.accountsService.getAccount(user.getUsername());
        if (account != null) {
            user.setGrantedAuthorities(null);
            user.setUsername(account.getUsername());
            this.accountsService.editUserAccount(user, user.getPassword() != null);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PatchMapping(value={"/users/{username}"})
    @Operation(summary="Change settings for a user", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    public ResponseEntity<?> changeUserSettings(@PathVariable String username, @RequestBody Account user, HttpServletRequest request) {
        return this.changeUserSettings(user, request);
    }

    private void verifyAccess(Account user) {
        boolean isAdmin;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        boolean bl = isAdmin = auth == null || auth.getAuthorities().contains(RoleToSpring.toGrantedAuthority((Role)Role.ROLE_ADMIN));
        if (!isAdmin && !user.getUsername().equals(auth.getName())) {
            throw new AccessDeniedException("You do not have permissions to modify user " + user.getUsername());
        }
    }

    private void setUsernameFromRequest(Account user, HttpServletRequest request) {
        String username = this.getUsernameFromRequest(request, null);
        user.setUsername(username);
    }

    @DeleteMapping(value={"/users/**"})
    public ResponseEntity<?> deleteUser(HttpServletRequest request) {
        if (this.accountsService.isLocal()) {
            String username = this.getUsernameFromRequest(request, null);
            Account existingUser = this.accountsService.getAccount(username);
            if (existingUser != null) {
                this.accountsService.delete(username);
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)(this.accountsService.getImplementationName() + " does not support user removal"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/users/{username}"})
    @Operation(summary="Delete a user", responses={@ApiResponse(responseCode="204", description="No Content", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content})})
    public ResponseEntity<?> deleteUser(@PathVariable String username, HttpServletRequest request) {
        return this.deleteUser(request);
    }

    @GetMapping(value={"/users/*/custom-roles"})
    public ResponseEntity<?> getCustomRolesForUser(HttpServletRequest request) {
        return this.withAccountFromRequestWithSecurity(request, "/custom-roles", account -> {
            List customRoles = account.getGrantedAuthorities().stream().filter(r -> r.startsWith("CUSTOM_")).collect(Collectors.toList());
            return new ResponseEntity(customRoles, (HttpStatusCode)HttpStatus.OK);
        });
    }

    @GetMapping(value={"/users/{username}/custom-roles"})
    @Operation(summary="Retrieve custom roles associated with the user", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    public ResponseEntity<?> getCustomRolesForUser(@PathVariable String username, HttpServletRequest request) {
        return this.getCustomRolesForUser(request);
    }

    private String getUsernameFromRequest(HttpServletRequest request, String urlSuffix) {
        String requestURI;
        try {
            requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GraphDBWorkbenchException(e.getMessage(), (Throwable)e);
        }
        int lastIndex = urlSuffix == null ? requestURI.length() : requestURI.length() - urlSuffix.length();
        return requestURI.substring(requestURI.indexOf("/users/") + 7, lastIndex);
    }

    private ResponseEntity<?> withAccountFromRequestWithSecurity(HttpServletRequest request, String urlSuffix, Function<Account, ResponseEntity<?>> processor) {
        String username = this.getUsernameFromRequest(request, urlSuffix);
        Account user = !this.securityConfig.isEnabledSecurity() && "admin".equals(username) ? this.accountsService.getDefaultAdminAccount() : this.accountsService.getAccount(username);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && !auth.getAuthorities().contains(RoleToSpring.toGrantedAuthority((Role)Role.ROLE_ADMIN)) && !username.equals(auth.getName())) {
            return new ResponseEntity((Object)("You do not have permissions get this user's data: " + username), (HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (user == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return processor.apply(user.clonePasswordless());
    }
}

