/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ontotext.forest.security.provider.openid.OpenIdProviderConfigurationUtils;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.ConfigException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class OpenIdConfig {
    static final String OPENID_ISSUER_PROPERTY = "graphdb.auth.openid.issuer";
    static final String OPENID_USERNAME_CLAIM_PROPERTY = "graphdb.auth.openid.username_claim";
    static final String OPENID_CLIENT_ID_PROPERTY = "graphdb.auth.openid.client_id";
    static final String OPENID_AUTH_FLOW_PROPERTY = "graphdb.auth.openid.auth_flow";
    static final String OPENID_TOKEN_TYPE_PROPERTY = "graphdb.auth.openid.token_type";
    static final String OPENID_TOKEN_ISSUER_PROPERTY = "graphdb.auth.openid.token_issuer";
    static final String OPENID_TOKEN_AUDIENCE_PROPERTY = "graphdb.auth.openid.token_audience";
    static final String OPENID_PROXY_PROPERTY = "graphdb.auth.openid.proxy";
    static final String OPENID_AUTHORIZE_PARAMETERS_PROPERTY = "graphdb.auth.openid.authorize_parameters";
    static final String OPENID_EXTRA_SCOPES_PROPERTY = "graphdb.auth.openid.extra_scopes";
    static final String OPENID_ORACLE_DOMAIN_PROPERTY = "graphdb.auth.openid.oracle_domain";
    static final String OPENID_HEADER_TYPES_PROPERTY = "graphdb.auth.openid.header_types";
    static final String OPENID_WELL_KNOWN_CONFIG_URL_PROPERTY = "graphdb.auth.openid.well_known_config_url";
    static final String OAUTH_ROLES_CLAIM_PROPERTY = "graphdb.auth.oauth.roles_claim";
    static final String OAUTH_ROLES_PREFIX_PROPERTY = "graphdb.auth.oauth.roles_prefix";
    static final String OAUTH_ROLES_SUFFIX_PROPERTY = "graphdb.auth.oauth.roles_suffix";
    static final String OAUTH_BARE_CUSTOM_ROLES_PROPERTY = "graphdb.auth.oauth.bare_custom_roles";
    static final String OAUTH_DEFAULT_ROLES_PROPERTY = "graphdb.auth.oauth.default_roles";
    static final String DATABASE_CASE_INSENSITIVE = "graphdb.auth.database.case_insensitive";
    static final String DEFAULT_HEADER_TYPES = "jwt, at+jwt, null";
    private String issuer;
    private String clientId;
    private String usernameClaim;
    private AuthFlow authFlow;
    private TokenType tokenType;
    private String tokenIssuer;
    private String tokenAudience;
    private String authorizeParameters;
    private String extraScopes;
    private String oracleDomain;
    private boolean proxyOidc;
    private Map<String, Object> openIdProviderConfiguration;

    public static OpenIdConfig newInstance() {
        OpenIdConfig instance = new OpenIdConfig();
        instance.issuer = OpenIdConfig.getPropertyOrThrow(OPENID_ISSUER_PROPERTY);
        instance.clientId = OpenIdConfig.getPropertyOrThrow(OPENID_CLIENT_ID_PROPERTY);
        instance.usernameClaim = OpenIdConfig.getPropertyOrThrow(OPENID_USERNAME_CLAIM_PROPERTY);
        String authFlow = OpenIdConfig.getPropertyOrThrow(OPENID_AUTH_FLOW_PROPERTY);
        try {
            instance.authFlow = AuthFlow.valueOf(authFlow);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Invalid value for graphdb.auth.openid.auth_flow: " + authFlow);
        }
        String tokenType = OpenIdConfig.getPropertyOrThrow(OPENID_TOKEN_TYPE_PROPERTY);
        try {
            instance.tokenType = TokenType.valueOf(tokenType);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Invalid value for graphdb.auth.openid.token_type: " + tokenType);
        }
        instance.tokenIssuer = Config.getProperty((String)OPENID_TOKEN_ISSUER_PROPERTY, (String)instance.issuer);
        instance.tokenAudience = Config.getProperty((String)OPENID_TOKEN_AUDIENCE_PROPERTY, (String)instance.clientId);
        instance.authorizeParameters = Config.getProperty((String)OPENID_AUTHORIZE_PARAMETERS_PROPERTY, (String)"");
        instance.extraScopes = Config.getProperty((String)OPENID_EXTRA_SCOPES_PROPERTY, (String)"").replaceAll("\\s+", " ");
        if (StringUtils.isNotBlank((CharSequence)instance.extraScopes)) {
            HashSet<String> scopes = new HashSet<String>(Arrays.asList(instance.extraScopes.split(" ")));
            if (scopes.contains("openid")) {
                throw new ConfigException("The 'openid' scope may not be specified in the graphdb.auth.openid.extra_scopes property");
            }
            if (scopes.contains("offline_access")) {
                throw new ConfigException("The 'offline_access' scope may not be specified in the graphdb.auth.openid.extra_scopes property");
            }
        } else {
            instance.extraScopes = "";
        }
        instance.oracleDomain = Config.getProperty((String)OPENID_ORACLE_DOMAIN_PROPERTY, (String)"");
        instance.proxyOidc = Config.getPropertyAsBoolean((String)OPENID_PROXY_PROPERTY, (boolean)false);
        String wellKnownUrl = Config.getProperty((String)OPENID_WELL_KNOWN_CONFIG_URL_PROPERTY);
        instance.openIdProviderConfiguration = OpenIdConfig.getOidcConfiguration(instance.issuer, wellKnownUrl);
        return instance;
    }

    private static Map<String, Object> getOidcConfiguration(String oidcIssuerLocation, String wellKnownConfigLocation) {
        if (wellKnownConfigLocation != null) {
            try {
                return OpenIdProviderConfigurationUtils.getConfiguration(oidcIssuerLocation, URI.create(wellKnownConfigLocation));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Unable to fetch OIDC configuration from custom well-known config URL: " + wellKnownConfigLocation, (Throwable)e);
            }
        }
        try {
            return OpenIdProviderConfigurationUtils.getConfigurationForOidcIssuerLocation(oidcIssuerLocation);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Unable to fetch OIDC configuration from issuer URL: " + oidcIssuerLocation, (Throwable)e);
        }
    }

    public static String getPropertyOrThrow(String property) {
        String value = Config.getProperty((String)property);
        if (value == null) {
            throw new RuntimeException("Property " + property + " must not be null.");
        }
        return value;
    }

    public static String getProperty(String property) {
        return Config.getProperty((String)property);
    }

    private OpenIdConfig() {
    }

    @JsonProperty
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonIgnore
    public String getUsernameClaim() {
        return this.usernameClaim;
    }

    @JsonProperty
    public AuthFlow getAuthFlow() {
        return this.authFlow;
    }

    @JsonProperty
    public TokenType getTokenType() {
        return this.tokenType;
    }

    @JsonProperty
    public String getTokenIssuer() {
        return this.tokenIssuer;
    }

    @JsonProperty
    public String getTokenAudience() {
        return this.tokenAudience;
    }

    @JsonProperty
    public String getAuthorizeParameters() {
        return this.authorizeParameters;
    }

    @JsonProperty
    public String getExtraScopes() {
        return this.extraScopes;
    }

    @JsonProperty
    public String getOracleDomain() {
        return this.oracleDomain;
    }

    @JsonProperty
    public boolean isProxyOidc() {
        return this.proxyOidc;
    }

    @JsonProperty
    public String getOidcJwksUri() {
        return this.openIdProviderConfiguration.get("jwks_uri").toString();
    }

    @JsonProperty
    public String getOidcAuthorizationEndpoint() {
        return (String)this.getOpenIdProviderPropertyOrNull("authorization_endpoint");
    }

    @JsonProperty
    public String getOidcEndSessionEndpoint() {
        return (String)this.getOpenIdProviderPropertyOrNull("end_session_endpoint");
    }

    @JsonProperty
    public String getOidcTokenEndpoint() {
        return (String)this.getOpenIdProviderPropertyOrNull("token_endpoint");
    }

    @JsonProperty
    public List<Object> getOidcScopesSupported() {
        return (List)this.getOpenIdProviderPropertyOrNull("scopes_supported");
    }

    @JsonIgnore
    public Map<String, Object> getOpenIdProviderConfiguration() {
        return this.openIdProviderConfiguration;
    }

    @JsonIgnore
    public Set<String> getHeaderTokenTypes() {
        return Stream.of(Config.getProperty((String)OPENID_HEADER_TYPES_PROPERTY, (String)DEFAULT_HEADER_TYPES).split(",\\s*")).collect(Collectors.toSet());
    }

    private <T> T getOpenIdProviderPropertyOrNull(String property) {
        Object value = this.openIdProviderConfiguration.get(property);
        return (T)(value == null ? null : value);
    }

    static enum AuthFlow {
        code,
        code_no_pkce,
        implicit;

    }

    static enum TokenType {
        id,
        access;

    }
}

