/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.persistence.UsersConfig;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.AuthenticationMethod;
import com.ontotext.graphdb.Config;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;

public class OAuthAccountsService
implements AccountsService,
AuthenticationMethod.OpenId {
    private static final String PERSISTENCE_PROPERTY = "openid_users";
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthAccountsService.class);
    private static final String DEFAULT_ADMIN_USER = "";
    private final boolean case_insensitive = Config.getPropertyAsBoolean((String)"graphdb.auth.database.case_insensitive", (boolean)false);
    @Autowired
    private UsersConfig usersConfig;

    public OAuthAccountsService() {
    }

    public OAuthAccountsService(UsersConfig usersConfig) {
        this.usersConfig = usersConfig;
    }

    @PostConstruct
    public void init() {
        if (this.getAccount(DEFAULT_ADMIN_USER) == null) {
            Account account = new Account();
            account.setUsername(DEFAULT_ADMIN_USER);
            account.setPassword(DEFAULT_ADMIN_USER);
            account.setAppSettings(this.getDefaultSettings());
            this.saveUser(account);
        }
    }

    private Map<String, Account> getUsers() {
        return this.usersConfig.getMap(PERSISTENCE_PROPERTY, Account.class);
    }

    private void saveUsers(Map<String, Account> users) {
        this.usersConfig.updateMapEntries(PERSISTENCE_PROPERTY, Account.class, users);
    }

    public void editUserAccount(Account user, boolean updatePassword) {
        Account userFromDB = this.getAccountOrThrow(user.getUsername());
        userFromDB.setAppSettings(user.getAppSettings());
        this.saveUser(userFromDB);
    }

    @VisibleForTesting
    public void saveUser(Account userFromDB) {
        String username = this.case_insensitive ? userFromDB.getUsername().toLowerCase(Locale.ROOT) : userFromDB.getUsername();
        Map<String, Account> users = this.getUsers();
        users.put(username, userFromDB);
        this.saveUsers(users);
    }

    public void addNewUser(Account user) {
        throw new IllegalStateException("OAuth does not support adding users directly.");
    }

    public void delete(String username) {
        throw new IllegalStateException("OAuth does not support removing users directly.");
    }

    public Collection<Account> getAll() {
        return this.getUsers().values().stream().filter(a -> !a.getUsername().equals(DEFAULT_ADMIN_USER)).collect(Collectors.toList());
    }

    @Nullable
    public Account getAccount(String username) {
        return this.getUsers().get(this.case_insensitive ? username.toLowerCase(Locale.ROOT) : username);
    }

    public Account getDefaultAdminAccount() {
        return this.getAccount(DEFAULT_ADMIN_USER);
    }

    public boolean isLocal() {
        return false;
    }

    public AuthenticatedUser loadUserByUsername(String username, Collection<GrantedAuthority> authorities) {
        if (authorities == null) {
            throw new IllegalArgumentException("Overriding authorities must be provided");
        }
        Account account = this.getAccount(username);
        if (account == null) {
            account = new Account();
            account.setUsername(username);
            account.setAppSettings(this.getDefaultSettings());
            this.saveUser(account);
        }
        return new AuthenticatedUser(username, DEFAULT_ADMIN_USER, authorities, true, account.getAppSettings());
    }

    public String getImplementationName() {
        return "OAuth";
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return null;
    }
}

