/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.ldap;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.security.Role;

class LdapConfig {
    static final String LDAP_URL_PROPERTY = "graphdb.auth.ldap.url";
    static final String LDAP_USER_BASE_PROPERTY = "graphdb.auth.ldap.user.search.base";
    static final String LDAP_USER_FILTER_PROPERTY = "graphdb.auth.ldap.user.search.filter";
    static final String LDAP_USER_SUBTREE_PROPERTY = "graphdb.auth.ldap.user.search.subtree";
    static final String LDAP_ROLE_BASE_PROPERTY = "graphdb.auth.ldap.role.search.base";
    static final String LDAP_ROLE_FILTER_PROPERTY = "graphdb.auth.ldap.role.search.filter";
    static final String LDAP_ROLE_SUBTREE_PROPERTY = "graphdb.auth.ldap.role.search.subtree";
    static final String LDAP_ROLE_ATTRIBUTE_PROPERTY = "graphdb.auth.ldap.role.search.attribute";
    static final String LDAP_ROLE_ADMIN_PROPERTY = "graphdb.auth.ldap.role.map.administrator";
    static final String LDAP_ROLE_REPOMANAGER_PROPERTY = "graphdb.auth.ldap.role.map.repositoryManager";
    static final String LDAP_ROLE_REPOSITORY_READ_PREFIX_REPOSITORY = "graphdb.auth.ldap.role.map.repository.read.";
    static final String LDAP_ROLE_REPOSITORY_WRITE_PREFIX_REPOSITORY = "graphdb.auth.ldap.role.map.repository.write.";
    static final String LDAP_READ_REPO_BASE_PROPERTY = "graphdb.auth.ldap.repository.read.base";
    static final String LDAP_READ_REPO_FILTER_PROPERTY = "graphdb.auth.ldap.repository.read.filter";
    static final String LDAP_READ_REPO_ATTRIBUTE_PROPERTY = "graphdb.auth.ldap.repository.read.attribute";
    static final String LDAP_WRITE_REPO_BASE_PROPERTY = "graphdb.auth.ldap.repository.write.base";
    static final String LDAP_WRITE_REPO_FILTER_PROPERTY = "graphdb.auth.ldap.repository.write.filter";
    static final String LDAP_WRITE_REPO_ATTRIBUTE_PROPERTY = "graphdb.auth.ldap.repository.write.attribute";
    static final String LDAP_ROLE_ANY_ROLE_PREFIX = "graphdb.auth.ldap.role.map.graphdb.";
    static final String LDAP_ROLE_GRAPHDB_BASE_PROPERTY = "graphdb.auth.ldap.role.graphdb.base";
    static final String LDAP_ROLE_GRAPHDB_FILTER_PROPERTY = "graphdb.auth.ldap.role.graphdb.filter";
    static final String LDAP_ROLE_GRAPHDB_ATTRIBUTE_PROPERTY = "graphdb.auth.ldap.role.graphdb.attribute";
    static final String LDAP_BIND_USER_DN_PROPERTY = "graphdb.auth.ldap.bind.userDn";
    static final String LDAP_BIND_USER_DN_PASS_PROPERTY = "graphdb.auth.ldap.bind.userDn.password";

    LdapConfig() {
    }

    static String getPropertyOrThrow(String property) {
        String value = Config.getProperty((String)property);
        if (value == null) {
            throw new RuntimeException("Property " + property + " must not be null.");
        }
        return value;
    }

    public static String normalizeRole(String role) {
        if (!role.isEmpty()) {
            if (!((role = LdapConfig.capitalizeRole(role)).startsWith("READ_REPO_") && role.length() > "READ_REPO_".length() || role.startsWith("WRITE_REPO_") && role.length() > "WRITE_REPO_".length() || role.startsWith("CUSTOM_") && role.length() > "CUSTOM_".length())) {
                try {
                    Role.valueOf((String)role);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return role;
        }
        return null;
    }

    private static String capitalizeRole(String role) {
        String capitalizedRole = role.toUpperCase();
        if (capitalizedRole.startsWith("READ_REPO_")) {
            return Role.Repo.readForRepo((String)role.substring("READ_REPO_".length()));
        }
        if (capitalizedRole.startsWith("WRITE_REPO_")) {
            return Role.Repo.writeForRepo((String)role.substring("WRITE_REPO_".length()));
        }
        return capitalizedRole;
    }
}

