/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.custom.roles;

import com.ontotext.forest.security.custom.roles.CustomRoleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest/security/custom-roles"})
@RestController
@Tag(name="Custom Roles Management", description="Manage custom user roles")
public class CustomRoleController {
    public static final String MAPPING = "/rest/security/custom-roles";
    @Autowired
    private CustomRoleService customRoleService;

    @GetMapping
    @Operation(summary="Get custom roles", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    public Map<String, List<String>> getAllRoles() {
        return this.customRoleService.getAllRoles();
    }

    @PutMapping
    @Operation(summary="Set custom roles to users", responses={@ApiResponse(responseCode="204", description="No content", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    public void setAllRoles(@RequestBody Map<String, Set<String>> rolesWithUsers) {
        this.customRoleService.setAllRoles(rolesWithUsers);
    }

    @GetMapping(value={"/{roleName}"})
    @Operation(summary="Get users associated with custom role", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Set.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    public Set<String> getUsersForRole(@PathVariable String roleName) {
        return this.customRoleService.getUsersForRole(roleName);
    }

    @PutMapping(value={"/{roleName}"})
    @Operation(summary="Set custom role to users", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    public void setUsersForRole(@PathVariable String roleName, @RequestBody Set<String> usernames) {
        this.customRoleService.setUsersForRole(usernames, roleName);
    }

    @PostMapping(value={"/{roleName}"})
    @Operation(summary="Add custom role to users", responses={@ApiResponse(responseCode="200", description="OK", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    public void addUsersToRole(@PathVariable String roleName, @RequestBody Set<String> usernames) {
        this.customRoleService.addUsersToRole(usernames, roleName);
    }

    @DeleteMapping(value={"/{roleName}"})
    @Operation(summary="Delete custom role from users", responses={@ApiResponse(responseCode="204", description="No content", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUsersFromRole(@PathVariable String roleName, @RequestBody Set<String> usernames) {
        this.customRoleService.deleteUsersFromRole(usernames, roleName);
    }
}

