/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.security.audit.AuditUtils;
import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.graphdb.security.Role;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

public class RepositoryAccessVoter
implements AccessDecisionVoter<FilterInvocation> {
    @Autowired
    private SemanticDataManagement dataManagement;

    public boolean supports(ConfigAttribute attribute) {
        String attr = attribute.getAttribute();
        return "READ_REPO".equals(attr) || "WRITE_REPO".equals(attr);
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, FilterInvocation object, Collection<ConfigAttribute> attributes) {
        HttpServletRequest request = object.getRequest();
        SemanticLocation location = this.dataManagement.getCurrentLocation(request);
        if (location != null) {
            for (ConfigAttribute attribute : attributes) {
                SemanticRepository repository;
                if (!this.supports(attribute)) continue;
                String requestURI = request.getRequestURI().substring(request.getContextPath().length());
                String repositoryId = this.getRepositoryIdFromRequestURI(requestURI);
                if (repositoryId == null && (repository = this.dataManagement.getCurrentRepository(request)) != null) {
                    repositoryId = repository.getRepositoryID();
                }
                if (repositoryId == null) continue;
                String locationHeader = request.getHeader("X-GraphDB-Repository-Location");
                repositoryId = SecurityUtils.getRepoIdLocationCompositeKey(repositoryId, locationHeader);
                String role = attribute.getAttribute();
                if (AuditUtils.shouldAuditOperation(role)) {
                    AuditUtils.markRequestForAudit(request);
                }
                if (Role.Repo.hasAccess((Collection)authentication.getAuthorities(), GrantedAuthority::getAuthority, (String)repositoryId, (boolean)"WRITE_REPO".equals(role))) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    public static int voteForRepo(Collection<? extends GrantedAuthority> authorities, String role, String currentRepository, HttpServletRequest request) {
        boolean result;
        if (AuditUtils.shouldAuditOperation(role)) {
            AuditUtils.markRequestForAudit(request);
        }
        return (result = Role.Repo.hasAccess(authorities, GrantedAuthority::getAuthority, (String)currentRepository, (boolean)"WRITE_REPO".equals(role))) ? 1 : -1;
    }

    @Nullable
    private String getRepositoryIdFromRequestURI(String requestURI) {
        String[] URIsContainingRepoIds;
        for (String URI2 : URIsContainingRepoIds = new String[]{"/repositories", "/rest/repositories"}) {
            String[] paths;
            String pathInfo;
            if (!requestURI.startsWith(URI2) || requestURI.length() <= URI2.length() || !StringUtils.isNotEmpty((CharSequence)(pathInfo = requestURI.replaceFirst(URI2, ""))) || pathInfo.equals("/") || (paths = pathInfo.substring(1).split("/")).length <= 0) continue;
            return paths[0];
        }
        return null;
    }
}

