/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.core.AccountsService;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.ConfigException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;
import org.springframework.util.StringUtils;

public class KerberosAuthenticationProviderFactory {
    private static final String KERBEROS_KEYTAB_PROPERTY_NAME = "graphdb.auth.kerberos.keytab";
    private static final String KERBEROS_PRINCIPAL_PROPERTY_NAME = "graphdb.auth.kerberos.principal";
    private static final String KERBEROS_DEBUG_PROPERTY_NAME = "graphdb.auth.kerberos.debug";

    public static KerberosServiceAuthenticationProvider createAuthenticationProvider(AccountsService accountsService) throws Exception {
        Path kerberosKeytab = Paths.get(Config.getProperty((String)KERBEROS_KEYTAB_PROPERTY_NAME), new String[0]);
        if (!kerberosKeytab.isAbsolute()) {
            kerberosKeytab = Paths.get(Config.getConfDirectory(), new String[0]).resolve(kerberosKeytab);
        }
        if (!Files.isRegularFile(kerberosKeytab, new LinkOption[0]) || !Files.isReadable(kerberosKeytab)) {
            throw new ConfigException("Kerberos keytab file is not readable: " + String.valueOf(kerberosKeytab));
        }
        String kerberosPrincipal = Config.getProperty((String)KERBEROS_PRINCIPAL_PROPERTY_NAME);
        int atPosRealm = kerberosPrincipal.indexOf(64);
        String kerberosRealm = atPosRealm > 0 ? kerberosPrincipal.substring(atPosRealm + 1) : null;
        if (StringUtils.isEmpty(kerberosRealm)) {
            throw new ConfigException("Kerberos principal must contain the Kerberos realm: " + kerberosPrincipal);
        }
        boolean kerberosDebug = Config.getPropertyAsBoolean((String)KERBEROS_DEBUG_PROPERTY_NAME, (boolean)false);
        SunJaasKerberosTicketValidator kerberosTicketValidator = new SunJaasKerberosTicketValidator();
        kerberosTicketValidator.setServicePrincipal(kerberosPrincipal);
        kerberosTicketValidator.setKeyTabLocation((Resource)new FileSystemResource(kerberosKeytab));
        kerberosTicketValidator.setDebug(kerberosDebug);
        kerberosTicketValidator.afterPropertiesSet();
        KerberosServiceAuthenticationProvider kerberosServiceAuthProvider = new KerberosServiceAuthenticationProvider();
        kerberosServiceAuthProvider.setTicketValidator((KerberosTicketValidator)kerberosTicketValidator);
        kerberosServiceAuthProvider.setUserDetailsService(username -> {
            int atPos = username.indexOf(64);
            if (atPos < 1) {
                throw new UsernameNotFoundException("Kerberos username or realm missing");
            }
            if (username.indexOf(kerberosRealm, atPos + 1) != atPos + 1 || username.length() > atPos + 1 + kerberosRealm.length()) {
                throw new UsernameNotFoundException("Kerberos username from unexpected realm: " + username);
            }
            return accountsService.loadUserByUsername(username.substring(0, atPos));
        });
        kerberosServiceAuthProvider.afterPropertiesSet();
        return kerberosServiceAuthProvider;
    }
}

