/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class CachingDelegatingPasswordEncoder
extends DelegatingPasswordEncoder {
    private Cache<String, CharSequence> passwordCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(100L).expireAfterWrite(60L, TimeUnit.MINUTES).build();

    public CachingDelegatingPasswordEncoder(String idForEncode, Map<String, PasswordEncoder> idToPasswordEncoder) {
        super(idForEncode, idToPasswordEncoder);
    }

    public boolean matches(CharSequence rawPassword, String prefixEncodedPassword) {
        CharSequence cachedEncodedPassword = (CharSequence)this.passwordCache.getIfPresent((Object)prefixEncodedPassword);
        if (rawPassword.equals(cachedEncodedPassword)) {
            return true;
        }
        boolean result = super.matches(rawPassword, prefixEncodedPassword);
        if (result) {
            this.passwordCache.put((Object)prefixEncodedPassword, (Object)rawPassword);
        }
        return result;
    }
}

