/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.audit.AuditUtils;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.security.Role;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import jakarta.inject.Named;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterChainProxy;

@Named
public class AdminDelegatingFilterProxy
implements Filter {
    private static final String AUTHENTICATED_USER_ENDPOINT = "/rest/security/authenticated-user";
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired(required=false)
    private FilterChainProxy securityFilter;

    public AdminDelegatingFilterProxy() {
        final GraphDBHTTPContext.User defaultUser = GraphDBHTTPContext.getAuthenticatedUser();
        GraphDBHTTPContext.setAuthenticatedUser((GraphDBHTTPContext.User)new GraphDBHTTPContext.User(){

            public String getUsername() {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                if (authentication != null) {
                    return authentication.getName();
                }
                return defaultUser.getUsername();
            }

            public Stream<String> getRoles() {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                if (authentication != null) {
                    Object principal = authentication.getPrincipal();
                    Collection authorities = principal instanceof AuthenticatedUser ? ((AuthenticatedUser)principal).getExpandedAuthorities() : authentication.getAuthorities();
                    return authorities.stream().map(GrantedAuthority::getAuthority);
                }
                return defaultUser.getRoles();
            }

            public boolean hasRole(String role) {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                if (authentication != null) {
                    return authentication.getAuthorities().stream().anyMatch(auth -> Role.matches((String)auth.toString(), (String)role) || role.equals(auth.toString()));
                }
                return defaultUser.hasRole(role);
            }
        });
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        AuditUtils.appendXRequestIdHeaders((HttpServletRequest)request, (HttpServletResponse)response);
        SystemStatisticsCollector.getInstance().trackUserAgentAndCookie((HttpServletRequest)request);
        if (this.securityConfig.hasToCheckAuthentication() && this.securityFilter != null) {
            if (((HttpServletRequest)request).getRequestURI().equals(AUTHENTICATED_USER_ENDPOINT)) {
                request.setAttribute("graphdb-reauthorize", (Object)Boolean.TRUE);
            }
            this.securityFilter.doFilter(request, response, filterChain);
        } else {
            filterChain.doFilter(request, response);
        }
    }
}

