/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;

public class SerializerStringDelta2
implements GroupSerializer<String> {
    @Override
    public StringArrayKeys valueArrayDeserialize(DataInput2 in2, int size2) throws IOException {
        int[] offsets = new int[size2];
        int old = 0;
        for (int i = 0; i < size2; ++i) {
            offsets[i] = old += in2.unpackInt();
        }
        int prefixLen = in2.unpackInt();
        boolean useUnicode = 0 != (prefixLen & 1);
        return useUnicode ? new CharArrayKeys(in2, offsets, prefixLen) : new ByteArrayKeys(in2, offsets, prefixLen >>>= 1);
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        StringArrayKeys keys = (StringArrayKeys)vals;
        int offset = 0;
        for (int o : keys.getOffset()) {
            out.packInt(o - offset);
            offset = o;
        }
        int unicode = keys.hasUnicodeChars() ? 1 : 0;
        int prefixLen = keys.commonPrefixLen();
        out.packInt(prefixLen << 1 | unicode);
        keys.serialize(out, prefixLen);
    }

    @Override
    public StringArrayKeys valueArrayCopyOfRange(Object vals, int from, int to) {
        return ((StringArrayKeys)vals).copyOfRange(from, to);
    }

    @Override
    public StringArrayKeys valueArrayDeleteValue(Object vals, int pos) {
        Object[] vv = this.valueArrayToArray(vals);
        vv = DataIO.arrayDelete(vv, pos, 1);
        return this.valueArrayFromArray(vv);
    }

    @Override
    public StringArrayKeys valueArrayEmpty() {
        return new ByteArrayKeys(new int[0], new byte[0]);
    }

    @Override
    public StringArrayKeys valueArrayFromArray(Object[] keys) {
        if (keys.length == 0) {
            return this.valueArrayEmpty();
        }
        boolean unicode = false;
        int[] offsets = new int[keys.length];
        int old = 0;
        for (int i = 0; i < keys.length; ++i) {
            String b = (String)keys[i];
            if (!unicode && ByteArrayKeys.containsUnicode(b)) {
                unicode = true;
            }
            offsets[i] = old += b.length();
        }
        return unicode ? new CharArrayKeys(offsets, keys) : new ByteArrayKeys(offsets, keys);
    }

    @Override
    public String valueArrayGet(Object vals, int pos) {
        return ((StringArrayKeys)vals).getKeyString(pos);
    }

    @Override
    public Object valueArrayPut(Object vals, int pos, String newValue) {
        return ((StringArrayKeys)vals).putKey(pos, newValue);
    }

    @Override
    public int valueArraySearch(Object keys, String key) {
        Object[] v = this.valueArrayToArray(keys);
        return Arrays.binarySearch(v, key, this);
    }

    @Override
    public int valueArraySearch(Object keys, String key, Comparator comparator) {
        Object[] v = this.valueArrayToArray(keys);
        return Arrays.binarySearch(v, key, comparator);
    }

    @Override
    public int valueArraySize(Object vals) {
        return ((StringArrayKeys)vals).length();
    }

    public StringArrayKeys valueArrayUpdateVal(Object vals, int pos, String newValue) {
        Object[] v = this.valueArrayToArray(vals);
        v[pos] = newValue;
        return this.valueArrayFromArray(v);
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public void serialize(@NotNull DataOutput2 out, @NotNull String value) throws IOException {
        Serializer.STRING.serialize(out, value);
    }

    @Override
    public String deserialize(@NotNull DataInput2 input, int available) throws IOException {
        return (String)Serializer.STRING.deserialize(input, available);
    }

    @Override
    public int hashCode(@NotNull String s, int seed) {
        return Serializer.STRING.hashCode(s, seed);
    }

    public static final class CharArrayKeys
    implements StringArrayKeys {
        final int[] offset;
        final char[] array;

        CharArrayKeys(int[] offset, char[] array) {
            this.offset = offset;
            this.array = array;
            if (array.length != 0 && array.length != offset[offset.length - 1]) {
                throw new DBException.DataCorruption("inconsistent array size");
            }
        }

        public CharArrayKeys(DataInput2 in, int[] offsets, int prefixLen) throws IOException {
            this.offset = offsets;
            this.array = new char[offsets[offsets.length - 1]];
            this.inReadFully(in, 0, prefixLen);
            for (int i = 0; i < offsets.length - 1; ++i) {
                System.arraycopy(this.array, 0, this.array, offsets[i], prefixLen);
            }
            int offset = prefixLen;
            for (int o : offsets) {
                this.inReadFully(in, offset, o);
                offset = o + prefixLen;
            }
        }

        CharArrayKeys(int[] offsets, Object[] keys) {
            this.offset = offsets;
            this.array = new char[offsets[offsets.length - 1]];
            int bbOffset = 0;
            for (Object key : keys) {
                String str = (String)key;
                str.getChars(0, str.length(), this.array, bbOffset);
                bbOffset += str.length();
            }
        }

        private void inReadFully(DataInput in, int from, int to) throws IOException {
            for (int i = from; i < to; ++i) {
                this.array[i] = (char)DataIO.unpackInt(in);
            }
        }

        @Override
        public int commonPrefixLen() {
            int lenMinus1 = this.offset.length - 1;
            int ret2 = 0;
            while (this.offset[0] != ret2) {
                char byt = this.array[ret2];
                for (int i = 0; i < lenMinus1; ++i) {
                    int o = this.offset[i] + ret2;
                    if (o != this.offset[i + 1] && this.array[o] == byt) continue;
                    return ret2;
                }
                ++ret2;
            }
            return ret2;
        }

        @Override
        public int length() {
            return this.offset.length;
        }

        @Override
        public int[] getOffset() {
            return this.offset;
        }

        @Override
        public CharArrayKeys deleteKey(int pos) {
            int split = pos == 0 ? 0 : this.offset[pos - 1];
            int next = this.offset[pos];
            char[] bb = new char[this.array.length - (next - split)];
            int[] offsets = new int[this.offset.length - 1];
            System.arraycopy(this.array, 0, bb, 0, split);
            System.arraycopy(this.array, next, bb, split, this.array.length - next);
            int minus = 0;
            int plusI = 0;
            for (int i = 0; i < offsets.length; ++i) {
                if (i == pos) {
                    plusI = 1;
                    minus = next - split;
                }
                offsets[i] = this.offset[i + plusI] - minus;
            }
            return new CharArrayKeys(offsets, bb);
        }

        @Override
        public CharArrayKeys copyOfRange(int from, int to) {
            int start = from == 0 ? 0 : this.offset[from - 1];
            int end = to == 0 ? 0 : this.offset[to - 1];
            char[] bb = Arrays.copyOfRange(this.array, start, end);
            int[] offsets = new int[to - from];
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = this.offset[i + from] - start;
            }
            return new CharArrayKeys(offsets, bb);
        }

        @Override
        public CharArrayKeys putKey(int pos, String newKey) {
            int strLen = newKey.length();
            char[] bb = new char[this.array.length + strLen];
            int split1 = pos == 0 ? 0 : this.offset[pos - 1];
            System.arraycopy(this.array, 0, bb, 0, split1);
            newKey.getChars(0, strLen, bb, split1);
            System.arraycopy(this.array, split1, bb, split1 + strLen, this.array.length - split1);
            int[] offsets = new int[this.offset.length + 1];
            int plus = 0;
            int plusI = 0;
            for (int i = 0; i < this.offset.length; ++i) {
                if (i == pos) {
                    plus = strLen;
                    plusI = 1;
                }
                offsets[i + plusI] = this.offset[i] + plus;
            }
            offsets[pos] = split1 + strLen;
            return new CharArrayKeys(offsets, bb);
        }

        public static StringArrayKeys putKey(ByteArrayKeys kk, int pos, String newKey) {
            int i;
            int strLen = newKey.length();
            char[] bb = new char[kk.array.length + strLen];
            int split1 = pos == 0 ? 0 : kk.offset[pos - 1];
            for (i = 0; i < split1; ++i) {
                bb[i] = (char)kk.array[i];
            }
            newKey.getChars(0, strLen, bb, split1);
            for (i = split1; i < kk.array.length; ++i) {
                bb[i + strLen] = (char)kk.array[i];
            }
            int[] offsets = new int[kk.offset.length + 1];
            int plus = 0;
            int plusI = 0;
            for (int i2 = 0; i2 < kk.offset.length; ++i2) {
                if (i2 == pos) {
                    plus = strLen;
                    plusI = 1;
                }
                offsets[i2 + plusI] = kk.offset[i2] + plus;
            }
            offsets[pos] = split1 + strLen;
            return new CharArrayKeys(offsets, bb);
        }

        @Override
        public int compare(int pos1, String string) {
            int strLen = string.length();
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = 0;
            int len1 = this.offset[pos1] - start1;
            int len = Math.min(len1, strLen);
            while (len-- != 0) {
                char b2;
                char b1;
                if ((b1 = this.array[start1++]) == (b2 = string.charAt(start2++))) continue;
                return b1 - b2;
            }
            return len1 - strLen;
        }

        @Override
        public int compare(int pos1, int pos2) {
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = pos2 == 0 ? 0 : this.offset[pos2 - 1];
            int len1 = this.offset[pos1] - start1;
            int len2 = this.offset[pos2] - start2;
            int len = Math.min(len1, len2);
            while (len-- != 0) {
                char b2;
                char b1;
                if ((b1 = this.array[start1++]) == (b2 = this.array[start2++])) continue;
                return b1 - b2;
            }
            return len1 - len2;
        }

        @Override
        public String getKeyString(int pos) {
            int from = pos == 0 ? 0 : this.offset[pos - 1];
            int len = this.offset[pos] - from;
            return new String(this.array, from, len);
        }

        @Override
        public boolean hasUnicodeChars() {
            for (char c : this.array) {
                if (c <= '\u007f') continue;
                return true;
            }
            return false;
        }

        @Override
        public void serialize(DataOutput out, int prefixLen) throws IOException {
            this.outWrite(out, 0, prefixLen);
            int aa = prefixLen;
            for (int o : this.offset) {
                this.outWrite(out, aa, o);
                aa = o + prefixLen;
            }
        }

        private void outWrite(DataOutput out, int from, int to) throws IOException {
            for (int i = from; i < to; ++i) {
                DataIO.packInt(out, this.array[i]);
            }
        }
    }

    public static final class ByteArrayKeys
    implements StringArrayKeys {
        final int[] offset;
        final byte[] array;

        ByteArrayKeys(int[] offset, byte[] array) {
            this.offset = offset;
            this.array = array;
            if (array.length != 0 && array.length != offset[offset.length - 1]) {
                throw new DBException.DataCorruption("inconsistent array size");
            }
        }

        ByteArrayKeys(DataInput2 in, int[] offsets, int prefixLen) throws IOException {
            this.offset = offsets;
            this.array = new byte[offsets[offsets.length - 1]];
            in.readFully(this.array, 0, prefixLen);
            for (int i = 0; i < offsets.length - 1; ++i) {
                System.arraycopy(this.array, 0, this.array, offsets[i], prefixLen);
            }
            int offset = prefixLen;
            for (int o : offsets) {
                in.readFully(this.array, offset, o - offset);
                offset = o + prefixLen;
            }
        }

        ByteArrayKeys(int[] offsets, Object[] keys) {
            this.offset = offsets;
            this.array = new byte[offsets[offsets.length - 1]];
            int bbOffset = 0;
            for (Object key : keys) {
                String str = (String)key;
                for (int j = 0; j < str.length(); ++j) {
                    this.array[bbOffset++] = (byte)str.charAt(j);
                }
            }
        }

        @Override
        public int commonPrefixLen() {
            int lenMinus1 = this.offset.length - 1;
            int ret2 = 0;
            while (this.offset[0] != ret2) {
                byte byt = this.array[ret2];
                for (int i = 0; i < lenMinus1; ++i) {
                    int o = this.offset[i] + ret2;
                    if (o != this.offset[i + 1] && this.array[o] == byt) continue;
                    return ret2;
                }
                ++ret2;
            }
            return ret2;
        }

        @Override
        public int length() {
            return this.offset.length;
        }

        @Override
        public int[] getOffset() {
            return this.offset;
        }

        @Override
        public ByteArrayKeys deleteKey(int pos) {
            int split = pos == 0 ? 0 : this.offset[pos - 1];
            int next = this.offset[pos];
            byte[] bb = new byte[this.array.length - (next - split)];
            int[] offsets = new int[this.offset.length - 1];
            System.arraycopy(this.array, 0, bb, 0, split);
            System.arraycopy(this.array, next, bb, split, this.array.length - next);
            int minus = 0;
            int plusI = 0;
            for (int i = 0; i < offsets.length; ++i) {
                if (i == pos) {
                    plusI = 1;
                    minus = next - split;
                }
                offsets[i] = this.offset[i + plusI] - minus;
            }
            return new ByteArrayKeys(offsets, bb);
        }

        @Override
        public ByteArrayKeys copyOfRange(int from, int to) {
            int start = from == 0 ? 0 : this.offset[from - 1];
            int end = to == 0 ? 0 : this.offset[to - 1];
            byte[] bb = Arrays.copyOfRange(this.array, start, end);
            int[] offsets = new int[to - from];
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = this.offset[i + from] - start;
            }
            return new ByteArrayKeys(offsets, bb);
        }

        @Override
        public StringArrayKeys putKey(int pos, String newKey) {
            if (ByteArrayKeys.containsUnicode(newKey)) {
                return CharArrayKeys.putKey(this, pos, newKey);
            }
            return this.putKey(pos, newKey.getBytes());
        }

        static final boolean containsUnicode(String str) {
            int strLen = str.length();
            for (int i = 0; i < strLen; ++i) {
                if (str.charAt(i) <= '\u007f') continue;
                return true;
            }
            return false;
        }

        public ByteArrayKeys putKey(int pos, byte[] newKey) {
            byte[] bb = new byte[this.array.length + newKey.length];
            int split1 = pos == 0 ? 0 : this.offset[pos - 1];
            System.arraycopy(this.array, 0, bb, 0, split1);
            System.arraycopy(newKey, 0, bb, split1, newKey.length);
            System.arraycopy(this.array, split1, bb, split1 + newKey.length, this.array.length - split1);
            int[] offsets = new int[this.offset.length + 1];
            int plus = 0;
            int plusI = 0;
            for (int i = 0; i < this.offset.length; ++i) {
                if (i == pos) {
                    plus = newKey.length;
                    plusI = 1;
                }
                offsets[i + plusI] = this.offset[i] + plus;
            }
            offsets[pos] = split1 + newKey.length;
            return new ByteArrayKeys(offsets, bb);
        }

        public byte[] getKey(int pos) {
            int from = pos == 0 ? 0 : this.offset[pos - 1];
            int to = this.offset[pos];
            return Arrays.copyOfRange(this.array, from, to);
        }

        public int compare(int pos1, byte[] string) {
            int strLen = string.length;
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = 0;
            int len1 = this.offset[pos1] - start1;
            int len = Math.min(len1, strLen);
            while (len-- != 0) {
                int b2;
                int b1;
                if ((b1 = this.array[start1++] & 0xFF) == (b2 = string[start2++] & 0xFF)) continue;
                return b1 - b2;
            }
            return len1 - strLen;
        }

        @Override
        public int compare(int pos1, String string) {
            int strLen = string.length();
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = 0;
            int len1 = this.offset[pos1] - start1;
            int len = Math.min(len1, strLen);
            while (len-- != 0) {
                char b2;
                int b1;
                if ((b1 = this.array[start1++] & 0xFF) == (b2 = string.charAt(start2++))) continue;
                return b1 - b2;
            }
            return len1 - strLen;
        }

        @Override
        public int compare(int pos1, int pos2) {
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = pos2 == 0 ? 0 : this.offset[pos2 - 1];
            int len1 = this.offset[pos1] - start1;
            int len2 = this.offset[pos2] - start2;
            int len = Math.min(len1, len2);
            while (len-- != 0) {
                int b2;
                int b1;
                if ((b1 = this.array[start1++] & 0xFF) == (b2 = this.array[start2++] & 0xFF)) continue;
                return b1 - b2;
            }
            return len1 - len2;
        }

        @Override
        public String getKeyString(int pos) {
            byte[] ret2 = this.getKey(pos);
            StringBuilder sb = new StringBuilder(ret2.length);
            for (byte b : ret2) {
                sb.append((char)b);
            }
            return sb.toString();
        }

        @Override
        public boolean hasUnicodeChars() {
            return false;
        }

        @Override
        public void serialize(DataOutput out, int prefixLen) throws IOException {
            out.write(this.array, 0, prefixLen);
            int aa = prefixLen;
            for (int o : this.offset) {
                out.write(this.array, aa, o - aa);
                aa = o + prefixLen;
            }
        }
    }

    public static interface StringArrayKeys {
        public int commonPrefixLen();

        public int length();

        public int[] getOffset();

        public StringArrayKeys deleteKey(int var1);

        public StringArrayKeys copyOfRange(int var1, int var2);

        public StringArrayKeys putKey(int var1, String var2);

        public int compare(int var1, String var2);

        public int compare(int var1, int var2);

        public String getKeyString(int var1);

        public boolean hasUnicodeChars();

        public void serialize(DataOutput var1, int var2) throws IOException;
    }
}

