/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerEightByte;

public class SerializerDate
extends SerializerEightByte<Date> {
    @Override
    public void serialize(DataOutput2 out, Date value) throws IOException {
        out.writeLong(value.getTime());
    }

    @Override
    public Date deserialize(DataInput2 in, int available) throws IOException {
        return new Date(in.readLong());
    }

    @Override
    protected Date unpack(long l) {
        return new Date(l);
    }

    @Override
    protected long pack(Date l) {
        return l.getTime();
    }

    @Override
    public final int valueArraySearch(Object keys, Date key) {
        long time = key.getTime();
        return Arrays.binarySearch((long[])keys, time);
    }
}

