/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.helper.tuple;

import com.ontotext.graphdb.helper.tuple.InternalValuesTuple;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;

public interface ValuesTuple
extends BNode,
Iterable<Value> {
    public static ValuesTuple fromValue(Value value) {
        return value instanceof ValuesTuple ? (ValuesTuple)value : new InternalValuesTuple(Collections.singletonList(value));
    }

    public List<Value> getValues();

    default public String toDelimitedString(String delimiter) {
        return this.getValues().stream().map(value -> value != null ? value.stringValue() : "").collect(Collectors.joining(delimiter));
    }

    default public List<String> toDelimitedTable(String columnDelimiter) {
        return this.getValues().stream().filter(Objects::nonNull).map(value -> ValuesTuple.fromValue(value).toDelimitedString(columnDelimiter)).collect(Collectors.toList());
    }
}

