/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.helper.rdf;

import com.ontotext.graphdb.helper.HelperFunctionCommon;
import com.ontotext.graphdb.helper.rdf.InternalRdfValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.Rio;

public class SerializeRdf
implements Function {
    public String getURI() {
        return HelperFunctionCommon.newIri("serializeRDF");
    }

    public Value evaluate(TripleSource tripleSource, Value ... args) throws ValueExprEvaluationException {
        if (args.length > 0 && args[0] instanceof InternalRdfValue) {
            Literal literal;
            RDFFormat format = RDFFormat.TURTLESTAR;
            if (args.length > 1 && (format = (RDFFormat)Rio.getWriterFormatForMIMEType((String)args[1].stringValue()).orElseThrow(() -> new QueryEvaluationException("Unrecognized RDF format MIME type for helper:serializeRDF(): " + String.valueOf(args[1])))) == RDFFormat.BINARY) {
                throw new QueryEvaluationException(format.getName() + " is a binary format and cannot be used with helper:serializeRDF()");
            }
            StringWriter writer = new StringWriter();
            try {
                Rio.write((Iterable)((InternalRdfValue)args[0]).getModel(), (RDFHandler)Rio.createWriter((RDFFormat)format, (Writer)writer));
                literal = tripleSource.getValueFactory().createLiteral(writer.toString());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ValueExprEvaluationException((Throwable)e);
                }
            }
            writer.close();
            return literal;
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        throw new IllegalStateException();
    }
}

