/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.gpt.quota;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;

public class GraphDBTokenQuotaManager {
    private AtomicLong quotaLimit = new AtomicLong(-1L);
    private AtomicLong promptTokensUsed = new AtomicLong(0L);
    private AtomicLong completionTokensUsed = new AtomicLong(0L);

    private GraphDBTokenQuotaManager() {
    }

    @JsonIgnore
    public long getTotalUsage() {
        return this.promptTokensUsed.get() + this.completionTokensUsed.get();
    }

    @JsonIgnore
    public boolean isUnlimited() {
        return this.quotaLimit.get() < 0L;
    }

    public boolean hasExceededQuota() {
        if (this.isUnlimited()) {
            return false;
        }
        if (this.quotaLimit.get() == 0L) {
            return true;
        }
        return this.getTotalUsage() > this.quotaLimit.get();
    }

    public void consumeTokens(long prompt, long completion) {
        if (this.quotaLimit.get() > 0L) {
            this.promptTokensUsed.addAndGet(prompt);
            this.completionTokensUsed.addAndGet(completion);
        }
    }

    public void resetUsage() {
        this.promptTokensUsed = new AtomicLong(0L);
        this.completionTokensUsed = new AtomicLong(0L);
    }

    public void setQuotaLimit(long newLimit) {
        this.quotaLimit = new AtomicLong(newLimit);
        if (newLimit < 0L) {
            this.resetUsage();
        }
    }

    public void validateQuotaOrThrow() {
        if (this.hasExceededQuota()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS, "You've reached the LLM token limit for this sandbox.");
        }
    }

    public long getQuotaLimit() {
        return this.quotaLimit.get();
    }

    public long getPromptTokensUsed() {
        return this.promptTokensUsed.get();
    }

    public long getCompletionTokensUsed() {
        return this.completionTokensUsed.get();
    }

    public static GraphDBTokenQuotaManager getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final GraphDBTokenQuotaManager INSTANCE = new GraphDBTokenQuotaManager();

        private Holder() {
        }
    }
}

