/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.configs;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.LLMConfig;
import com.ontotext.trree.ReleaseInfo;
import java.util.Locale;

public class SystemConfig {
    private static final String AGENT_INSTRUCTIONS_PROPERTY = "graphdb.ttyg.base.instructions";
    private static final String AGENT_INSTRUCTIONS_DEFAULT = "You are Quadro, an assistant developed by Ontotext and you can answer questions about data stored in GraphDB.";
    private static final String SPARQL_INSTRUCTIONS_PROPERTY = "graphdb.ttyg.sparql.instructions";
    private static final String SPARQL_INSTRUCTIONS_DEFAULT = "If you need to write a SPARQL query, use only the classes and properties provided in the schema and don't invent or guess any. Always try to return human-readable names or labels and not only the IRIs. If SPARQL fails to provide the necessary information you can try another tool too.";
    private static final String ONTOLOGY_INTRODUCTION_PROPERTY = "graphdb.ttyg.ontology.introduction";
    private static final String ONTOLOGY_INTRODUCTION_DEFAULT = "The ontology schema to use in SPARQL queries is:";
    private static final String INSTALLATION_ID_PROPERTY = "graphdb.ttyg.installation.id";
    private static final String INSTALLATION_ID_DEFAULT = "__default__";
    private static final String API_TIMEOUT_PROPERTY = "graphdb.ttyg.timeout";
    private static final String CONNECT_TIMEOUT_PROPERTY = "graphdb.ttyg.http.timeout.connect";
    private static final int CONNECT_TIMEOUT_DEFAULT = 30000;
    private static final String SOCKET_TIMEOUT_PROPERTY = "graphdb.ttyg.http.timeout.socket";
    private static final int SOCKET_TIMEOUT_DEFAULT = 30000;
    private static final String MESSAGES_LIMIT_PROPERTY = "graphdb.ttyg.chat.messages.limit";
    private static final int MESSAGES_LIMIT_DEFAULT = 100;
    private static final String MODEL_CONTEXT_WINDOW_SIZE_PROPERTY = "graphdb.ttyg.model.context.window.size";
    private static final int MODEL_CONTEXT_WINDOW_SIZE_DEFAULT = 128000;
    public static final String DEFAULT_LLM_MODEL_PROPERTY = "graphdb.llm.model";
    public static final String DEFAULT_LLM_MODEL = "gpt-4o";

    public static String getInstallationId() {
        return Config.getProperty((String)INSTALLATION_ID_PROPERTY, (String)INSTALLATION_ID_DEFAULT);
    }

    public static boolean matchesInstallationId(String installationId) {
        return INSTALLATION_ID_DEFAULT.equals(installationId) || SystemConfig.getInstallationId().equals(installationId);
    }

    public static String getAgentInstructions() {
        return Config.getProperty((String)AGENT_INSTRUCTIONS_PROPERTY, (String)AGENT_INSTRUCTIONS_DEFAULT);
    }

    public static String getSparqlInstructions() {
        return Config.getProperty((String)SPARQL_INSTRUCTIONS_PROPERTY, (String)SPARQL_INSTRUCTIONS_DEFAULT);
    }

    public static String getOntologyIntroduction() {
        return Config.getProperty((String)ONTOLOGY_INTRODUCTION_PROPERTY, (String)ONTOLOGY_INTRODUCTION_DEFAULT);
    }

    public static String getHttpUserAgent() {
        return "GraphDB/" + ReleaseInfo.get().getVersion() + " TTYG";
    }

    public static long getApiTimeout() {
        return Config.getPropertyAsLong((String)API_TIMEOUT_PROPERTY, (long)90L);
    }

    public static int getHttpConnectTimeout() {
        return Config.getPropertyAsInt((String)CONNECT_TIMEOUT_PROPERTY, (int)30000);
    }

    public static int getHttpSocketTimeout() {
        return Config.getPropertyAsInt((String)SOCKET_TIMEOUT_PROPERTY, (int)30000);
    }

    public static int getMessageLimit() {
        return Config.getPropertyAsInt((String)MESSAGES_LIMIT_PROPERTY, (int)100);
    }

    public static String localeIndependentFormat(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    public static int getDefaultContextWindowSize() {
        return Config.getPropertyAsInt((String)MODEL_CONTEXT_WINDOW_SIZE_PROPERTY, (int)128000);
    }

    public static String getDefaultLlmModel() {
        return SystemConfig.getDefaultLlmModel(LLMConfig.getLLMApi());
    }

    public static String getDefaultLlmModel(String api) {
        boolean isNullOrDefaultApi;
        boolean bl = isNullOrDefaultApi = api == null || "openai-assistants".equalsIgnoreCase(api);
        if (isNullOrDefaultApi) {
            return Config.getProperty((String)DEFAULT_LLM_MODEL_PROPERTY, (String)DEFAULT_LLM_MODEL);
        }
        return Config.getProperty((String)DEFAULT_LLM_MODEL_PROPERTY);
    }
}

