/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.configs;

import com.ontotext.graphdb.Config;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class LLMConfig {
    public static final String OPENAI_ASSISTANTS_API = "openai-assistants";
    public static final String OPENAI_COMPLETIONS_API = "openai-completions";
    public static final String OPENAI_COMPLETIONS_HTTP11_API = "openai-completions-http1.1";
    public static final String GEMINI_API = "gemini";
    public static final String GRAPHDB_LLM_API = "graphdb.llm.api";
    public static final String GRAPHDB_LLM_URL = "graphdb.llm.url";
    public static final String GRAPHDB_LLM_API_KEY = "graphdb.llm.api-key";
    public static final String GRAPHDB_LLM_AUTH = "graphdb.llm.auth";
    public static final String OPENAI_API_KEY = "graphdb.openai.api-key";
    public static final String OPENAI_AUTH_METHOD = "graphdb.openai.auth";
    public static final String OPENAI_URL = "graphdb.openai.url";
    public static final String GPT_TOKEN_PROPERTY = "graphdb.gpt.token";
    public static final String GPT_AUTH_PROPERTY = "graphdb.gpt.auth";
    public static final String GPT_URL_PROPERTY = "graphdb.gpt.url";
    public static final String DEFAULT_LLM_API = "openai-assistants";

    public static String getLLMApi() {
        return Config.getProperty((String)GRAPHDB_LLM_API);
    }

    public static String getLLMUrl() {
        String llmUrl = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_URL, (String)OPENAI_URL);
        if (llmUrl == null && (llmUrl = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_URL, (String)GPT_URL_PROPERTY)) != null) {
            llmUrl = llmUrl.split("/openai/")[0];
            return llmUrl;
        }
        return llmUrl;
    }

    public static String getLLMApiKeyOrThrow() {
        String key = LLMConfig.getApiKeyOrNull();
        if (key == null) {
            throw new IllegalStateException("Set the config property 'graphdb.llm.api-key' to your LLM API key");
        }
        return key;
    }

    public static boolean isAzure() {
        return Objects.requireNonNullElse(LLMConfig.getLLMUrl(), "").contains(".azure.com");
    }

    public static Pair<String, String> getLLMAuth() {
        String authMethod = Config.getPropertyOrLegacyProperty((String)OPENAI_AUTH_METHOD, (String)GPT_AUTH_PROPERTY);
        if (authMethod == null) {
            authMethod = Config.getProperty((String)GRAPHDB_LLM_AUTH, (String)"auto");
        }
        if ("auto".equals(authMethod)) {
            authMethod = LLMConfig.isAzure() ? "api-key" : "bearer";
        }
        switch (authMethod.toLowerCase(Locale.ROOT)) {
            case "bearer": {
                return Pair.of((Object)"Authorization", (Object)String.format("Bearer %s", LLMConfig.getLLMApiKeyOrThrow()));
            }
            case "api-key": {
                return Pair.of((Object)"api-key", (Object)LLMConfig.getLLMApiKeyOrThrow());
            }
            case "custom": {
                String[] authTokenParts = LLMConfig.getLLMApiKeyOrThrow().split(":", 2);
                if (authTokenParts.length != 2) {
                    throw new IllegalStateException("Custom auth mode requires a token value of the form headerName:headerValue");
                }
                return Pair.of((Object)authTokenParts[0], (Object)authTokenParts[1]);
            }
            case "none": {
                return null;
            }
        }
        throw new IllegalStateException("Unknown LLM auth method: " + authMethod);
    }

    public static String getApiKeyOrNull() {
        String apiKey = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_API_KEY, (String)OPENAI_API_KEY);
        if (apiKey == null) {
            apiKey = Config.getPropertyOrLegacyProperty((String)GRAPHDB_LLM_API_KEY, (String)GPT_TOKEN_PROPERTY);
        }
        return apiKey;
    }

    public static String getProject() {
        return Config.getProperty((String)"graphdb.openai.project");
    }

    public static String getOrganization() {
        return Config.getProperty((String)"graphdb.openai.organization");
    }
}

