/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query;

import java.util.Iterator;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;

public abstract class AbstractBindingSet
implements BindingSet {
    private static final long serialVersionUID = -2594123329154106048L;

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BindingSet)) {
            return false;
        }
        BindingSet that = (BindingSet)other;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.size() == 1) {
            Binding binding = this.iterator().next();
            Binding thatBinding = that.iterator().next();
            return binding.getName().equals(thatBinding.getName()) && binding.getValue().equals((Object)thatBinding.getValue());
        }
        for (Binding binding : that) {
            Value ownValue = this.getValue(binding.getName());
            if (binding.getValue().equals((Object)ownValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int hashCode = 0;
        for (Binding binding : this) {
            hashCode ^= binding.getName().hashCode() ^ binding.getValue().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 * this.size());
        sb.append('[');
        Iterator<Binding> iter = this.iterator();
        while (iter.hasNext()) {
            Binding next = iter.next();
            sb.append(next != null ? next.toString() : "null");
            if (!iter.hasNext()) continue;
            sb.append(';');
        }
        sb.append(']');
        return sb.toString();
    }
}

