/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;

public class JSqlParserTools {
    private static Field partsField;

    public static Select parse(String sql, boolean withSquareBracketArrayAccess) throws JSQLParserException, InvalidQueryException {
        Statement statement = CCJSqlParserUtil.parse((String)sql, parser -> parser.withSquareBracketQuotation(!withSquareBracketArrayAccess));
        if (!(statement instanceof Select)) {
            throw new InvalidQueryException("The query is not a SELECT statement", (Object)statement);
        }
        return (Select)statement;
    }

    public static Select parse(String sql) throws JSQLParserException, InvalidQueryException {
        return JSqlParserTools.parse(sql, false);
    }

    public static RelationID getRelationId(QuotedIDFactory idfac, Table table) {
        if (table.getSchemaName() == null) {
            return idfac.createRelationID(table.getName());
        }
        if (table.getDatabase().getDatabaseName() == null) {
            return idfac.createRelationID(new String[]{table.getSchemaName(), table.getName()});
        }
        if (partsField == null) {
            try {
                partsField = Table.class.getDeclaredField("partItems");
                partsField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new MinorOntopInternalBugException("Cannot find the partsItems field in JSQLParser: " + e);
            }
        }
        try {
            List parts = (List)partsField.get(table);
            return idfac.createRelationID((String[])ImmutableList.copyOf((Collection)parts).reverse().toArray((Object[])new String[0]));
        }
        catch (IllegalAccessException e) {
            throw new MinorOntopInternalBugException("Cannot access the partsItems field in JSQLParser: " + e);
        }
    }
}

