/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class RedshiftDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String INT2_STR = "INT2";
    protected static final String INT4_STR = "INT4";
    protected static final String INT8_STR = "INT8";
    protected static final String FLOAT4_STR = "FLOAT4";
    protected static final String FLOAT8_STR = "FLOAT8";
    protected static final String BPCHAR_STR = "BPCHAR";
    public static final String TIMESTAMPTZ_STR = "TIMESTAMPTZ";
    public static final String TIMETZ_STR = "TIMETZ";
    public static final String BOOL_STR = "BOOL";
    private static final String DEFAULT_DECIMAL_STR = "DECIMAL(38, 18)";
    protected static final String GEOMETRY_STR = "GEOMETRY";
    protected static final String GEOGRAPHY_STR = "GEOGRAPHY";
    protected static final String SUPER_STR = "SUPER";

    protected RedshiftDBTypeFactory(Map<String, DBTermType> typeMap, ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> defaultTypeCodeMap) {
        super(typeMap, defaultTypeCodeMap);
    }

    @AssistedInject
    protected RedshiftDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(RedshiftDBTypeFactory.createRedshiftTypeMap(rootTermType, typeFactory), RedshiftDBTypeFactory.createRedshiftCodeMap(), RedshiftDBTypeFactory.createGenericAbstractTypeMap(rootTermType, typeFactory));
    }

    private static ImmutableList<GenericDBTermType> createGenericAbstractTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ArrayDBTermType abstractArrayType = new ArrayDBTermType(SUPER_STR, rootAncestry, s -> {
            if (s.equals(SUPER_STR)) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBStringType());
            }
            return Optional.empty();
        });
        ArrayList<ArrayDBTermType> list = new ArrayList<ArrayDBTermType>();
        list.add(abstractArrayType);
        return ImmutableList.copyOf(list);
    }

    protected static Map<String, DBTermType> createRedshiftTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        StringDBTermType bpCharType = new StringDBTermType(BPCHAR_STR, rootAncestry, xsdString);
        DatetimeDBTermType timestampTz = new DatetimeDBTermType(TIMESTAMPTZ_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        NonStringNonNumberNonBooleanNonDatetimeDBTermType timeTzType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(TIMETZ_STR, rootAncestry, typeFactory.getDatatype(XSD.TIME), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.NOTHING);
        DateDBTermType dateType = new DateDBTermType("DATE", rootAncestry, typeFactory.getDatatype(XSD.DATE));
        NumberDBTermType defaultDecimalType = new NumberDBTermType(DEFAULT_DECIMAL_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        Map<String, DBTermType> map = RedshiftDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(INT2_STR, map.get("SMALLINT"));
        map.put(INT4_STR, map.get("INTEGER"));
        map.put(INT8_STR, map.get("BIGINT"));
        map.put(FLOAT4_STR, map.get("REAL"));
        map.put(FLOAT8_STR, map.get("DOUBLE PRECISION"));
        map.put(DEFAULT_DECIMAL_STR, (DBTermType)defaultDecimalType);
        map.put(BPCHAR_STR, (DBTermType)bpCharType);
        map.put(TIMESTAMPTZ_STR, (DBTermType)timestampTz);
        map.put(TIMETZ_STR, (DBTermType)timeTzType);
        map.put("DATE", (DBTermType)dateType);
        map.put(BOOL_STR, map.get("BOOLEAN"));
        map.put(GEOMETRY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOMETRY_STR, rootAncestry, xsdString));
        map.put(GEOGRAPHY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOGRAPHY_STR, rootAncestry, xsdString));
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createRedshiftCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = RedshiftDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "DOUBLE PRECISION");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, "TIMESTAMP");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, DEFAULT_DECIMAL_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOGRAPHY, GEOGRAPHY_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOMETRY, GEOMETRY_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public boolean supportsDBGeometryType() {
        return true;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return true;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return false;
    }

    @Override
    public boolean supportsJson() {
        return false;
    }

    @Override
    public boolean supportsArrayType() {
        return false;
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "true";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "false";
    }
}

