/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.model.type.impl.BooleanDBTermType;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.JsonDBTermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.type.impl.UUIDDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgreSQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String VARBIT_STR = "VARBIT";
    protected static final String BIT_STR = "BIT";
    protected static final String INT2_STR = "INT2";
    protected static final String INT4_STR = "INT4";
    protected static final String INT8_STR = "INT8";
    protected static final String FLOAT4_STR = "FLOAT4";
    protected static final String FLOAT8_STR = "FLOAT8";
    protected static final String SMALLSERIAL_STR = "SMALLSERIAL";
    public static final String SERIAL_STR = "SERIAL";
    protected static final String BIGSERIAL_STR = "BIGSERIAL";
    protected static final String BPCHAR_STR = "BPCHAR";
    protected static final String NAME_STR = "NAME";
    public static final String TIMESTAMPTZ_STR = "TIMESTAMPTZ";
    public static final String TIMETZ_STR = "TIMETZ";
    public static final String BOOL_STR = "BOOL";
    public static final String UUID_STR = "UUID";
    public static final String OID_STR = "OID";
    public static final String JSON_STR = "JSON";
    public static final String JSONB_STR = "JSONB";
    public static final String ARRAY_STR = "T[]";
    public static final String BYTEA_STR = "BYTEA";
    protected static final String GEOMETRY_STR = "GEOMETRY";
    protected static final String GEOGRAPHY_STR = "GEOGRAPHY";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[[\\d ]*\\]$");
    private static final Pattern ARRAY_PATTERN_2 = Pattern.compile(" ARRAY(\\[[\\d ]+\\])?$");

    @AssistedInject
    protected PostgreSQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(PostgreSQLDBTypeFactory.createPostgreSQLTypeMap(rootTermType, typeFactory), PostgreSQLDBTypeFactory.createPostgreSQLCodeMap(), PostgreSQLDBTypeFactory.createGenericAbstractTypeMap(rootTermType, typeFactory));
    }

    private static ImmutableList<GenericDBTermType> createGenericAbstractTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ArrayDBTermType abstractArrayType = new ArrayDBTermType(ARRAY_STR, rootAncestry, s -> {
            if (s.startsWith("_")) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBTermType(s.substring(1)));
            }
            Matcher matcher2 = ARRAY_PATTERN_2.matcher(s);
            if (matcher2.find()) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBTermType(s.substring(0, matcher2.start())));
            }
            Matcher matcher = ARRAY_PATTERN.matcher(s);
            if (matcher.find()) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBTermType(s.substring(0, matcher.start())));
            }
            return Optional.empty();
        });
        ArrayList<ArrayDBTermType> list = new ArrayList<ArrayDBTermType>();
        list.add(abstractArrayType);
        return ImmutableList.copyOf(list);
    }

    protected static Map<String, DBTermType> createPostgreSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        BooleanDBTermType bitType = new BooleanDBTermType(BIT_STR, rootAncestry, typeFactory.getXsdBooleanDatatype());
        BooleanDBTermType varBitType = new BooleanDBTermType(VARBIT_STR, rootAncestry, typeFactory.getXsdBooleanDatatype());
        StringDBTermType bpCharType = new StringDBTermType(BPCHAR_STR, rootAncestry, xsdString);
        StringDBTermType nameType = new StringDBTermType(NAME_STR, rootAncestry, xsdString);
        DatetimeDBTermType timestampTz = new DatetimeDBTermType(TIMESTAMPTZ_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        NonStringNonNumberNonBooleanNonDatetimeDBTermType timeTzType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(TIMETZ_STR, rootAncestry, typeFactory.getDatatype(XSD.TIME), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.NOTHING);
        DateDBTermType dateType = new DateDBTermType("DATE", rootAncestry, typeFactory.getDatatype(XSD.DATE));
        NonStringNonNumberNonBooleanNonDatetimeDBTermType byteAType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BYTEA_STR, rootAncestry, typeFactory.getDatatype(XSD.HEXBINARY), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.SAME_TYPE_NO_CONSTANT);
        UUIDDBTermType uuidType = new UUIDDBTermType(UUID_STR, rootTermType.getAncestry(), xsdString);
        NumberDBTermType oidType = new NumberDBTermType(OID_STR, rootAncestry, typeFactory.getDatatype(XSD.INTEGER), DBTermType.Category.INTEGER);
        Map<String, DBTermType> map = PostgreSQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(BIT_STR, (DBTermType)bitType);
        map.put(INT2_STR, map.get("SMALLINT"));
        map.put(INT4_STR, map.get("INTEGER"));
        map.put(INT8_STR, map.get("BIGINT"));
        map.put(OID_STR, (DBTermType)oidType);
        map.put(VARBIT_STR, (DBTermType)varBitType);
        map.put(FLOAT4_STR, map.get("REAL"));
        map.put(FLOAT8_STR, map.get("DOUBLE PRECISION"));
        map.put(SMALLSERIAL_STR, map.get("SMALLINT"));
        map.put(SERIAL_STR, map.get("INTEGER"));
        map.put(BIGSERIAL_STR, map.get("BIGINT"));
        map.put(BPCHAR_STR, (DBTermType)bpCharType);
        map.put(NAME_STR, (DBTermType)nameType);
        map.put(TIMESTAMPTZ_STR, (DBTermType)timestampTz);
        map.put(TIMETZ_STR, (DBTermType)timeTzType);
        map.put("DATE", (DBTermType)dateType);
        map.put(BOOL_STR, map.get("BOOLEAN"));
        map.put(UUID_STR, (DBTermType)uuidType);
        map.put(BYTEA_STR, (DBTermType)byteAType);
        map.put(GEOMETRY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOMETRY_STR, rootAncestry, xsdString));
        map.put(GEOGRAPHY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOGRAPHY_STR, rootAncestry, xsdString));
        map.put(JSON_STR, (DBTermType)new JsonDBTermTypeImpl(JSON_STR, rootAncestry));
        map.put(JSONB_STR, (DBTermType)new JsonDBTermTypeImpl(JSONB_STR, rootAncestry));
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createPostgreSQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = PostgreSQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "DOUBLE PRECISION");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, TIMESTAMPTZ_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, BYTEA_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOGRAPHY, GEOGRAPHY_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOMETRY, GEOMETRY_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.JSON, JSONB_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public boolean supportsDBGeometryType() {
        return true;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return true;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return true;
    }

    @Override
    public boolean supportsJson() {
        return true;
    }
}

