/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.ArrayDBTermType;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.JsonDBTermTypeImpl;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.type.impl.UUIDDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DuckDBDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String INT2_STR = "INT2";
    protected static final String INT4_STR = "INT4";
    protected static final String INT8_STR = "INT8";
    protected static final String HUGEINT_STR = "HUGEINT";
    protected static final String FLOAT4_STR = "FLOAT4";
    protected static final String FLOAT8_STR = "FLOAT8";
    protected static final String BPCHAR_STR = "BPCHAR";
    public static final String TIMETZ_STR = "TIME WITH TIME ZONE";
    public static final String TIMESTAMP_MS_STR = "TIMESTAMP_MS";
    public static final String TIMESTAMP_S_STR = "TIMESTAMP_S";
    public static final String BOOL_STR = "BOOL";
    public static final String UUID_STR = "UUID";
    public static final String JSON_STR = "JSON";
    public static final String BYTEA_STR = "BYTEA";
    public static final String STRING_STR = "STRING";
    public static final String DEFAULT_DECIMAL_STR = "DECIMAL(38, 18)";
    public static final String ARRAY_STR = "T[]";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[[\\d ]*\\]$");

    @AssistedInject
    protected DuckDBDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(DuckDBDBTypeFactory.createDuckDBTypeMap(rootTermType, typeFactory), DuckDBDBTypeFactory.createDuckDBCodeMap(), DuckDBDBTypeFactory.createGenericAbstractTypeMap(rootTermType, typeFactory));
    }

    private static ImmutableList<GenericDBTermType> createGenericAbstractTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        ArrayDBTermType abstractArrayType = new ArrayDBTermType(ARRAY_STR, rootAncestry, s -> {
            Matcher matcher = ARRAY_PATTERN.matcher(s);
            if (matcher.find()) {
                return Optional.of(typeFactory.getDBTypeFactory().getDBTermType(s.substring(0, matcher.start())));
            }
            return Optional.empty();
        });
        ArrayList<ArrayDBTermType> list = new ArrayList<ArrayDBTermType>();
        list.add(abstractArrayType);
        return ImmutableList.copyOf(list);
    }

    protected static Map<String, DBTermType> createDuckDBTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        StringDBTermType bpCharType = new StringDBTermType(BPCHAR_STR, rootAncestry, xsdString);
        NonStringNonNumberNonBooleanNonDatetimeDBTermType timeTzType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(TIMETZ_STR, rootAncestry, typeFactory.getDatatype(XSD.TIME), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.NOTHING);
        DateDBTermType dateType = new DateDBTermType("DATE", rootAncestry, typeFactory.getDatatype(XSD.DATE));
        NonStringNonNumberNonBooleanNonDatetimeDBTermType byteAType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BYTEA_STR, rootAncestry, typeFactory.getDatatype(XSD.HEXBINARY), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.SAME_TYPE_NO_CONSTANT);
        UUIDDBTermType uuidType = new UUIDDBTermType(UUID_STR, rootTermType.getAncestry(), xsdString);
        StringDBTermType stringType = new StringDBTermType(STRING_STR, rootAncestry, xsdString);
        NumberDBTermType defaultDecimalType = new NumberDBTermType(DEFAULT_DECIMAL_STR, rootAncestry, (RDFDatatype)typeFactory.getXsdDecimalDatatype(), DBTermType.Category.DECIMAL);
        DatetimeDBTermType timestampMs = new DatetimeDBTermType(TIMESTAMP_MS_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype(), false);
        DatetimeDBTermType timestampS = new DatetimeDBTermType(TIMESTAMP_S_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype(), false);
        DatetimeDBTermType timestamp = new DatetimeDBTermType("TIMESTAMP", rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype(), false);
        Map<String, DBTermType> map = DuckDBDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(INT2_STR, map.get("SMALLINT"));
        map.put(INT4_STR, map.get("INTEGER"));
        map.put(INT8_STR, map.get("BIGINT"));
        map.put(FLOAT4_STR, map.get("REAL"));
        map.put(FLOAT8_STR, map.get("DOUBLE PRECISION"));
        map.put(DEFAULT_DECIMAL_STR, (DBTermType)defaultDecimalType);
        map.put(HUGEINT_STR, map.get("BIGINT"));
        map.put(STRING_STR, (DBTermType)stringType);
        map.put(BPCHAR_STR, (DBTermType)bpCharType);
        map.put(TIMETZ_STR, (DBTermType)timeTzType);
        map.put("DATE", (DBTermType)dateType);
        map.put(BOOL_STR, map.get("BOOLEAN"));
        map.put(UUID_STR, (DBTermType)uuidType);
        map.put(BYTEA_STR, (DBTermType)byteAType);
        map.put(TIMESTAMP_MS_STR, (DBTermType)timestampMs);
        map.put(TIMESTAMP_S_STR, (DBTermType)timestampS);
        map.put("TIMESTAMP", (DBTermType)timestamp);
        map.put(JSON_STR, (DBTermType)new JsonDBTermTypeImpl(JSON_STR, rootAncestry));
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createDuckDBCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = DuckDBDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "DOUBLE PRECISION");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, "TIMESTAMP WITH TIME ZONE");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, BYTEA_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, "VARCHAR");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.JSON, JSON_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, DEFAULT_DECIMAL_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public boolean supportsDBGeometryType() {
        return false;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return false;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return false;
    }

    @Override
    public boolean supportsJson() {
        return true;
    }

    @Override
    public boolean supportsArrayType() {
        return false;
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "true";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "false";
    }
}

