/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.GenericDBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.SQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.BooleanDBTermType;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultSQLDBTypeFactory
implements SQLDBTypeFactory {
    protected static final String ABSTRACT_DB_TYPE_STR = "AbstractDBType";
    public static final String TEXT_STR = "TEXT";
    public static final String CHAR_STR = "CHAR";
    protected static final String CHARACTER_STR = "CHARACTER";
    protected static final String VARCHAR_STR = "VARCHAR";
    protected static final String CHAR_VAR_STR = "CHARACTER VARYING";
    protected static final String CLOB_STR = "CLOB";
    protected static final String CHAR_LARGE_STR = "CHARACTER LARGE OBJECT";
    public static final String NATIONAL_TEXT_STR = "NATIONAL TEXT";
    public static final String NTEXT_STR = "NTEXT";
    protected static final String NATIONAL_CHAR_STR = "NATIONAL CHARACTER";
    protected static final String NCHAR_STR = "NCHAR";
    protected static final String NATIONAL_CHAR_VAR_STR = "NATIONAL CHARACTER VARYING";
    protected static final String NVARCHAR_STR = "NVARCHAR";
    protected static final String NATIONAL_CHAR_LARGE_STR = "NATIONAL CHARACTER LARGE OBJECT";
    public static final String INTEGER_STR = "INTEGER";
    protected static final String INT_STR = "INT";
    public static final String TINYINT_STR = "TINYINT";
    public static final String SMALLINT_STR = "SMALLINT";
    protected static final String BIGINT_STR = "BIGINT";
    protected static final String NUMERIC_STR = "NUMERIC";
    protected static final String DECIMAL_STR = "DECIMAL";
    protected static final String FLOAT_STR = "FLOAT";
    protected static final String REAL_STR = "REAL";
    protected static final String DOUBLE_STR = "DOUBLE";
    protected static final String DOUBLE_PREC_STR = "DOUBLE PRECISION";
    protected static final String BOOLEAN_STR = "BOOLEAN";
    public static final String DATE_STR = "DATE";
    public static final String TIME_STR = "TIME";
    public static final String TIMESTAMP_STR = "TIMESTAMP";
    public static final String TIMESTAMP_WITH_TIME_ZONE_STR = "TIMESTAMP WITH TIME ZONE";
    public static final String BINARY_STR = "BINARY";
    public static final String BINARY_VAR_STR = "BINARY VARYING";
    public static final String VARBINARY_STR = "VARBINARY";
    public static final String BINARY_LARGE_STR = "BINARY LARGE OBJECT";
    protected static final String BLOB_STR = "BLOB";
    protected final NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport defaultStrictEqSupport;
    private final Map<String, DBTermType> sqlTypeMap;
    private final ImmutableMap<DefaultTypeCode, String> defaultTypeCodeMap;
    private final ImmutableList<GenericDBTermType> genericAbstractTypes;
    private static final Pattern OPTIONAL_LENGTH = Pattern.compile("\\([\\d, ]+\\)");

    @AssistedInject
    private DefaultSQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        this(DefaultSQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory), (ImmutableMap<DefaultTypeCode, String>)ImmutableMap.copyOf(DefaultSQLDBTypeFactory.createDefaultSQLCodeMap()));
    }

    protected DefaultSQLDBTypeFactory(Map<String, DBTermType> typeMap, ImmutableMap<DefaultTypeCode, String> defaultTypeCodeMap) {
        this(typeMap, defaultTypeCodeMap, (ImmutableList<GenericDBTermType>)ImmutableList.of());
    }

    protected DefaultSQLDBTypeFactory(Map<String, DBTermType> typeMap, ImmutableMap<DefaultTypeCode, String> defaultTypeCodeMap, ImmutableList<GenericDBTermType> genericAbstractTypes) {
        this.sqlTypeMap = typeMap;
        this.defaultTypeCodeMap = defaultTypeCodeMap;
        this.defaultStrictEqSupport = NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.SAME_TYPE_NO_CONSTANT;
        this.genericAbstractTypes = genericAbstractTypes;
    }

    protected static Map<String, DBTermType> createDefaultSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        NonStringNonNumberNonBooleanNonDatetimeDBTermType rootDBType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(ABSTRACT_DB_TYPE_STR, rootTermType.getAncestry(), true);
        TermTypeAncestry rootAncestry = rootDBType.getAncestry();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        RDFDatatype hexBinary = typeFactory.getDatatype(XSD.HEXBINARY);
        ConcreteNumericRDFDatatype xsdInteger = typeFactory.getXsdIntegerDatatype();
        ConcreteNumericRDFDatatype xsdDecimal = typeFactory.getXsdDecimalDatatype();
        ConcreteNumericRDFDatatype xsdDouble = typeFactory.getXsdDoubleDatatype();
        RDFDatatype xsdBoolean = typeFactory.getXsdBooleanDatatype();
        return Stream.of(rootDBType, new StringDBTermType(TEXT_STR, rootAncestry, xsdString), new StringDBTermType(CHAR_STR, rootAncestry, xsdString), new StringDBTermType(CHARACTER_STR, rootAncestry, xsdString), new StringDBTermType(VARCHAR_STR, rootAncestry, xsdString), new StringDBTermType(CHAR_VAR_STR, rootAncestry, xsdString), new StringDBTermType(CHAR_LARGE_STR, rootAncestry, xsdString), new StringDBTermType(CLOB_STR, rootAncestry, xsdString), new StringDBTermType(NATIONAL_TEXT_STR, rootAncestry, xsdString), new StringDBTermType(NTEXT_STR, rootAncestry, xsdString), new StringDBTermType(NATIONAL_CHAR_STR, rootAncestry, xsdString), new StringDBTermType(NCHAR_STR, rootAncestry, xsdString), new StringDBTermType(NATIONAL_CHAR_VAR_STR, rootAncestry, xsdString), new StringDBTermType(NVARCHAR_STR, rootAncestry, xsdString), new StringDBTermType(NATIONAL_CHAR_LARGE_STR, rootAncestry, xsdString), new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BINARY_STR, rootAncestry, hexBinary), new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BINARY_VAR_STR, rootAncestry, hexBinary), new NonStringNonNumberNonBooleanNonDatetimeDBTermType(VARBINARY_STR, rootAncestry, hexBinary), new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BINARY_LARGE_STR, rootAncestry, hexBinary), new NonStringNonNumberNonBooleanNonDatetimeDBTermType(BLOB_STR, rootAncestry, hexBinary), new NumberDBTermType(INTEGER_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER), new NumberDBTermType(INT_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER), new NumberDBTermType(TINYINT_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER), new NumberDBTermType(SMALLINT_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER), new NumberDBTermType(BIGINT_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER), new NumberDBTermType(NUMERIC_STR, rootAncestry, (RDFDatatype)xsdDecimal, DBTermType.Category.DECIMAL), new NumberDBTermType(DECIMAL_STR, rootAncestry, (RDFDatatype)xsdDecimal, DBTermType.Category.DECIMAL), new NumberDBTermType(FLOAT_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE), new NumberDBTermType(REAL_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE), new NumberDBTermType(DOUBLE_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE), new NumberDBTermType(DOUBLE_PREC_STR, rootTermType.getAncestry(), (RDFDatatype)xsdDouble, DBTermType.Category.FLOAT_DOUBLE), new BooleanDBTermType(BOOLEAN_STR, rootTermType.getAncestry(), xsdBoolean), new DateDBTermType(DATE_STR, rootAncestry, typeFactory.getDatatype(XSD.DATE)), new NonStringNonNumberNonBooleanNonDatetimeDBTermType(TIME_STR, rootTermType.getAncestry(), typeFactory.getDatatype(XSD.TIME)), new DatetimeDBTermType(TIMESTAMP_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype()), new DatetimeDBTermType(TIMESTAMP_WITH_TIME_ZONE_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype())).collect(Collectors.toMap(DBTermType::getName, t -> t));
    }

    protected static Map<DefaultTypeCode, String> createDefaultSQLCodeMap() {
        HashMap<DefaultTypeCode, String> map = new HashMap<DefaultTypeCode, String>();
        map.put(DefaultTypeCode.STRING, TEXT_STR);
        map.put(DefaultTypeCode.HEXBINARY, BINARY_LARGE_STR);
        map.put(DefaultTypeCode.LARGE_INTEGER, BIGINT_STR);
        map.put(DefaultTypeCode.DECIMAL, DECIMAL_STR);
        map.put(DefaultTypeCode.DOUBLE, DOUBLE_STR);
        map.put(DefaultTypeCode.BOOLEAN, BOOLEAN_STR);
        map.put(DefaultTypeCode.DATE, DATE_STR);
        map.put(DefaultTypeCode.TIME, TIME_STR);
        map.put(DefaultTypeCode.DATETIMESTAMP, TIMESTAMP_STR);
        return map;
    }

    private Optional<DBTermType> createNewGenericType(String typeString) {
        return this.genericAbstractTypes.stream().flatMap(type -> type.createFromSignature(typeString).stream().map(t -> t)).findFirst();
    }

    private DBTermType getGenericDBTermType(GenericDBTermType genericBaseType, ImmutableList<DBTermType> argumentTypes) {
        return genericBaseType.createFromGenericTypes(argumentTypes);
    }

    private DBTermType createNewTermType(String typeString) {
        Optional<DBTermType> type = this.createNewGenericType(typeString);
        return type.orElseGet(() -> new NonStringNonNumberNonBooleanNonDatetimeDBTermType(typeString, this.sqlTypeMap.get(ABSTRACT_DB_TYPE_STR).getAncestry(), this.defaultStrictEqSupport));
    }

    public DBTermType getDBTermType(String typeName) {
        String typeString = this.preprocessTypeName(typeName);
        if (this.sqlTypeMap.containsKey(typeString)) {
            return this.sqlTypeMap.get(typeString);
        }
        DBTermType newType = this.createNewTermType(typeString);
        this.sqlTypeMap.put(typeString, newType);
        return newType;
    }

    public DBTermType getDBTermType(String typeName, int columnSize) {
        String typeString = this.preprocessTypeName(typeName, columnSize);
        if (this.sqlTypeMap.containsKey(typeString)) {
            return this.sqlTypeMap.get(typeString);
        }
        DBTermType newType = this.createNewTermType(typeString);
        this.sqlTypeMap.put(typeString, newType);
        return newType;
    }

    public String getDBTrueLexicalValue() {
        return "TRUE";
    }

    public String getDBFalseLexicalValue() {
        return "FALSE";
    }

    public String getNullLexicalValue() {
        return "NULL";
    }

    public Optional<String> getDBNaNLexicalValue() {
        return Optional.of("NaN");
    }

    protected String preprocessTypeName(String typeName) {
        return OPTIONAL_LENGTH.matcher(typeName).replaceAll("").toUpperCase();
    }

    protected String preprocessTypeName(String typeName, int columnSize) {
        return OPTIONAL_LENGTH.matcher(typeName).replaceAll("").toUpperCase();
    }

    public DBTermType getDBStringType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.STRING));
    }

    public DBTermType getDBLargeIntegerType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.LARGE_INTEGER));
    }

    public DBTermType getDBDecimalType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.DECIMAL));
    }

    public DBTermType getDBBooleanType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.BOOLEAN));
    }

    public DBTermType getDBDateType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.DATE));
    }

    public DBTermType getDBTimeType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.TIME));
    }

    public DBTermType getDBDateTimestampType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.DATETIMESTAMP));
    }

    public DBTermType getDBDoubleType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.DOUBLE));
    }

    public DBTermType getDBGeometryType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.GEOMETRY));
    }

    public DBTermType getDBGeographyType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.GEOGRAPHY));
    }

    public boolean supportsDBGeometryType() {
        return false;
    }

    public boolean supportsDBGeographyType() {
        return false;
    }

    public boolean supportsDBDistanceSphere() {
        return false;
    }

    public boolean supportsJson() {
        return false;
    }

    public boolean supportsArrayType() {
        return false;
    }

    public DBTermType getDBHexBinaryType() {
        return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.HEXBINARY));
    }

    public DBTermType getDBArrayType() {
        return this.getDBArrayType(this.getAbstractRootDBType());
    }

    public DBTermType getDBArrayType(DBTermType baseType) {
        if (this.supportsArrayType()) {
            GenericDBTermType genericType = this.genericAbstractTypes.stream().filter(type -> type.getName().equals(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.ARRAY))).findFirst().orElseThrow(() -> new UnsupportedDBTypeException("DBType Array not supported for this DBMS"));
            return this.getGenericDBTermType(genericType, (ImmutableList<DBTermType>)ImmutableList.of((Object)baseType));
        }
        throw new UnsupportedDBTypeException("DBType Array not supported for this DBMS");
    }

    public DBTermType getDBJsonType() {
        if (this.supportsJson()) {
            return this.sqlTypeMap.get(this.defaultTypeCodeMap.get((Object)DefaultTypeCode.JSON));
        }
        throw new UnsupportedDBTypeException("DBType JSON not supported for this DBMS");
    }

    public DBTermType getAbstractRootDBType() {
        return this.sqlTypeMap.get(ABSTRACT_DB_TYPE_STR);
    }

    private static class UnsupportedDBTypeException
    extends OntopInternalBugException {
        public UnsupportedDBTypeException(String message) {
            super(message);
        }
    }

    protected static enum DefaultTypeCode {
        STRING,
        HEXBINARY,
        LARGE_INTEGER,
        DECIMAL,
        DOUBLE,
        BOOLEAN,
        DATE,
        TIME,
        DATETIMESTAMP,
        GEOMETRY,
        GEOGRAPHY,
        ARRAY,
        JSON;

    }
}

