/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBSampleFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.MySQLEncodeURLorIRIFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Map;
import java.util.function.Function;

public class SnowflakeDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String UUID_STRING_STR = "UUID_STRING";
    private static final String RANDOM_STR = "RANDOM";

    @Inject
    protected SnowflakeDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(SnowflakeDBFunctionSymbolFactory.createSnowflakeRegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createSnowflakeRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(SnowflakeDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createNormalizationMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll((Map)super.createNormalizationMap());
        DBTypeFactory dbTypeFactory = this.typeFactory.getDBTypeFactory();
        for (String timestampTypeString : ImmutableList.of((Object)"TIMESTAMP_LTZ", (Object)"TIMESTAMP_NTZ")) {
            DBTermType timestampType = dbTypeFactory.getDBTermType(timestampTypeString);
            DBTypeConversionFunctionSymbol datetimeNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(timestampType);
            builder.put((Object)timestampType, (Object)datetimeNormFunctionSymbol);
        }
        return builder.build();
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CONTAINS(%s,%s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("NVL(SUBSTR(%s,0,POSITION(%s IN %s)-1),'')", str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,POSITION(%s IN %s) + LENGTH(%s), CAST( SIGN(POSITION(%s IN %s)) * LENGTH(%s) AS INTEGER))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("MD5(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA1(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s, 256)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA384(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s, 384)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("SHA2(%s, 512)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(LPAD(EXTRACT(TIMEZONE_HOUR FROM %s)::text,2,'0') || ':' || LPAD(EXTRACT(TIMEZONE_MINUTE FROM %s)::text,2,'0'))", str, str);
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return this.createDBConcatOperator(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, Serializers.getOperatorSerializer((String)"||"));
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return this.createNullRejectingDBConcat(arity);
    }

    @Override
    protected String serializeDateTimeNormWithTZ(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TO_CHAR(%s, 'YYYY-MM-DDTHH24:MI:SS.FF3TZHTZM')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    public DBFunctionSymbol getDBCharLength() {
        return this.getRegularDBFunctionSymbol("LENGTH", 1);
    }

    @Override
    protected String getRandNameInDialect() {
        return RANDOM_STR;
    }

    @Override
    protected String getUUIDNameInDialect() {
        return UUID_STRING_STR;
    }

    @Override
    protected String serializeDBRowNumber(Function<ImmutableTerm, String> converter, TermFactory termFactory) {
        return "ROW_NUMBER() OVER (ORDER BY 1)";
    }

    @Override
    protected DBFunctionSymbol createEncodeURLorIRI(boolean preserveInternationalChars) {
        return new MySQLEncodeURLorIRIFunctionSymbolImpl(this.dbStringType, preserveInternationalChars);
    }

    @Override
    protected String serializeCheckAndConvertBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(CASE WHEN %s IS NULL THEN NULL WHEN CAST(%s AS NUMBER(38,10)) = 0 THEN '0' WHEN %s = '' THEN '0' ELSE '1' END)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertBooleanFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CASE WHEN %s='1' THEN 1 WHEN UPPER(%s) LIKE 'TRUE' THEN 1 WHEN %s='0' THEN 0 WHEN UPPER(%s) LIKE 'FALSE' THEN 0 ELSE NULL END", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDouble(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS DOUBLE PRECISION)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertFloat(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS FLOAT)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertFloatFromNonFPNumeric(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeCheckAndConvertFloat(terms, termConverter, termFactory);
    }

    @Override
    protected String serializeCheckAndConvertDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS NUMBER(38,10))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertFloatFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1.0 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1.0 WHEN %1$s='0' THEN 0.0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0.0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertDecimalFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1.0 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1.0 WHEN %1$s='0' THEN 0.0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0.0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertInteger(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CAST(FLOOR(ABS(TRY_CAST(%1$s AS NUMBER(38,10)))) * SIGN(TRY_CAST(%1$s AS DECIMAL)) AS INTEGER)", term);
    }

    @Override
    protected String serializeCheckAndConvertIntegerFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1 WHEN %1$s='0' THEN 0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertStringFromDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(CASE WHEN %1$s %% 1 = 0 THEN FLOOR(ABS(%1$s)) * SIGN(TRY_CAST (%1$s AS DECIMAL)) ELSE %1$s END)", term);
    }

    @Override
    protected String serializeCheckAndConvertDateTimeFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS DATETIME)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateFromDateTime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS DATE)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeCheckAndConvertDateFromDateTime(terms, termConverter, termFactory);
    }

    @Override
    protected DBFunctionSymbol createDBSample(DBTermType termType) {
        return new DBSampleFunctionSymbolImpl(termType, "ANY_VALUE");
    }

    protected DBTermType inferOutputTypeMathOperator(String dbMathOperatorName, DBTermType arg1Type, DBTermType arg2Type) {
        if (dbMathOperatorName.equals("/")) {
            return this.dbDecimalType;
        }
        return super.inferOutputTypeMathOperator(dbMathOperatorName, arg1Type, arg2Type);
    }

    @Override
    protected String serializeDecade(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(EXTRACT(YEAR FROM %s) / 10.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCentury(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 100.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMillennium(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 1000.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMilliseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(SECOND FROM %s) * 1000", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMicroseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(SECOND FROM %s) * 1000000", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    public DBFunctionSymbol getDBDateTrunc(String datePart) {
        if (ImmutableSet.of((Object)"microseconds", (Object)"milliseconds", (Object)"decade", (Object)"century", (Object)"millennium").contains((Object)datePart.toLowerCase())) {
            throw new IllegalArgumentException(String.format("Snowflake does not support DATE_TRUNC on %s.", datePart));
        }
        return super.getDBDateTrunc(datePart);
    }
}

