/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsNullOrNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBRegexMatchAsLikeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBBooleanCoalesceFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNonDeterministicNullaryFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleMultitypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.EqualsTrueDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ExpressionSensitiveSQLDBIsNullOrNotFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ForcingFloatingDBAvgFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBGroupConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBStdevFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBVarianceFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullToleratingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SQLServerBooleanDBIfElseNullFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SQLServerDBIriStringResolverFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SQLServerRoundFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SQLServerTimestampISODenormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WithoutParenthesesSimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WrappedDBBooleanCaseFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;

public class SQLServerDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String LEN_STR = "LEN";
    private static final String CEILING_STR = "CEILING";
    private static final String UNSUPPORTED_MSG = "Not supported by SQL server";
    private DBFunctionSymbol substr2FunctionSymbol;
    private DBBooleanFunctionSymbol regexpLike2;
    private DBBooleanFunctionSymbol regexpLike3;

    @Inject
    private SQLServerDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(SQLServerDBFunctionSymbolFactory.createSQLServerRegularFunctionTable(typeFactory), typeFactory);
    }

    @Override
    protected void init() {
        super.init();
        this.substr2FunctionSymbol = new DBFunctionSymbolWithSerializerImpl("SUBSTR2", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbStringType, false, this::serializeSubString2);
        this.regexpLike2 = new DBRegexMatchAsLikeFunctionSymbolImpl("REGEXP_LIKE2", this.dbStringType, this.dbBooleanType, 2);
        this.regexpLike3 = new DBRegexMatchAsLikeFunctionSymbolImpl("REGEXP_LIKE3", this.dbStringType, this.dbBooleanType, 3);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullToleratingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBIsNullOrNotFunctionSymbol createDBIsNull(DBTermType dbBooleanType, DBTermType rootDBTermType) {
        return new ExpressionSensitiveSQLDBIsNullOrNotFunctionSymbolImpl(true, dbBooleanType, rootDBTermType);
    }

    @Override
    protected DBIsNullOrNotFunctionSymbol createDBIsNotNull(DBTermType dbBooleanType, DBTermType rootDBTermType) {
        return new ExpressionSensitiveSQLDBIsNullOrNotFunctionSymbolImpl(false, dbBooleanType, rootDBTermType);
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("CONCAT+", arity, this.dbStringType, this.abstractRootDBType, Serializers.getOperatorSerializer((String)"+"));
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createNormalizationMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll((Map)super.createNormalizationMap());
        DBTermType datetime = this.dbTypeFactory.getDBTermType("DATETIME");
        DBTypeConversionFunctionSymbol datetimeNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(datetime);
        builder.put((Object)datetime, (Object)datetimeNormFunctionSymbol);
        DBTermType datetimeOffset = this.dbTypeFactory.getDBTermType("DATETIMEOFFSET");
        DBTypeConversionFunctionSymbol datetimeOffsetNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(datetimeOffset);
        builder.put((Object)datetimeOffset, (Object)datetimeOffsetNormFunctionSymbol);
        return builder.build();
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createSQLServerRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbIntType = dbTypeFactory.getDBLargeIntegerType();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(SQLServerDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        DefaultSQLSimpleTypedDBFunctionSymbol strlenFunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(LEN_STR, 1, dbIntType, false, abstractRootDBType);
        table.remove((Object)"CHAR_LENGTH", (Object)1);
        table.put((Object)LEN_STR, (Object)1, (Object)strlenFunctionSymbol);
        WithoutParenthesesSimpleTypedDBFunctionSymbolImpl nowFunctionSymbol = new WithoutParenthesesSimpleTypedDBFunctionSymbolImpl("CURRENT_TIMESTAMP", dbTypeFactory.getDBDateTimestampType(), abstractRootDBType);
        table.put((Object)"CURRENT_TIMESTAMP", (Object)0, (Object)nowFunctionSymbol);
        table.remove((Object)"SUBSTRING", (Object)2);
        table.remove((Object)"SUBSTR", (Object)2);
        table.remove((Object)"REGEXP_LIKE", (Object)2);
        table.remove((Object)"REGEXP_LIKE", (Object)3);
        return ImmutableTable.copyOf((Table)table);
    }

    @Override
    public DBFunctionSymbol getDBCharLength() {
        return this.getRegularDBFunctionSymbol(LEN_STR, 1);
    }

    @Override
    public NonDeterministicDBFunctionSymbol getDBUUID(UUID uuid) {
        return new DefaultNonDeterministicNullaryFunctionSymbol("UUID", uuid, this.dbStringType, (terms, termConverter, termFactory) -> "LOWER(CONVERT(NVARCHAR(100),NEWID()))");
    }

    @Override
    protected String getUUIDNameInDialect() {
        throw new UnsupportedOperationException("Do not call getUUIDNameInDialect for SQL Server");
    }

    @Override
    protected String serializeDBRowNumber(Function<ImmutableTerm, String> converter, TermFactory termFactory) {
        return "ROW_NUMBER() OVER (ORDER BY (SELECT NULL))";
    }

    @Override
    public DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return this.getNullRejectingDBConcat(arity);
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(CHARINDEX(%s,%s) > 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,SIGN(CHARINDEX(%s,%s))* (CHARINDEX(%s,%s)-1))", str, before, str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("CASE WHEN LEN(%s) = 0 THEN %s ELSE SUBSTRING(%s,CHARINDEX(%s,%s)+LEN(%s),SIGN(CHARINDEX(%s,%s))*LEN(%s)) END", after, str, str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(CONVERT(VARCHAR(40), HASHBYTES('MD5',%s),2))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(CONVERT(VARCHAR(40), HASHBYTES('SHA1',%s),2))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(CONVERT(VARCHAR(64), HASHBYTES('SHA2_256',%s),2))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA384(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(CONVERT(VARCHAR(128), HASHBYTES('SHA2_512',%s),2))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected DBFunctionSymbol createTzFunctionSymbol() {
        return super.createTzFunctionSymbol();
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CONVERT(nvarchar(5), DATEADD(minute, DATEPART(TZ, %s), 0), 114)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDateTimeNormWithTZ(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CONVERT(nvarchar(50),%s,127)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new EqualsTrueDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createDBBooleanIfElseNull() {
        return new SQLServerBooleanDBIfElseNullFunctionSymbolImpl(this.dbBooleanType);
    }

    @Override
    public DBFunctionSymbol getDBRegexpReplace3() {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public DBFunctionSymbol getDBRegexpReplace4() {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    protected DBFunctionSymbol createDBIriStringResolver(IRI baseIRI) {
        return new SQLServerDBIriStringResolverFunctionSymbolImpl(baseIRI, this.typeFactory.getDBTypeFactory().getAbstractRootDBType(), this.dbStringType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createStringToStringCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        switch (inputType.getName()) {
            case "NTEXT": 
            case "TEXT": {
                return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType)){

                    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
                        return false;
                    }

                    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
                        return IncrementalEvaluation.declareSameExpression();
                    }
                };
            }
        }
        return super.createStringToStringCastFunctionSymbol(inputType, targetType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDateTimeDenormFunctionSymbol(DBTermType timestampType) {
        return new SQLServerTimestampISODenormFunctionSymbol(timestampType, this.dbStringType);
    }

    @Override
    protected String serializeYear(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("YEAR(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMonth(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("MONTH(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDay(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DAY(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeHours(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEPART(HOUR, %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMinutes(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEPART(MINUTE, %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeSeconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEPART(SECOND, %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected Optional<DBFunctionSymbol> createRoundFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new SQLServerRoundFunctionSymbol(dbTermType));
    }

    @Override
    protected Optional<DBFunctionSymbol> createCeilFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new DefaultSQLSimpleMultitypedDBFunctionSymbolImpl(CEILING_STR, 1, dbTermType, false));
    }

    @Override
    public DBFunctionSymbol getDBSubString2() {
        return this.substr2FunctionSymbol;
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return this.regexpLike2;
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        return this.regexpLike3;
    }

    @Override
    protected DBFunctionSymbol createDBAvg(DBTermType inputType, boolean isDistinct) {
        if (inputType.equals(this.dbIntegerType)) {
            return new ForcingFloatingDBAvgFunctionSymbolImpl(inputType, this.dbDecimalType, isDistinct);
        }
        return super.createDBAvg(inputType, isDistinct);
    }

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new NullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (terms, termConverter, termFactory) -> String.format("STRING_AGG(%s%s,%s) WITHIN GROUP (ORDER BY %s)", isDistinct ? "DISTINCT " : "", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0))));
    }

    @Override
    protected DBBooleanFunctionSymbol createDBBooleanCase(int arity, boolean doOrderingMatter) {
        return new WrappedDBBooleanCaseFunctionSymbolImpl(arity, this.dbBooleanType, this.abstractRootDBType, doOrderingMatter);
    }

    @Override
    protected DBBooleanFunctionSymbol createBooleanCoalesceFunctionSymbol(int arity) {
        return new DefaultDBBooleanCoalesceFunctionSymbol("COALESCE", arity, this.abstractRootDBType, this.dbBooleanType, (terms, termConverter, termFactory) -> {
            String parameterString = terms.stream().map(termConverter).collect(Collectors.joining(","));
            return String.format("COALESCE(%s) = 1", parameterString);
        });
    }

    protected String serializeSubString2(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String start = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,%s,LEN(%s))", str, start, str);
    }

    @Override
    protected String serializeWeeksBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEDIFF(WEEK, %s, %s)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDaysBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEDIFF(DAY, %s, %s) - IIF(CAST(%s AS TIME) > CAST(%s AS TIME), 1, 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeHoursBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEDIFF(HOUR, %s, %s) - IIF(DATEPART(MINUTE, %s) > DATEPART(MINUTE, %s), 1, 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMinutesBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEDIFF(MINUTE, %s, %s) - IIF(DATEPART(SECOND, %s) > DATEPART(SECOND, %s), 1, 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeSecondsBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEDIFF(SECOND, %s, %s) - IIF(DATEPART(MILLISECOND, %s) > DATEPART(MILLISECOND, %s), 1, 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMillisBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEDIFF(MILLISECOND, %s, %s)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(CASE WHEN %s IS NULL THEN NULL WHEN CAST(%s AS DECIMAL(38, 19)) = 0 THEN '0' WHEN %s = '' THEN '0' ELSE '1' END)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertBooleanFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CASE WHEN %s='1' THEN 1 WHEN UPPER(%s) LIKE 'TRUE' THEN 1 WHEN %s='0' THEN 0 WHEN UPPER(%s) LIKE 'FALSE' THEN 0 ELSE NULL END", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDouble(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS DOUBLE PRECISION)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertFloat(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS FLOAT)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertFloatFromNonFPNumeric(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeCheckAndConvertFloat(terms, termConverter, termFactory);
    }

    @Override
    protected String serializeCheckAndConvertDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS DECIMAL(38, 19))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertFloatFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1.0 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1.0 WHEN %1$s='0' THEN 0.0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0.0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertDecimalFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1.0 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1.0 WHEN %1$s='0' THEN 0.0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0.0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertInteger(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CAST(FLOOR(ABS(TRY_CAST(%1$s AS DECIMAL(38, 19)))) * SIGN(TRY_CAST(%1$s AS DECIMAL)) AS INTEGER)", term);
    }

    @Override
    protected String serializeCheckAndConvertIntegerFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1 WHEN %1$s='0' THEN 0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertStringFromDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(CASE WHEN %1$s %% 1 = 0 THEN FLOOR(ABS(%1$s)) * SIGN(TRY_CAST (%1$s AS DECIMAL)) ELSE %1$s END)", term);
    }

    @Override
    protected String serializeCheckAndConvertDateTimeFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS DATETIME)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateFromDateTime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRY_CAST(%s AS DATE)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializeCheckAndConvertDateFromDateTime(terms, termConverter, termFactory);
    }

    public DBBooleanFunctionSymbol getDBIsArray(DBTermType dbType) {
        return new DBBooleanFunctionSymbolWithSerializerImpl("JSON_IS_ARRAY", ImmutableList.of((Object)this.typeFactory.getDBTypeFactory().getDBStringType()), this.dbBooleanType, false, (terms, termConverter, termFactory) -> String.format("ISJSON(%s, ARRAY) = 1", termConverter.apply((ImmutableTerm)terms.get(0))));
    }

    @Override
    protected String serializeWeek(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEPART(ISO_WEEK, %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeQuarter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATEPART(QUARTER, %s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDecade(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(DATEPART(YEAR, %s) / 10.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCentury(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEILING(DATEPART(YEAR, %s) / 100.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMillennium(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEILING(DATEPART(YEAR, %s) / 1000.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMilliseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(DATEPART(SECOND, %s) * 1000 + DATEPART(MILLISECOND, %s))", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMicroseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(DATEPART(SECOND, %s) * 1000000 + DATEPART(MILLISECOND, %s) * 1000 + DATEPART(MICROSECOND, %s))", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDateTrunc(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String template = String.format(" WHEN %s LIKE '%%s' THEN DATETRUNC(%%s, %s)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
        ImmutableList possibleParts = ImmutableList.of((Object)"year", (Object)"quarter", (Object)"month", (Object)"day", (Object)"week", (Object)"hour", (Object)"minute", (Object)"second", (Object)"millisecond", (Object)"microsecond");
        StringBuilder serializationBuilder = new StringBuilder("CASE");
        possibleParts.stream().forEach(part -> serializationBuilder.append(String.format(template, part, part)));
        serializationBuilder.append(" ELSE NULL END");
        return serializationBuilder.toString();
    }

    public DBFunctionSymbol getDBDateTrunc(String datePart) {
        if (ImmutableSet.of((Object)"microseconds", (Object)"milliseconds", (Object)"decade", (Object)"century", (Object)"millennium").contains((Object)datePart.toLowerCase())) {
            throw new IllegalArgumentException(String.format("SQL Server does not support DATE_TRUNC on %s.", datePart));
        }
        return super.getDBDateTrunc(datePart);
    }

    @Override
    protected DBFunctionSymbol createDBStdev(DBTermType inputType, boolean isPop, boolean isDistinct) {
        DBTermType targetType = inputType.equals(this.dbIntegerType) ? this.dbDecimalType : inputType;
        return new NullIgnoringDBStdevFunctionSymbol(isPop ? "STDEVP" : "STDEV", inputType, targetType, isPop, isDistinct);
    }

    @Override
    protected DBFunctionSymbol createDBVariance(DBTermType inputType, boolean isPop, boolean isDistinct) {
        DBTermType targetType = inputType.equals(this.dbIntegerType) ? this.dbDecimalType : inputType;
        return new NullIgnoringDBVarianceFunctionSymbol(isPop ? "VARP" : "VAR", inputType, targetType, isPop, isDistinct);
    }
}

