/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNonDeterministicNullaryFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultTimeTzNormalizationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NonSimplifiableTypedNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBGroupConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullToleratingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneLetterBooleanNormFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OneLetterDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WithoutParenthesesSimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PostgreSQLDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String RANDOM_STR = "RANDOM";
    private static final String POSITION_STR = "POSITION";
    private final DBTermType dbJsonType;
    private final DBTermType dbJsonBType;

    @Inject
    protected PostgreSQLDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(PostgreSQLDBFunctionSymbolFactory.createPostgreSQLRegularFunctionTable(typeFactory), typeFactory);
        this.dbJsonType = this.dbTypeFactory.getDBTermType("JSON");
        this.dbJsonBType = this.dbTypeFactory.getDBTermType("JSONB");
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createPostgreSQLRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        DBTermType dbStringType = dbTypeFactory.getDBStringType();
        DBTermType dbInt4 = dbTypeFactory.getDBTermType("INTEGER");
        HashBasedTable table = HashBasedTable.create(PostgreSQLDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        SimpleTypedDBFunctionSymbolImpl positionFunctionSymbol = new SimpleTypedDBFunctionSymbolImpl(POSITION_STR, 2, dbTypeFactory.getDBLargeIntegerType(), false, abstractRootDBType, (terms, termConverter, termFactory) -> String.format("position(%s in %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1))));
        table.put((Object)POSITION_STR, (Object)2, (Object)positionFunctionSymbol);
        WithoutParenthesesSimpleTypedDBFunctionSymbolImpl nowFunctionSymbol = new WithoutParenthesesSimpleTypedDBFunctionSymbolImpl("CURRENT_TIMESTAMP", dbTypeFactory.getDBDateTimestampType(), abstractRootDBType);
        table.put((Object)"CURRENT_TIMESTAMP", (Object)0, (Object)nowFunctionSymbol);
        DBFunctionSymbolWithSerializerImpl substr2FunctionSymbol = new DBFunctionSymbolWithSerializerImpl("SUBSTR2", ImmutableList.of((Object)dbStringType, (Object)dbInt4), dbStringType, false, (terms, termConverter, termFactory) -> {
            ImmutableTerm newTerm1 = termFactory.getDBCastFunctionalTerm(dbInt4, (ImmutableTerm)terms.get(1)).simplify();
            return String.format("substr(%s,%s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply(newTerm1));
        });
        table.put((Object)"SUBSTR", (Object)2, (Object)substr2FunctionSymbol);
        DBFunctionSymbolWithSerializerImpl substr3FunctionSymbol = new DBFunctionSymbolWithSerializerImpl("SUBSTR3", ImmutableList.of((Object)dbStringType, (Object)dbInt4, (Object)dbInt4), dbStringType, false, (terms, termConverter, termFactory) -> {
            ImmutableTerm newTerm1 = termFactory.getDBCastFunctionalTerm(dbInt4, (ImmutableTerm)terms.get(1)).simplify();
            ImmutableTerm newTerm2 = termFactory.getDBCastFunctionalTerm(dbInt4, (ImmutableTerm)terms.get(2)).simplify();
            return String.format("substr(%s,%s,%s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply(newTerm1), termConverter.apply(newTerm2));
        });
        table.put((Object)"SUBSTR", (Object)3, (Object)substr3FunctionSymbol);
        table.remove((Object)"REGEXP_LIKE", (Object)2);
        table.remove((Object)"REGEXP_LIKE", (Object)3);
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createNormalizationMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll((Map)super.createNormalizationMap());
        DBTermType timeStamp = this.dbTypeFactory.getDBTermType("TIMESTAMP");
        DBTypeConversionFunctionSymbol datetimeNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(timeStamp);
        builder.put((Object)timeStamp, (Object)datetimeNormFunctionSymbol);
        DBTermType timeTZType = this.dbTypeFactory.getDBTermType("TIMETZ");
        DefaultTimeTzNormalizationFunctionSymbol timeTZNormFunctionSymbol = new DefaultTimeTzNormalizationFunctionSymbol(timeTZType, this.dbStringType, (terms, termConverter, termFactory) -> String.format("REGEXP_REPLACE(CAST(%s AS TEXT),'([-+]\\d\\d)$', '\\1:00')", termConverter.apply((ImmutableTerm)terms.get(0))));
        builder.put((Object)timeTZType, (Object)timeTZNormFunctionSymbol);
        return builder.build();
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.putAll((Table)super.createNormalizationTable());
        DBTermType defaultDBGeometryType = this.dbTypeFactory.getDBGeometryType();
        DBTypeConversionFunctionSymbol geometryNormFunctionSymbol = this.createGeometryNormFunctionSymbol(defaultDBGeometryType);
        builder.put((Object)defaultDBGeometryType, (Object)this.typeFactory.getWktLiteralDatatype(), (Object)geometryNormFunctionSymbol);
        DBTermType defaultDBGeographyType = this.dbTypeFactory.getDBGeographyType();
        DBTypeConversionFunctionSymbol geographyNormFunctionSymbol = this.createGeometryNormFunctionSymbol(defaultDBGeographyType);
        builder.put((Object)defaultDBGeographyType, (Object)this.typeFactory.getWktLiteralDatatype(), (Object)geographyNormFunctionSymbol);
        return builder.build();
    }

    public DBFunctionSymbol getDBJsonEltAsText(ImmutableList<String> path) {
        return new DBFunctionSymbolWithSerializerImpl("JSON_GET_ELT_AS_TEXT:" + this.printPath(path), ImmutableList.of((Object)this.dbJsonType), this.dbStringType, false, (terms, termConverter, termFactory) -> String.format("%s#>>%s", termConverter.apply((ImmutableTerm)terms.get(0)), this.serializePath(path)));
    }

    public DBFunctionSymbol getDBJsonElt(ImmutableList<String> path) {
        return new DBFunctionSymbolWithSerializerImpl("JSON_GET_ELT:" + this.printPath(path), ImmutableList.of((Object)this.dbJsonType), this.dbJsonType, false, (terms, termConverter, termFactory) -> String.format("%s#>%s", termConverter.apply((ImmutableTerm)terms.get(0)), this.serializePath(path)));
    }

    private String serializePath(ImmutableList<String> path) {
        return "'{" + String.join((CharSequence)",", path) + "}'";
    }

    private String printPath(ImmutableList<String> path) {
        return String.join((CharSequence)".", path);
    }

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new NullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (terms, termConverter, termFactory) -> String.format("string_agg(%s%s,%s)", isDistinct ? "DISTINCT " : "", termConverter.apply(termFactory.getDBCastFunctionalTerm(this.dbTypeFactory.getDBStringType(), (ImmutableTerm)terms.get(0))), termConverter.apply((ImmutableTerm)terms.get(1))));
    }

    protected DBFunctionSymbol createTypeNullFunctionSymbol(DBTermType termType) {
        if (termType.getCastName().equals("SERIAL")) {
            return new NonSimplifiableTypedNullFunctionSymbol(termType, this.dbTypeFactory.getDBTermType("INTEGER"));
        }
        return new NonSimplifiableTypedNullFunctionSymbol(termType);
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return this.createDBConcatOperator(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, Serializers.getOperatorSerializer((String)"||"));
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullToleratingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new OneLetterDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createIsArray(DBTermType dbTermType) {
        if (dbTermType.equals(this.dbJsonType)) {
            return new DBBooleanFunctionSymbolWithSerializerImpl("JSON_IS_ARRAY", ImmutableList.of((Object)this.dbJsonType), this.dbBooleanType, false, (terms, termConverter, termFactory) -> String.format("json_typeof(%s) = 'array'", termConverter.apply((ImmutableTerm)terms.get(0))));
        }
        if (dbTermType.equals(this.dbJsonBType)) {
            return new DBBooleanFunctionSymbolWithSerializerImpl("JSONB_IS_ARRAY", ImmutableList.of((Object)this.dbJsonBType), this.dbBooleanType, false, (terms, termConverter, termFactory) -> String.format("jsonb_typeof(%s) = 'array'", termConverter.apply((ImmutableTerm)terms.get(0))));
        }
        throw new UnsupportedOperationException("Unsupported nested datatype: " + dbTermType.getName());
    }

    protected DBBooleanFunctionSymbol createJsonIsBoolean(DBTermType dbType) {
        return this.createJsonHasType("JSON_IS_BOOLEAN", dbType, (ImmutableList<String>)ImmutableList.of((Object)"boolean"));
    }

    protected DBBooleanFunctionSymbol createJsonIsScalar(DBTermType dbType) {
        return this.createJsonHasType("JSON_IS_SCALAR", dbType, (ImmutableList<String>)ImmutableList.of((Object)"boolean", (Object)"string", (Object)"number"));
    }

    protected DBBooleanFunctionSymbol createJsonIsNumber(DBTermType dbType) {
        return this.createJsonHasType("JSON_IS_NUMBER", dbType, (ImmutableList<String>)ImmutableList.of((Object)"number"));
    }

    private DBBooleanFunctionSymbol createJsonHasType(String functionName, DBTermType jsonLikeType, ImmutableList<String> types) {
        String typeOfFunctionString;
        if (jsonLikeType.equals(this.dbJsonType)) {
            typeOfFunctionString = "json_typeof";
        } else if (jsonLikeType.equals(this.dbJsonBType)) {
            typeOfFunctionString = "jsonb_typeof";
        } else {
            throw new UnsupportedOperationException("Unsupported JSON-like type: " + jsonLikeType.getName());
        }
        return new DBBooleanFunctionSymbolWithSerializerImpl(functionName, ImmutableList.of((Object)this.dbJsonType), this.dbBooleanType, false, (terms, termConverter, termFactory) -> String.format("%s(%s) IN (%s) ", typeOfFunctionString, termConverter.apply((ImmutableTerm)terms.get(0)), types.stream().map(t -> "'" + t + "'").collect(Collectors.joining(","))));
    }

    @Override
    protected String serializeDateTimeNormWithTZ(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TO_JSON(%s)#>>'{}'", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createBooleanNormFunctionSymbol(DBTermType booleanType) {
        return new OneLetterBooleanNormFunctionSymbolImpl(booleanType, this.dbStringType);
    }

    @Override
    public DBFunctionSymbol getDBSubString2() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 2);
    }

    @Override
    public DBFunctionSymbol getDBSubString3() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 3);
    }

    @Override
    public NonDeterministicDBFunctionSymbol getDBUUID(UUID uuid) {
        return new DefaultNonDeterministicNullaryFunctionSymbol("UUID", uuid, this.dbStringType, (terms, termConverter, termFactory) -> "MD5(RANDOM()::text || CLOCK_TIMESTAMP()::text)::uuid");
    }

    @Override
    protected String getRandNameInDialect() {
        return RANDOM_STR;
    }

    @Override
    protected String getUUIDNameInDialect() {
        throw new UnsupportedOperationException("Should not be used for PostgreSQL");
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(POSITION(%s IN %s) > 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,CAST (SIGN(POSITION(%s IN %s))*(POSITION(%s IN %s)-1) AS INTEGER))", str, before, str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,POSITION(%s IN %s) + LENGTH(%s), CAST( SIGN(POSITION(%s IN %s)) * LENGTH(%s) AS INTEGER))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("MD5(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("encode(digest(%s, 'sha1'), 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("encode(digest(%s, 'sha256'), 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA384(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("encode(digest(%s, 'sha384'), 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("encode(digest(%s, 'sha512'), 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(LPAD(EXTRACT(TIMEZONE_HOUR FROM %s)::text,2,'0') || ':' || LPAD(EXTRACT(TIMEZONE_MINUTE FROM %s)::text,2,'0'))", str, str);
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches2() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_LIKE2", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbBooleanType, false, Serializers.getOperatorSerializer((String)"~"));
    }

    @Override
    public DBBooleanFunctionSymbol getDBRegexpMatches3() {
        return new DBBooleanFunctionSymbolWithSerializerImpl("REGEXP_LIKE3", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType, (Object)this.abstractRootType), this.dbBooleanType, false, (terms, termConverter, termFactory) -> {
            ImmutableFunctionalTerm flagTerm = termFactory.getDBReplace((ImmutableTerm)terms.get(2), (ImmutableTerm)termFactory.getDBStringConstant("s"), (ImmutableTerm)termFactory.getDBStringConstant("n"));
            ImmutableTerm extendedPatternTerm = termFactory.getNullRejectingDBConcatFunctionalTerm(ImmutableList.of((Object)termFactory.getDBStringConstant("(?"), (Object)flagTerm, (Object)termFactory.getDBStringConstant(")"), (Object)((ImmutableTerm)terms.get(1)))).simplify();
            return String.format("%s ~ %s", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply(extendedPatternTerm));
        });
    }

    @Override
    protected DBTypeConversionFunctionSymbol createStringToStringCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        switch (inputType.getName()) {
            case "CHAR": {
                return new DefaultSimpleDBCastFunctionSymbol(inputType, targetType, Serializers.getCastSerializer((DBTermType)targetType));
            }
        }
        return super.createStringToStringCastFunctionSymbol(inputType, targetType);
    }

    @Override
    protected String serializeWeeksBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC((EXTRACT (EPOCH FROM %s) - EXTRACT (EPOCH FROM %s))/604800)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeDaysBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC((EXTRACT (EPOCH FROM %s) - EXTRACT (EPOCH FROM %s))/86400)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeHoursBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC((EXTRACT (EPOCH FROM %s) - EXTRACT (EPOCH FROM %s))/3600)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeMinutesBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC((EXTRACT (EPOCH FROM %s) - EXTRACT (EPOCH FROM %s))/60)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeSecondsBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC((EXTRACT (EPOCH FROM %s) - EXTRACT (EPOCH FROM %s)))", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeMillisBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL((EXTRACT (EPOCH FROM %s) - EXTRACT (EPOCH FROM %s))*1000)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeHexBinaryNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("upper(encode(%s, 'hex'))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeHexBinaryDenorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("decode(%s, 'hex')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    public DBFunctionSymbol getDBRegexpReplace3() {
        return new DBFunctionSymbolWithSerializerImpl("DB_REGEXP_REPLACE_3", ImmutableList.of((Object)this.abstractRootDBType, (Object)this.abstractRootDBType, (Object)this.abstractRootDBType), this.dbStringType, false, (terms, termConverter, termFactory) -> String.format("regexp_replace(%s,%s,%s,'g')", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(2))));
    }

    @Override
    protected String serializeCheckAndConvertBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(CASE WHEN CAST(%1$s AS DECIMAL) = 0 THEN 'false' WHEN %1$s = '' THEN 'false' WHEN CAST(%1$s AS DECIMAL) = 'NaN'::NUMERIC THEN 'false' ELSE 'true' END)", term);
    }

    @Override
    protected String serializeCheckAndConvertDouble(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s !~ '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$' THEN NULL ELSE CAST(%1$s AS DOUBLE PRECISION) END", term);
    }

    @Override
    protected String serializeCheckAndConvertFloat(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s !~ '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$' THEN NULL WHEN (CAST(%1$s AS FLOAT) NOT BETWEEN -3.40E38 AND -1.18E-38 AND CAST(%1$s AS FLOAT) NOT BETWEEN 1.18E-38 AND 3.40E38 AND CAST(%1$s AS FLOAT) != 0) THEN NULL ELSE CAST(%1$s AS FLOAT) END", term);
    }

    @Override
    protected String serializeCheckAndConvertFloatFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CASE WHEN %s THEN 1 ELSE 0 END", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDecimalFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1.0 WHEN %1$s THEN 1.0 WHEN %1$s='0' THEN 0.0 WHEN NOT %1$s THEN 0.0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertInteger(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s ~ '^-?([0-9]+[.]?[0-9]*|[.][0-9]+)$' THEN CAST(FLOOR(ABS(CAST(%1$s AS DECIMAL))) * SIGN(CAST(%1$s AS DECIMAL)) AS INTEGER) ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertDateFromDateTime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("DATE(%s)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN (%1$s !~ '^[0-9]{1,2}/[0-9]{1,2}/[0-9]{4}$' AND %1$s !~ '^[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}$' AND %1$s !~ '^[0-9]{1,2}-[0-9]{1,2}-[0-9]{4}$' AND %1$s !~ '^[0-9]{4}-[0-9]{1,2}-[0-9]{1,2}$' )  THEN NULL ELSE DATE(%1$s) END", term);
    }

    public DBFunctionSymbol getDBDateTrunc(String datePart) {
        if (ImmutableSet.of((Object)"microsecond", (Object)"millisecond").contains((Object)datePart.toLowerCase())) {
            throw new IllegalArgumentException("PostgreSQL does not support DATE_TRUNC on 'millisecond' or 'microsend'. Use 'milliseconds' or 'microseconds' instead.");
        }
        return super.getDBDateTrunc(datePart);
    }
}

