/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsNullOrNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsTrueFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBSampleFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultCastIntegerToStringFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNonDeterministicNullaryFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultNumberNormAsBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSQLSimpleTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.EqualsTrueDBIsTrueFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ExpressionSensitiveSQLDBIsNullOrNotFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NoDecompositionStrictEqualitySQLTimestampISONormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullToleratingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OracleDateDenormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OracleDateNormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OracleNullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.OracleTimestampISODenormFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Serializers;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WithoutParenthesesSimpleTypedDBFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.WrappedDBBooleanCaseFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class OracleDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String UNSUPPORTED_MSG = "Not supported by Oracle";
    private static final String RANDOM_STR = "DBMS_RANDOM.VALUE";
    private static final String TO_CHAR_STR = "TO_CHAR";
    private DBFunctionSymbol dbRightFunctionSymbol;

    @Inject
    protected OracleDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(OracleDBFunctionSymbolFactory.createOracleRegularFunctionTable(typeFactory), typeFactory);
    }

    @Override
    protected void init() {
        super.init();
        this.dbRightFunctionSymbol = new SimpleTypedDBFunctionSymbolImpl("RIGHT", 2, this.dbStringType, false, this.abstractRootDBType, (terms, termConverter, termFactory) -> String.format("SUBSTR(%s,-1*%s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1))));
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createOracleRegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbStringType = dbTypeFactory.getDBStringType();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        HashBasedTable table = HashBasedTable.create(OracleDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        table.remove((Object)"RIGHT", (Object)2);
        WithoutParenthesesSimpleTypedDBFunctionSymbolImpl nowFunctionSymbol = new WithoutParenthesesSimpleTypedDBFunctionSymbolImpl("CURRENT_TIMESTAMP", dbTypeFactory.getDBDateTimestampType(), abstractRootDBType);
        table.put((Object)"CURRENT_TIMESTAMP", (Object)0, (Object)nowFunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol toChar1FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(TO_CHAR_STR, 1, dbStringType, false, abstractRootDBType);
        table.put((Object)TO_CHAR_STR, (Object)1, (Object)toChar1FunctionSymbol);
        DefaultSQLSimpleTypedDBFunctionSymbol toChar2FunctionSymbol = new DefaultSQLSimpleTypedDBFunctionSymbol(TO_CHAR_STR, 2, dbStringType, false, abstractRootDBType);
        table.put((Object)TO_CHAR_STR, (Object)2, (Object)toChar2FunctionSymbol);
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createNormalizationMap() {
        HashMap<DBTermType, Object> map = new HashMap<DBTermType, Object>();
        map.putAll((Map<DBTermType, Object>)super.createNormalizationMap());
        DBTermType timestampLTzType = this.dbTypeFactory.getDBTermType("TIMESTAMP WITH LOCAL TIME ZONE");
        DBTypeConversionFunctionSymbol datetimeLTZNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(timestampLTzType);
        map.put(timestampLTzType, datetimeLTZNormFunctionSymbol);
        DBTermType timestampType = this.dbTypeFactory.getDBTermType("TIMESTAMP");
        DBTypeConversionFunctionSymbol datetimeNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(timestampType);
        map.put(timestampType, datetimeNormFunctionSymbol);
        DBTermType dbDateType = this.dbTypeFactory.getDBTermType("DATE");
        DBTypeConversionFunctionSymbol datetimeNormFunctionSymbolWoTz = this.createDateTimeNormFunctionSymbol(dbDateType);
        map.put(dbDateType, datetimeNormFunctionSymbolWoTz);
        OracleDateNormFunctionSymbol dateNormFunctionSymbol = new OracleDateNormFunctionSymbol(dbDateType, this.dbStringType);
        map.put(dbDateType, (Object)dateNormFunctionSymbol);
        return ImmutableMap.copyOf(map);
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        HashBasedTable table = HashBasedTable.create();
        table.putAll((Table)super.createNormalizationTable());
        RDFDatatype xsdBoolean = this.typeFactory.getXsdBooleanDatatype();
        DBTermType numberType = this.dbTypeFactory.getDBTermType("NUMBER");
        table.put((Object)numberType, (Object)xsdBoolean, (Object)new DefaultNumberNormAsBooleanFunctionSymbol(numberType, this.dbStringType));
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createDenormalizationMap() {
        HashMap<DBTermType, OracleDateDenormFunctionSymbol> map = new HashMap<DBTermType, OracleDateDenormFunctionSymbol>((Map<DBTermType, OracleDateDenormFunctionSymbol>)super.createDenormalizationMap());
        DBTermType dbDateType = this.dbTypeFactory.getDBTermType("DATE");
        OracleDateDenormFunctionSymbol dateDenormFunctionSymbol = new OracleDateDenormFunctionSymbol(this.dbStringType, dbDateType);
        map.put(dbDateType, dateDenormFunctionSymbol);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public DBFunctionSymbol getDBSubString2() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 2);
    }

    @Override
    public DBFunctionSymbol getDBSubString3() {
        return this.getRegularDBFunctionSymbol("SUBSTR", 3);
    }

    @Override
    public DBFunctionSymbol getDBRight() {
        return this.dbRightFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBCharLength() {
        return this.getRegularDBFunctionSymbol("LENGTH", 1);
    }

    @Override
    public NonDeterministicDBFunctionSymbol getDBRand(UUID uuid) {
        return new DefaultNonDeterministicNullaryFunctionSymbol(RANDOM_STR, uuid, this.dbDoubleType, (terms, termConverter, termFactory) -> RANDOM_STR);
    }

    @Override
    protected String getRandNameInDialect() {
        throw new UnsupportedOperationException("getRandNameInDialect() must not be called for Oracle");
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(INSTR(%s,%s) > 0)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("NVL(SUBSTR(%s,0,INSTR(%s,%s)-1),'')", str, str, before);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("CASE WHEN %s IS NULL THEN %s ELSE NVL(SUBSTR(%s,INSTR(%s,%s)+LENGTH(%s),SIGN(INSTR(%s,%s))*LENGTH(%s)),'') END", after, str, str, str, after, after, str, after, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(TO_CHAR(RAWTOHEX(SYS.DBMS_CRYPTO.HASH(UTL_I18N.STRING_TO_RAW(%s, 'AL32UTF8'), 2))))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(TO_CHAR(RAWTOHEX(SYS.DBMS_CRYPTO.HASH(UTL_I18N.STRING_TO_RAW(%s, 'AL32UTF8'), SYS.DBMS_CRYPTO.HASH_SH1))))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(TO_CHAR(RAWTOHEX(SYS.DBMS_CRYPTO.HASH(UTL_I18N.STRING_TO_RAW(%s, 'AL32UTF8'), SYS.DBMS_CRYPTO.HASH_SH256))))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA384(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(TO_CHAR(RAWTOHEX(SYS.DBMS_CRYPTO.HASH(UTL_I18N.STRING_TO_RAW(%s, 'AL32UTF8'), SYS.DBMS_CRYPTO.HASH_SH384))))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("LOWER(TO_CHAR(RAWTOHEX(SYS.DBMS_CRYPTO.HASH(UTL_I18N.STRING_TO_RAW(%s, 'AL32UTF8'), SYS.DBMS_CRYPTO.HASH_SH512))))", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected DBFunctionSymbol createTzFunctionSymbol() {
        return super.createTzFunctionSymbol();
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN EXTRACT(TIMEZONE_HOUR FROM %s) IS NOT NULL \n     THEN EXTRACT(TIMEZONE_HOUR FROM %s) || ':' || EXTRACT(TIMEZONE_MINUTE FROM %s)\n     ELSE NULL\nEND", str, str, str);
    }

    @Override
    protected String serializeDBRowNumber(Function<ImmutableTerm, String> converter, TermFactory termFactory) {
        return "ROWNUM";
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return new OracleNullRejectingDBConcatFunctionSymbol(arity, this.dbStringType, this.abstractRootDBType);
    }

    @Override
    public DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return new NullToleratingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, true);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        if (arity != 2) {
            throw new UnsupportedOperationException("CONCAT is a binary function in Oracle. Use || instead.");
        }
        return new NullToleratingDBConcatFunctionSymbol("CONCAT", 2, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createSimpleCastFunctionSymbol(DBTermType targetType) {
        if (targetType.equals(this.dbStringType)) {
            return this.createDefaultCastToStringFunctionSymbol(this.abstractRootDBType);
        }
        return super.createSimpleCastFunctionSymbol(targetType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createStringToStringCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        return this.createDefaultCastToStringFunctionSymbol(inputType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createIntegerToStringCastFunctionSymbol(DBTermType inputType) {
        return new DefaultCastIntegerToStringFunctionSymbol(inputType, this.dbStringType, Serializers.getRegularSerializer((String)TO_CHAR_STR));
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDefaultCastToStringFunctionSymbol(DBTermType inputType) {
        return new DefaultSimpleDBCastFunctionSymbol(inputType, this.dbStringType, Serializers.getRegularSerializer((String)TO_CHAR_STR));
    }

    @Override
    protected DBBooleanFunctionSymbol createDBBooleanCase(int arity, boolean doOrderingMatter) {
        return new WrappedDBBooleanCaseFunctionSymbolImpl(arity, this.dbBooleanType, this.abstractRootDBType, doOrderingMatter);
    }

    @Override
    protected DBIsNullOrNotFunctionSymbol createDBIsNull(DBTermType dbBooleanType, DBTermType rootDBTermType) {
        return new ExpressionSensitiveSQLDBIsNullOrNotFunctionSymbolImpl(true, dbBooleanType, rootDBTermType);
    }

    @Override
    protected DBIsNullOrNotFunctionSymbol createDBIsNotNull(DBTermType dbBooleanType, DBTermType rootDBTermType) {
        return new ExpressionSensitiveSQLDBIsNullOrNotFunctionSymbolImpl(false, dbBooleanType, rootDBTermType);
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDateTimeNormFunctionSymbol(DBTermType dbDateTimestampType) {
        return new NoDecompositionStrictEqualitySQLTimestampISONormFunctionSymbol(dbDateTimestampType, this.dbStringType, (terms, converter, factory) -> this.serializeDateTimeNorm(dbDateTimestampType, (ImmutableList<? extends ImmutableTerm>)terms, converter));
    }

    protected String serializeDateTimeNorm(DBTermType dbDateTimestampType, ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter) {
        if (dbDateTimestampType.equals(this.dbTypeFactory.getDBTermType("TIMESTAMP"))) {
            return String.format("REPLACE(REPLACE(TO_CHAR(%s,'YYYY-MM-DD HH24:MI:SSxFF'),' ','T'),',','.')", termConverter.apply((ImmutableTerm)terms.get(0)));
        }
        if (dbDateTimestampType.equals(this.dbTypeFactory.getDBTermType("DATE"))) {
            return String.format("REPLACE(REGEXP_REPLACE(TO_CHAR(CAST (%s AS TIMESTAMP WITH TIME ZONE),'YYYY-MM-DD HH24:MI:SSxFFTZH:TZM'),' ','T',1,1),',','.')", termConverter.apply((ImmutableTerm)terms.get(0)));
        }
        return String.format("REPLACE(REPLACE(REGEXP_REPLACE(TO_CHAR(CAST(%s AS TIMESTAMP WITH TIME ZONE),'YYYY-MM-DD HH24:MI:SSxFFTZH:TZM'),' ','T',1,1),' ',''),',','.')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBIsTrueFunctionSymbol createDBIsTrue(DBTermType dbBooleanType) {
        return new EqualsTrueDBIsTrueFunctionSymbolImpl(dbBooleanType);
    }

    @Override
    protected String serializeDateTimeNormWithTZ(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException("This method should not be called for Oracle");
    }

    @Override
    protected DBTypeConversionFunctionSymbol createDateTimeDenormFunctionSymbol(DBTermType timestampType) {
        return new OracleTimestampISODenormFunctionSymbol(timestampType, this.dbStringType);
    }

    @Override
    public NonDeterministicDBFunctionSymbol getDBUUID(UUID uuid) {
        return new DefaultNonDeterministicNullaryFunctionSymbol("UUID", uuid, this.dbStringType, (terms, termConverter, termFactory) -> "LOWER(REGEXP_REPLACE(RAWTOHEX(SYS_GUID()), '([A-F0-9]{8})([A-F0-9]{4})([A-F0-9]{4})([A-F0-9]{4})([A-F0-9]{12})', '\\1-\\2-\\3-\\4-\\5'))");
    }

    @Override
    protected String getUUIDNameInDialect() {
        throw new UnsupportedOperationException("Do not call getUUIDNameInDialect for Oracle");
    }

    @Override
    protected String serializeWeeksBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC(EXTRACT(DAY FROM %s - %s) / 7)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeWeeksBetweenFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC((%s - %s)/7)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeDaysBetweenFromDateTime(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(DAY FROM %s - %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeDaysBetweenFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("%s - %s", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeHoursBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(DAY FROM %s - %s) * 24 + EXTRACT(HOUR FROM %s - %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeMinutesBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(DAY FROM %s - %s) * 24 * 60 + EXTRACT(HOUR FROM %s - %s) * 60 + EXTRACT(MINUTE FROM %s - %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeSecondsBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("EXTRACT(DAY FROM %s - %s) * 24 * 60 * 60 + EXTRACT(HOUR FROM %s - %s) * 60 * 60 + EXTRACT(MINUTE FROM %s - %s) * 60 + EXTRACT(SECOND FROM %s - %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeMillisBetween(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(EXTRACT(DAY FROM %s - %s) * 24 * 60 * 60 + EXTRACT(HOUR FROM %s - %s) * 60 * 60 + EXTRACT(MINUTE FROM %s - %s) * 60 + EXTRACT(SECOND FROM %s - %s))*1000", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected String serializeCheckAndConvertBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(CASE WHEN %1$s = 0 THEN 0 WHEN %1$s IS NAN THEN 0 ELSE 1 END)", term);
    }

    @Override
    protected String serializeCheckAndConvertBooleanFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1 WHEN %1$s='0' THEN 0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertDouble(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN NOT REGEXP_LIKE(%1$s, '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$') THEN NULL ELSE CAST(%1$s AS DOUBLE PRECISION) END", term);
    }

    @Override
    protected String serializeCheckAndConvertFloat(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN NOT REGEXP_LIKE(%1$s, '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$') THEN NULL WHEN (CAST(%1$s AS FLOAT) NOT BETWEEN -3.40E38 AND -1.18E-38 AND CAST(%1$s AS FLOAT) NOT BETWEEN 1.18E-38 AND 3.40E38 AND CAST(%1$s AS FLOAT) != 0) THEN NULL ELSE CAST(%1$s AS FLOAT) END", term);
    }

    @Override
    protected String serializeCheckAndConvertDecimal(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN REGEXP_LIKE(%1$s, '^[-+]?[0-9]*\\.?[0-9]*$') THEN CAST(%1$s AS NUMBER) ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertInteger(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN REGEXP_LIKE(%1$s, '^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$') THEN CAST(FLOOR(ABS(CAST(%1$s AS DECIMAL(30,15)))) * SIGN(CAST(%1$s AS DECIMAL)) AS INTEGER) ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertIntegerFromBoolean(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("CASE WHEN %1$s='1' THEN 1 WHEN UPPER(%1$s) LIKE 'TRUE' THEN 1 WHEN %1$s='0' THEN 0 WHEN UPPER(%1$s) LIKE 'FALSE' THEN 0 ELSE NULL END", term);
    }

    @Override
    protected String serializeCheckAndConvertDateTimeFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TO_TIMESTAMP_TZ(REGEXP_REPLACE(%s, 'T', ' ', 1, 1), 'YYYY-MM-DD HH24:MI:SSxFFTZH:TZM')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateTimeFromDate(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TO_TIMESTAMP_TZ(TO_CHAR(%s, 'YYYY-MM-DD'), 'YYYY-MM-DD HH24:MI:SSxFFTZH:TZM')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCheckAndConvertDateFromString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TO_DATE(%s, 'YYYY-MM-DD')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected DBBooleanFunctionSymbol createIsArray(DBTermType dbTermType) {
        return new DBBooleanFunctionSymbolWithSerializerImpl("JSON_IS_ARRAY", ImmutableList.of((Object)this.typeFactory.getDBTypeFactory().getDBStringType()), this.dbBooleanType, false, (terms, termConverter, termFactory) -> String.format("SUBSTR(%s, 1, 1) = '[' AND SUBSTR(%s, LENGTH(%s), 1) = ']'", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0))));
    }

    @Override
    protected DBFunctionSymbol createDBSample(DBTermType termType) {
        return new DBSampleFunctionSymbolImpl(termType, "ANY_VALUE");
    }

    protected DBTermType inferOutputTypeMathOperator(String dbMathOperatorName, DBTermType arg1Type, DBTermType arg2Type) {
        if (dbMathOperatorName.equals("/")) {
            return this.dbDecimalType;
        }
        return super.inferOutputTypeMathOperator(dbMathOperatorName, arg1Type, arg2Type);
    }

    @Override
    protected String serializeDecade(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(EXTRACT(YEAR FROM %s) / 10.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeCentury(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 100.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMillennium(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("CEIL(EXTRACT(YEAR FROM %s) / 1000.00000)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMilliseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(EXTRACT(SECOND FROM %s) * 1000)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeMicroseconds(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(EXTRACT(SECOND FROM %s) * 1000000)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeWeek(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String term = termConverter.apply((ImmutableTerm)terms.get(0));
        return String.format("(CASE WHEN (%s >= trunc(NEXT_DAY(trunc(%s, 'YEAR') - 1, 'THURSDAY'), 'iw')) THEN FLOOR(EXTRACT(DAY FROM %s - trunc(NEXT_DAY(trunc(%s, 'YEAR') - 1, 'THURSDAY'), 'iw')) / 7.00) + 1 ELSE FLOOR(EXTRACT(DAY FROM %s - trunc(NEXT_DAY(trunc(trunc(%s, 'YEAR') - 1, 'YEAR') - 1, 'THURSDAY'), 'iw')) / 7.00) + 1 END)", term, term, term, term, term, term);
    }

    @Override
    protected String serializeQuarter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("FLOOR(EXTRACT(DAY FROM publication_date - trunc(publication_date, 'YEAR')) / 92 + 1)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected String serializeDateTrunc(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("TRUNC(%s, %s)", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    public DBFunctionSymbol getDBDateTrunc(String datePart) {
        if (ImmutableSet.of((Object)"microseconds", (Object)"milliseconds", (Object)"microsecond", (Object)"millisecond", (Object)"decade", (Object)"century", (Object[])new String[]{"millennium"}).contains((Object)datePart.toLowerCase())) {
            throw new IllegalArgumentException(String.format("Oracle does not support DATE_TRUNC on %s.", datePart));
        }
        return super.getDBDateTrunc(datePart);
    }

    public DBFunctionSymbol getNullIgnoringDBStdev(DBTermType dbType, boolean isPop, boolean isDistinct) {
        if (isDistinct) {
            throw new UnsupportedOperationException("This dialect does not allow the use of DISTINCT with the standard deviation function.");
        }
        return super.getNullIgnoringDBStdev(dbType, isPop, false);
    }

    public DBFunctionSymbol getNullIgnoringDBVariance(DBTermType dbType, boolean isPop, boolean isDistinct) {
        if (isDistinct) {
            throw new UnsupportedOperationException("This dialect does not allow the use of DISTINCT with the variance function.");
        }
        return super.getNullIgnoringDBVariance(dbType, isPop, false);
    }
}

