/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SQLSerializationException;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.StringUtils;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class SparkSQLSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    private static final String SELECT_FROM_WHERE_MODIFIERS_TEMPLATE = "SELECT %s%s\nFROM %s\n%s%s%s%s";
    private static final ImmutableMap<Character, String> BACKSLASH = ImmutableMap.of((Object)Character.valueOf('\\'), (Object)"\\\\");

    @Inject
    private SparkSQLSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory){

            @Override
            protected String serializeStringConstant(String constant) {
                return StringUtils.encode((String)super.serializeStringConstant(constant), BACKSLASH);
            }
        });
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            public SelectFromWhereSerializer.QuerySerialization visit(SelectFromWhereWithModifiers selectFromWhere) {
                SelectFromWhereSerializer.QuerySerialization fromQuerySerialization = this.getSQLSerializationForChild(selectFromWhere.getFromSQLExpression());
                ImmutableMap<Variable, QuotedID> variableAliases = this.createVariableAliases((ImmutableSet<Variable>)selectFromWhere.getProjectedVariables());
                String distinctString = selectFromWhere.isDistinct() ? "DISTINCT " : "";
                ImmutableMap<Variable, QualifiedAttributeID> columnIDs = fromQuerySerialization.getColumnIDs();
                String projectionString = this.serializeProjection(selectFromWhere.getProjectedVariables(), variableAliases, selectFromWhere.getSubstitution(), columnIDs);
                String fromString = fromQuerySerialization.getString();
                String whereString = selectFromWhere.getWhereExpression().map(e -> SparkSQLSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)e, columnIDs)).map(s -> String.format("WHERE %s\n", s)).orElse("");
                String groupByString = this.serializeGroupBy(selectFromWhere.getGroupByVariables(), columnIDs);
                String orderByString = this.serializeOrderBy(selectFromWhere.getSortConditions(), columnIDs, variableAliases, selectFromWhere.getSubstitution());
                String sliceString = this.serializeSlice(selectFromWhere.getLimit(), selectFromWhere.getOffset(), selectFromWhere.getSortConditions().isEmpty());
                String sql = String.format(SparkSQLSelectFromWhereSerializer.SELECT_FROM_WHERE_MODIFIERS_TEMPLATE, distinctString, projectionString, fromString, whereString, groupByString, orderByString, sliceString);
                RelationID alias = this.generateFreshViewAlias();
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, this.attachRelationAlias(alias, variableAliases));
            }

            private String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> columnIDs, ImmutableMap<Variable, QuotedID> variableAliases, Substitution<? extends ImmutableTerm> substitution) {
                if (sortConditions.isEmpty()) {
                    return "";
                }
                String conditionString = sortConditions.stream().map(c -> this.serializeOrderByTerm((ImmutableTerm)c.getTerm(), columnIDs, variableAliases, substitution) + (c.isAscending() ? " NULLS FIRST" : " DESC NULLS LAST")).collect(Collectors.joining(", "));
                return String.format("ORDER BY %s\n", conditionString);
            }

            private String serializeOrderByTerm(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs, ImmutableMap<Variable, QuotedID> variableAliases, Substitution<? extends ImmutableTerm> substitution) throws SQLSerializationException {
                if (term instanceof Constant) {
                    return SparkSQLSelectFromWhereSerializer.this.getTermSerializer().serialize(term, columnIDs);
                }
                if (term instanceof Variable) {
                    Optional<QuotedID> alias = Optional.ofNullable((QuotedID)variableAliases.get((Object)term));
                    return alias.map(QuotedID::getSQLRendering).orElseThrow(() -> new SQLSerializationException(String.format("Variable %s does not occur in the variableAliases %s", term, variableAliases)));
                }
                return substitution.getPreImage(t -> t.equals(term)).stream().findFirst().map(v -> ((QuotedID)variableAliases.get(v)).getSQLRendering()).orElseThrow(() -> new SQLSerializationException(String.format("Term %s does not occur in the substitution %s", term, substitution)));
            }

            @Override
            protected String formatBinaryJoin(String operatorString, SelectFromWhereSerializer.QuerySerialization left, SelectFromWhereSerializer.QuerySerialization right, String onString) {
                return String.format("(%s\n %s \n%s %s)", left.getString(), operatorString, right.getString(), onString);
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                String aliasFormat;
                String flattenCall;
                String expression;
                String string = expression = flattenedType.getCategory() == DBTermType.Category.ARRAY ? ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering() : String.format("FROM_JSON(%s, 'ARRAY<STRING>')", ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering());
                if (indexVar.isPresent()) {
                    flattenCall = String.format("POSEXPLODE_OUTER(%s)", expression);
                    aliasFormat = String.format("(%s, %s)", ((QualifiedAttributeID)allColumnIDs.get((Object)indexVar.get())).getSQLRendering(), ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering());
                } else {
                    flattenCall = String.format("EXPLODE_OUTER(%s)", expression);
                    aliasFormat = String.format("%s", ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering());
                }
                return this.serializeFlattenAsFunction(flattenedVar, allColumnIDs, subQuerySerialization, flattenCall, aliasFormat);
            }
        });
    }
}

