/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.PostgresSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public class RedshiftSelectFromWhereSerializer
extends PostgresSelectFromWhereSerializer {
    @Inject
    protected RedshiftSelectFromWhereSerializer(TermFactory termFactory) {
        super(termFactory);
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("LIMIT %d\nOFFSET %d", limit, offset);
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("%s, %s AS %s %s", subQuerySerialization.getString(), ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering(), ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering(), indexVar.map(v -> String.format(" AT %s", ((QualifiedAttributeID)allColumnIDs.get(v)).getSQLRendering())).orElse("")));
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(builder.toString(), (ImmutableMap<Variable, QualifiedAttributeID>)((ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).collect(ImmutableCollectors.toMap())));
            }
        });
    }
}

