/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.StringUtils;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class MySQLSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    private static final ImmutableMap<Character, String> BACKSLASH = ImmutableMap.of((Object)Character.valueOf('\\'), (Object)"\\\\");

    @Inject
    protected MySQLSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory){

            @Override
            protected String serializeStringConstant(String constant) {
                return StringUtils.encode((String)super.serializeStringConstant(constant), BACKSLASH);
            }
        });
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap) {
                if (sortConditions.isEmpty()) {
                    return "";
                }
                String conditionString = sortConditions.stream().map(c -> MySQLSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)c.getTerm(), fromColumnMap) + (c.isAscending() ? "" : " DESC")).collect(Collectors.joining(", "));
                return String.format("ORDER BY %s\n", conditionString);
            }

            @Override
            protected String serializeOffset(long offset, boolean noSortCondition) {
                return this.serializeLimitOffset(Long.MAX_VALUE, offset, noSortCondition);
            }

            @Override
            protected String formatBinaryJoin(String operatorString, SelectFromWhereSerializer.QuerySerialization left, SelectFromWhereSerializer.QuerySerialization right, String onString) {
                return String.format("(%s\n %s \n%s %s)", left.getString(), operatorString, right.getString(), onString);
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(MySQLSelectFromWhereSerializer.this.getFlattenFunctionFormat(), subQuerySerialization.getString(), ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering(), ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering()));
                indexVar.ifPresent(v -> builder.append(String.format(", %s for ordinality", ((QualifiedAttributeID)allColumnIDs.get(v)).getSQLRendering())));
                builder.append(")) ");
                builder.append(this.generateFreshViewAlias().getSQLRendering());
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(builder.toString(), (ImmutableMap<Variable, QualifiedAttributeID>)((ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).collect(ImmutableCollectors.toMap())));
            }
        });
    }

    protected String getFlattenFunctionFormat() {
        return "%s CROSS JOIN JSON_TABLE(JSON_ARRAY(%s), '$[0][*]' columns(%s JSON path '$'";
    }
}

